/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.remote.RemoteGroupPort;

public interface ComponentSetFilter {
    public boolean testProcessor(ProcessorNode var1);

    public boolean testReportingTask(ReportingTaskNode var1);

    public boolean testFlowAnalysisRule(FlowAnalysisRuleNode var1);

    public boolean testControllerService(ControllerServiceNode var1);

    public boolean testInputPort(Port var1);

    public boolean testOutputPort(Port var1);

    public boolean testRemoteInputPort(RemoteGroupPort var1);

    public boolean testRemoteOutputPort(RemoteGroupPort var1);

    public boolean testFlowRegistryClient(FlowRegistryClientNode var1);

    public boolean testStatelessGroup(ProcessGroup var1);

    default public ComponentSetFilter reverse() {
        final ComponentSetFilter original = this;
        return new ComponentSetFilter(){

            @Override
            public boolean testProcessor(ProcessorNode processor) {
                return !original.testProcessor(processor);
            }

            @Override
            public boolean testReportingTask(ReportingTaskNode reportingTask) {
                return !original.testReportingTask(reportingTask);
            }

            @Override
            public boolean testFlowAnalysisRule(FlowAnalysisRuleNode flowAnalysisRule) {
                return !original.testFlowAnalysisRule(flowAnalysisRule);
            }

            @Override
            public boolean testControllerService(ControllerServiceNode controllerService) {
                return !original.testControllerService(controllerService);
            }

            @Override
            public boolean testInputPort(Port port) {
                return !original.testInputPort(port);
            }

            @Override
            public boolean testOutputPort(Port port) {
                return !original.testOutputPort(port);
            }

            @Override
            public boolean testRemoteInputPort(RemoteGroupPort port) {
                return !original.testRemoteInputPort(port);
            }

            @Override
            public boolean testRemoteOutputPort(RemoteGroupPort port) {
                return !original.testRemoteOutputPort(port);
            }

            @Override
            public boolean testFlowRegistryClient(FlowRegistryClientNode flowRegistryClient) {
                return !original.testFlowRegistryClient(flowRegistryClient);
            }

            @Override
            public boolean testStatelessGroup(ProcessGroup group) {
                return !original.testStatelessGroup(group);
            }
        };
    }
}

