/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.claim;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ContentClaimWriteCache;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.apache.nifi.controller.repository.io.ContentClaimOutputStream;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;
import org.apache.nifi.controller.repository.metrics.PerformanceTrackingOutputStream;

public class StandardContentClaimWriteCache
implements ContentClaimWriteCache {
    private final ContentRepository contentRepo;
    private final Map<ResourceClaim, MappedOutputStream> streamMap = new ConcurrentHashMap<ResourceClaim, MappedOutputStream>();
    private final Queue<ContentClaim> queue = new LinkedList<ContentClaim>();
    private final PerformanceTracker performanceTracker;
    private final int bufferSize;

    public StandardContentClaimWriteCache(ContentRepository contentRepo, PerformanceTracker performanceTracker) {
        this(contentRepo, performanceTracker, 8192);
    }

    public StandardContentClaimWriteCache(ContentRepository contentRepo, PerformanceTracker performanceTracker, int bufferSize) {
        this.contentRepo = contentRepo;
        this.performanceTracker = performanceTracker;
        this.bufferSize = bufferSize;
    }

    public void reset() throws IOException {
        try {
            this.forEachStream(OutputStream::close);
        }
        finally {
            this.streamMap.clear();
            this.queue.clear();
        }
    }

    public ContentClaim getContentClaim() throws IOException {
        ContentClaim contentClaim = this.queue.poll();
        if (contentClaim != null) {
            OutputStream contentRepoStream;
            this.flush(contentClaim);
            MappedOutputStream mappedOutputStream = this.streamMap.get(contentClaim.getResourceClaim());
            if (mappedOutputStream != null && (contentRepoStream = mappedOutputStream.getContentRepoStream()) instanceof ContentClaimOutputStream) {
                return ((ContentClaimOutputStream)contentRepoStream).newContentClaim();
            }
        }
        ContentClaim claim = this.contentRepo.create(false);
        this.registerStream(claim);
        return claim;
    }

    private OutputStream registerStream(ContentClaim contentClaim) throws IOException {
        OutputStream out = this.contentRepo.write(contentClaim);
        PerformanceTrackingOutputStream performanceTrackingOut = new PerformanceTrackingOutputStream(out, this.performanceTracker);
        BufferedOutputStream buffered = new BufferedOutputStream((OutputStream)performanceTrackingOut, this.bufferSize);
        MappedOutputStream mappedOutputStream = new MappedOutputStream(out, buffered);
        this.streamMap.put(contentClaim.getResourceClaim(), mappedOutputStream);
        return buffered;
    }

    private OutputStream getWritableStream(ResourceClaim claim) {
        MappedOutputStream mappedOutputStream = this.streamMap.get(claim);
        if (mappedOutputStream == null) {
            return null;
        }
        return mappedOutputStream.getBufferedStream();
    }

    public OutputStream write(final ContentClaim claim) throws IOException {
        OutputStream out = this.getWritableStream(claim.getResourceClaim());
        if (out == null) {
            out = this.registerStream(claim);
        }
        if (!(claim instanceof StandardContentClaim)) {
            throw new IllegalArgumentException("Cannot write to " + String.valueOf(claim) + " because that Content Claim does belong to this Claim Cache");
        }
        final StandardContentClaim scc = (StandardContentClaim)claim;
        final long initialLength = Math.max(0L, scc.getLength());
        final OutputStream bcos = out;
        return new OutputStream(){
            private boolean closed = false;
            private long bytesWritten = 0L;

            @Override
            public void write(int b) throws IOException {
                bcos.write(b);
                ++this.bytesWritten;
                scc.setLength(initialLength + this.bytesWritten);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                bcos.write(b, off, len);
                this.bytesWritten += (long)len;
                scc.setLength(initialLength + this.bytesWritten);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (scc.getLength() < 0L) {
                    scc.setLength(0L);
                }
                StandardContentClaimWriteCache.this.queue.offer(claim);
            }
        };
    }

    public void flush(ContentClaim contentClaim) throws IOException {
        if (contentClaim == null) {
            return;
        }
        this.flush(contentClaim.getResourceClaim());
    }

    public void flush(ResourceClaim claim) throws IOException {
        MappedOutputStream mapped = this.streamMap.get(claim);
        if (mapped != null) {
            mapped.getBufferedStream().flush();
        }
    }

    public void flush() throws IOException {
        this.forEachStream(OutputStream::flush);
    }

    private void forEachStream(StreamProcessor proc) throws IOException {
        IOException exception = null;
        for (MappedOutputStream mapped : this.streamMap.values()) {
            try {
                proc.process(mapped.getBufferedStream());
            }
            catch (IOException ioe) {
                if (exception == null) {
                    exception = ioe;
                    continue;
                }
                ioe.addSuppressed(exception);
                exception = ioe;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static interface StreamProcessor {
        public void process(OutputStream var1) throws IOException;
    }

    private static class MappedOutputStream {
        private final OutputStream contentRepoStream;
        private final OutputStream bufferedStream;

        public MappedOutputStream(OutputStream contentRepoStream, OutputStream bufferedStream) {
            this.contentRepoStream = contentRepoStream;
            this.bufferedStream = bufferedStream;
        }

        public OutputStream getContentRepoStream() {
            return this.contentRepoStream;
        }

        public OutputStream getBufferedStream() {
            return this.bufferedStream;
        }
    }
}

