/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.StandardRepositoryRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.stateless.repository.StatelessFlowFileRepository;

public class StatelessBridgeFlowFileRepository
extends StatelessFlowFileRepository {
    private final FlowFileRepository nifiFlowFileRepository;
    private final ResourceClaimManager resourceClaimManager;

    public StatelessBridgeFlowFileRepository(FlowFileRepository nifiFlowFileRepository, ResourceClaimManager resourceClaimManager) {
        this.nifiFlowFileRepository = nifiFlowFileRepository;
        this.resourceClaimManager = resourceClaimManager;
    }

    public long getNextFlowFileSequence() {
        return this.nifiFlowFileRepository.getNextFlowFileSequence();
    }

    public void updateRepository(Collection<RepositoryRecord> records) throws IOException {
        super.updateRepository(records);
        HashSet<ContentClaim> transientClaims = new HashSet<ContentClaim>();
        for (RepositoryRecord record : records) {
            ContentClaim contentClaim;
            RepositoryRecordType type = record.getType();
            if ((type == RepositoryRecordType.DELETE || type == RepositoryRecordType.CONTENTMISSING) && this.isDestructable(contentClaim = record.getCurrentClaim())) {
                transientClaims.add(contentClaim);
            }
            if (!record.isContentModified() || !this.isDestructable(contentClaim = record.getOriginalClaim())) continue;
            transientClaims.add(contentClaim);
        }
        if (!transientClaims.isEmpty()) {
            this.nifiFlowFileRepository.updateRepository(Collections.singletonList(new StandardRepositoryRecord(transientClaims)));
        }
    }

    private boolean isDestructable(ContentClaim contentClaim) {
        if (contentClaim == null) {
            return false;
        }
        ResourceClaim resourceClaim = contentClaim.getResourceClaim();
        if (resourceClaim.isInUse()) {
            return false;
        }
        int claimantCount = this.resourceClaimManager.getClaimantCount(resourceClaim);
        return claimantCount == 0;
    }
}

