/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.controller.queue.clustered.FlowFileContentAccess;
import org.apache.nifi.controller.repository.ContentNotFoundException;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.io.LimitedInputStream;
import org.apache.nifi.stream.io.StreamUtils;

public class ContentRepositoryFlowFileAccess
implements FlowFileContentAccess {
    private final ContentRepository contentRepository;

    public ContentRepositoryFlowFileAccess(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    @Override
    public InputStream read(FlowFileRecord flowFile) throws IOException {
        InputStream rawIn;
        try {
            rawIn = this.contentRepository.read(flowFile.getContentClaim());
        }
        catch (ContentNotFoundException cnfe) {
            throw new ContentNotFoundException(flowFile, flowFile.getContentClaim(), cnfe.getMessage());
        }
        if (flowFile.getContentClaimOffset() > 0L) {
            try {
                StreamUtils.skip((InputStream)rawIn, (long)flowFile.getContentClaimOffset());
            }
            catch (EOFException eof) {
                throw new ContentNotFoundException(flowFile, flowFile.getContentClaim(), "FlowFile has a Content Claim Offset of " + flowFile.getContentClaimOffset() + " bytes but the Content Claim does not have that many bytes");
            }
        }
        LimitedInputStream limitedIn = new LimitedInputStream(rawIn, flowFile.getSize());
        return new FilterInputStream(this, (InputStream)limitedIn, (InputStream)limitedIn, flowFile){
            private long bytesRead;
            final /* synthetic */ InputStream val$limitedIn;
            final /* synthetic */ FlowFileRecord val$flowFile;
            {
                this.val$limitedIn = inputStream;
                this.val$flowFile = flowFileRecord;
                super(arg0);
                this.bytesRead = 0L;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this.ensureNotTruncated(this.val$limitedIn.read(b, off, len));
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.ensureNotTruncated(this.val$limitedIn.read(b));
            }

            @Override
            public int read() throws IOException {
                return this.ensureNotTruncated(this.val$limitedIn.read());
            }

            private int ensureNotTruncated(int length) throws EOFException {
                if (length > -1) {
                    this.bytesRead += (long)length;
                    return length;
                }
                if (this.bytesRead < this.val$flowFile.getSize()) {
                    throw new EOFException("Expected " + String.valueOf(this.val$flowFile) + " to contain " + this.val$flowFile.getSize() + " bytes but the content repository only had " + this.bytesRead + " bytes for it");
                }
                return length;
            }
        };
    }
}

