/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime.microtime;

import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.DateLocaleFactory;
import io.questdb.std.datetime.microtime.TimestampFormatCompiler;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;

public class TimestampFormatUtils {
    public static final DateFormat GREEDY_MILLIS1_UTC_FORMAT;
    public static final DateFormat GREEDY_MILLIS2_UTC_FORMAT;
    public static final int HOUR_24 = 2;
    public static final int HOUR_AM = 0;
    public static final int HOUR_PM = 1;
    public static final DateFormat NANOS_UTC_FORMAT;
    public static final DateFormat DAY_FORMAT;
    public static final DateFormat HOUR_FORMAT;
    public static final DateFormat MONTH_FORMAT;
    public static final DateFormat PG_TIMESTAMP_FORMAT;
    public static final DateFormat PG_TIMESTAMP_MILLI_TIME_Z_FORMAT;
    public static final DateFormat PG_TIMESTAMP_TIME_Z_FORMAT;
    public static final DateFormat SEC_UTC_FORMAT;
    public static final DateFormat USEC_UTC_FORMAT;
    public static final DateFormat UTC_FORMAT;
    public static final DateFormat WEEK_FORMAT;
    public static final DateFormat YEAR_FORMAT;
    public static final String DAY_PATTERN = "yyyy-MM-dd";
    public static final String HOUR_PATTERN = "yyyy-MM-ddTHH";
    public static final String MONTH_PATTERN = "yyyy-MM";
    public static final String WEEK_PATTERN = "YYYY-Www";
    public static final String YEAR_PATTERN = "yyyy";
    public static final String UTC_PATTERN = "yyyy-MM-ddTHH:mm:ss.SSSz";
    public static final DateLocale enLocale;
    private static final DateFormat[] FORMATS;
    private static final String GREEDY_MILLIS1_UTC_PATTERN = "yyyy-MM-ddTHH:mm:ss.Sz";
    private static final String GREEDY_MILLIS2_UTC_PATTERN = "yyyy-MM-ddTHH:mm:ss.SSz";
    private static final DateFormat HTTP_FORMAT;
    private static final String PG_TIMESTAMP_MILLI_TIME_Z_PATTERN = "y-MM-dd HH:mm:ss.SSSz";
    private static final String SEC_UTC_PATTERN = "yyyy-MM-ddTHH:mm:ssz";
    private static final String USEC_UTC_PATTERN = "yyyy-MM-ddTHH:mm:ss.SSSUUUz";
    static int prevCenturyLow;
    static long referenceYear;
    static int thisCenturyLimit;
    static int thisCenturyLow;
    private static long newYear;

    public static int adjustYear(int year) {
        return thisCenturyLow + year;
    }

    public static void append0(CharSink sink, int val) {
        if (Math.abs(val) < 10) {
            sink.put('0');
        }
        Numbers.append(sink, val);
    }

    public static void append00(CharSink sink, int val) {
        int v = Math.abs(val);
        if (v < 10) {
            sink.put('0').put('0');
        } else if (v < 100) {
            sink.put('0');
        }
        Numbers.append(sink, val);
    }

    public static void append00000(CharSink sink, int val) {
        int v = Math.abs(val);
        if (v < 10) {
            sink.put('0').put('0').put('0').put('0').put('0');
        } else if (v < 100) {
            sink.put('0').put('0').put('0').put('0');
        } else if (v < 1000) {
            sink.put('0').put('0').put('0');
        } else if (v < 10000) {
            sink.put('0').put('0');
        } else if (v < 100000) {
            sink.put('0');
        }
        Numbers.append(sink, val);
    }

    public static void appendAmPm(CharSink sink, int hour, DateLocale locale) {
        if (hour < 12) {
            sink.put(locale.getAMPM(0));
        } else {
            sink.put(locale.getAMPM(1));
        }
    }

    public static void appendDateTime(CharSink sink, long micros) {
        if (micros == Long.MIN_VALUE) {
            return;
        }
        UTC_FORMAT.format(micros, null, "Z", sink);
    }

    public static void appendDateTimeUSec(CharSink sink, long micros) {
        if (micros == Long.MIN_VALUE) {
            return;
        }
        USEC_UTC_FORMAT.format(micros, null, "Z", sink);
    }

    public static void appendEra(CharSink sink, int year, DateLocale locale) {
        if (year < 0) {
            sink.put(locale.getEra(0));
        } else {
            sink.put(locale.getEra(1));
        }
    }

    public static void appendHour12(CharSink sink, int hour) {
        if (hour < 12) {
            sink.put(hour);
        } else {
            sink.put(hour - 12);
        }
    }

    public static void appendHour121(CharSink sink, int hour) {
        if (hour < 12) {
            sink.put(hour + 1);
        } else {
            sink.put(hour - 11);
        }
    }

    public static void appendHour121Padded(CharSink sink, int hour) {
        if (hour < 12) {
            TimestampFormatUtils.append0(sink, hour + 1);
        } else {
            TimestampFormatUtils.append0(sink, hour - 11);
        }
    }

    public static void appendHour12Padded(CharSink sink, int hour) {
        if (hour < 12) {
            TimestampFormatUtils.append0(sink, hour);
        } else {
            TimestampFormatUtils.append0(sink, hour - 12);
        }
    }

    public static void appendYear(CharSink sink, int val) {
        Numbers.append(sink, val != 0 ? val : 1);
    }

    public static void appendYear0(CharSink sink, int val) {
        if (Math.abs(val) < 10) {
            sink.put('0');
        }
        TimestampFormatUtils.appendYear(sink, val);
    }

    public static void appendYear00(CharSink sink, int val) {
        int v = Math.abs(val);
        if (v < 10) {
            sink.put('0').put('0');
        } else if (v < 100) {
            sink.put('0');
        }
        TimestampFormatUtils.appendYear(sink, val);
    }

    public static void appendYear000(CharSink sink, int val) {
        int v = Math.abs(val);
        if (v < 10) {
            sink.put('0').put('0').put('0');
        } else if (v < 100) {
            sink.put('0').put('0');
        } else if (v < 1000) {
            sink.put('0');
        }
        TimestampFormatUtils.appendYear(sink, val);
    }

    public static void assertChar(char c, CharSequence in, int pos, int hi) throws NumericException {
        TimestampFormatUtils.assertRemaining(pos, hi);
        if (in.charAt(pos) != c) {
            throw NumericException.INSTANCE;
        }
    }

    public static void assertNoTail(int pos, int hi) throws NumericException {
        if (pos < hi) {
            throw NumericException.INSTANCE;
        }
    }

    public static void assertRemaining(int pos, int hi) throws NumericException {
        if (pos < hi) {
            return;
        }
        throw NumericException.INSTANCE;
    }

    public static int assertString(CharSequence delimiter, int len, CharSequence in, int pos, int hi) throws NumericException {
        if (delimiter.charAt(0) == '\'' && delimiter.charAt(len - 1) == '\'') {
            TimestampFormatUtils.assertRemaining(pos + len - 3, hi);
            if (!Chars.equals(delimiter, 1, len - 1, in, pos, pos + len - 2)) {
                throw NumericException.INSTANCE;
            }
            return pos + len - 2;
        }
        TimestampFormatUtils.assertRemaining(pos + len - 1, hi);
        if (!Chars.equals(delimiter, in, pos, pos + len)) {
            throw NumericException.INSTANCE;
        }
        return pos + len;
    }

    public static long compute(DateLocale locale, int era, int year, int month, int week, int day, int hour, int minute, int second, int millis, int micros, int timezone, long offset, int hourType) throws NumericException {
        if (era == 0) {
            year = -(year - 1);
        }
        boolean leap = Timestamps.isLeapYear(year);
        if (month < 1 || month > 12) {
            throw NumericException.INSTANCE;
        }
        switch (hourType) {
            case 1: {
                hour += 12;
            }
            case 2: {
                if (hour >= 0 && hour <= 23) break;
                throw NumericException.INSTANCE;
            }
            default: {
                if (hour >= 0 && hour <= 11) break;
                throw NumericException.INSTANCE;
            }
        }
        if (day < 1 || day > Timestamps.getDaysPerMonth(month, leap)) {
            throw NumericException.INSTANCE;
        }
        if (minute < 0 || minute > 59) {
            throw NumericException.INSTANCE;
        }
        if (second < 0 || second > 59) {
            throw NumericException.INSTANCE;
        }
        if (week <= 0 && week != -1 || week > Timestamps.getWeeks(year)) {
            throw NumericException.INSTANCE;
        }
        if (week != -1) {
            long firstDayOfIsoWeekMicros = Timestamps.yearMicros(year, Timestamps.isLeapYear(year)) + (long)(week - 1) * 604800000000L + (long)Timestamps.getIsoYearDayOffset(year) * 86400000000L;
            month = Timestamps.getMonthOfYear(firstDayOfIsoWeekMicros);
            day = Timestamps.getDayOfMonth(firstDayOfIsoWeekMicros, year += week == 1 && Timestamps.getIsoYearDayOffset(year) < 0 ? -1 : 0, month, Timestamps.isLeapYear(year));
        }
        long datetime = Timestamps.yearMicros(year, leap) + Timestamps.monthOfYearMicros(month, leap) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)minute * 60000000L + (long)second * 1000000L + (long)millis * 1000L + (long)micros;
        if (timezone > -1) {
            datetime -= locale.getZoneRules(timezone, 1).getOffset(datetime, year, leap);
        } else if (offset > Long.MIN_VALUE) {
            datetime -= offset;
        }
        return datetime;
    }

    public static void formatDashYYYYMMDD(CharSink sink, long millis) {
        int y = Timestamps.getYear(millis);
        boolean l = Timestamps.isLeapYear(y);
        int m = Timestamps.getMonthOfYear(millis, y, l);
        Numbers.append(sink, y);
        TimestampFormatUtils.append0(sink.put('-'), m);
        TimestampFormatUtils.append0(sink.put('-'), Timestamps.getDayOfMonth(millis, y, m, l));
    }

    public static void formatHTTP(CharSink sink, long millis) {
        HTTP_FORMAT.format(millis, enLocale, "GMT", sink);
    }

    public static void formatYYYYMM(CharSink sink, long millis) {
        int y = Timestamps.getYear(millis);
        int m = Timestamps.getMonthOfYear(millis, y, Timestamps.isLeapYear(y));
        Numbers.append(sink, y);
        TimestampFormatUtils.append0(sink.put('-'), m);
    }

    public static void formatYYYYMMDD(CharSink sink, long millis) {
        int y = Timestamps.getYear(millis);
        boolean l = Timestamps.isLeapYear(y);
        int m = Timestamps.getMonthOfYear(millis, y, l);
        Numbers.append(sink, y);
        TimestampFormatUtils.append0(sink, m);
        TimestampFormatUtils.append0(sink, Timestamps.getDayOfMonth(millis, y, m, l));
    }

    public static long getReferenceYear() {
        return referenceYear;
    }

    public static void init() {
    }

    public static long parseDateTime(CharSequence seq) throws NumericException {
        return NANOS_UTC_FORMAT.parse(seq, 0, seq.length(), enLocale);
    }

    public static long parseTimestamp(CharSequence seq) throws NumericException {
        return TimestampFormatUtils.parseTimestamp(seq, 0, seq.length());
    }

    public static long parseTimestamp(CharSequence value, int lo, int hi) throws NumericException {
        int n = FORMATS.length;
        for (int i = 0; i < n; ++i) {
            try {
                return FORMATS[i].parse(value, lo, hi, enLocale);
            }
            catch (NumericException numericException) {
                continue;
            }
        }
        throw NumericException.INSTANCE;
    }

    public static long parseUTCTimestamp(CharSequence seq) throws NumericException {
        return USEC_UTC_FORMAT.parse(seq, 0, seq.length(), enLocale);
    }

    public static long parseYearGreedy(CharSequence in, int pos, int hi) throws NumericException {
        long l = Numbers.parseIntSafely(in, pos, hi);
        int len = Numbers.decodeHighInt(l);
        int year = len == 2 ? TimestampFormatUtils.adjustYear(Numbers.decodeLowInt(l)) : Numbers.decodeLowInt(l);
        return Numbers.encodeLowHighInts(year, len);
    }

    public static long tryParse(CharSequence s, int lo, int lim) throws NumericException {
        return TimestampFormatUtils.parseTimestamp(s, lo, lim);
    }

    public static void updateReferenceYear(long micros) {
        referenceYear = micros;
        int referenceYear = Timestamps.getYear(micros);
        int centuryOffset = referenceYear % 100;
        thisCenturyLimit = centuryOffset + 20;
        if (thisCenturyLimit > 100) {
            thisCenturyLimit %= 100;
            thisCenturyLow = referenceYear - centuryOffset + 100;
        } else {
            thisCenturyLow = referenceYear - centuryOffset;
        }
        prevCenturyLow = thisCenturyLow - 100;
        newYear = Timestamps.endOfYear(referenceYear);
    }

    static {
        enLocale = DateLocaleFactory.INSTANCE.getLocale("en");
        TimestampFormatUtils.updateReferenceYear(Os.currentTimeMicros());
        TimestampFormatCompiler compiler = new TimestampFormatCompiler();
        HTTP_FORMAT = compiler.compile("E, d MMM yyyy HH:mm:ss Z");
        PG_TIMESTAMP_FORMAT = compiler.compile("y-MM-dd HH:mm:ss.SSSUUU");
        PG_TIMESTAMP_TIME_Z_FORMAT = compiler.compile("y-MM-dd HH:mm:ssz");
        NANOS_UTC_FORMAT = compiler.compile("yyyy-MM-ddTHH:mm:ss.SSSUUUNNNz");
        String[] patterns = new String[]{PG_TIMESTAMP_MILLI_TIME_Z_PATTERN, GREEDY_MILLIS1_UTC_PATTERN, USEC_UTC_PATTERN, SEC_UTC_PATTERN, GREEDY_MILLIS2_UTC_PATTERN, UTC_PATTERN, HOUR_PATTERN, DAY_PATTERN, WEEK_PATTERN, MONTH_PATTERN, YEAR_PATTERN};
        FORMATS = new DateFormat[patterns.length];
        CharSequenceObjHashMap<DateFormat> dateFormats = new CharSequenceObjHashMap<DateFormat>();
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            DateFormat format = compiler.compile(pattern);
            dateFormats.put(pattern, format);
            TimestampFormatUtils.FORMATS[i] = format;
        }
        PG_TIMESTAMP_MILLI_TIME_Z_FORMAT = (DateFormat)dateFormats.get(PG_TIMESTAMP_MILLI_TIME_Z_PATTERN);
        GREEDY_MILLIS1_UTC_FORMAT = (DateFormat)dateFormats.get(GREEDY_MILLIS1_UTC_PATTERN);
        USEC_UTC_FORMAT = (DateFormat)dateFormats.get(USEC_UTC_PATTERN);
        SEC_UTC_FORMAT = (DateFormat)dateFormats.get(SEC_UTC_PATTERN);
        GREEDY_MILLIS2_UTC_FORMAT = (DateFormat)dateFormats.get(GREEDY_MILLIS2_UTC_PATTERN);
        UTC_FORMAT = (DateFormat)dateFormats.get(UTC_PATTERN);
        HOUR_FORMAT = (DateFormat)dateFormats.get(HOUR_PATTERN);
        DAY_FORMAT = (DateFormat)dateFormats.get(DAY_PATTERN);
        WEEK_FORMAT = (DateFormat)dateFormats.get(WEEK_PATTERN);
        MONTH_FORMAT = (DateFormat)dateFormats.get(MONTH_PATTERN);
        YEAR_FORMAT = (DateFormat)dateFormats.get(YEAR_PATTERN);
    }
}

