/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Vect;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.jetbrains.annotations.Nullable;

public final class Unsafe {
    public static final long BYTE_OFFSET;
    public static final long BYTE_SCALE;
    public static final long INT_OFFSET;
    public static final long INT_SCALE;
    public static final Module JAVA_BASE_MODULE;
    public static final long LONG_OFFSET;
    public static final long LONG_SCALE;
    static final AtomicLong MEM_USED;
    private static final LongAdder[] COUNTERS;
    private static final AtomicLong FREE_COUNT;
    private static final AtomicLong MALLOC_COUNT;
    private static final long OVERRIDE;
    private static final AtomicLong REALLOC_COUNT;
    private static final sun.misc.Unsafe UNSAFE;
    private static final AnonymousClassDefiner anonymousClassDefiner;
    private static final Method implAddExports;

    private Unsafe() {
    }

    public static void addExports(Module from, Module to, String packageName) {
        try {
            implAddExports.invoke((Object)from, packageName, to);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static long arrayGetVolatile(long[] array, int index) {
        assert (index > -1 && index < array.length);
        return Unsafe.getUnsafe().getLongVolatile(array, LONG_OFFSET + ((long)index << (int)LONG_SCALE));
    }

    public static int arrayGetVolatile(int[] array, int index) {
        assert (index > -1 && index < array.length);
        return Unsafe.getUnsafe().getIntVolatile(array, INT_OFFSET + ((long)index << (int)INT_SCALE));
    }

    public static void arrayPutOrdered(long[] array, int index, long value) {
        assert (index > -1 && index < array.length);
        Unsafe.getUnsafe().putOrderedLong(array, LONG_OFFSET + ((long)index << (int)LONG_SCALE), value);
    }

    public static void arrayPutOrdered(int[] array, int index, int value) {
        assert (index > -1 && index < array.length);
        Unsafe.getUnsafe().putOrderedInt(array, INT_OFFSET + ((long)index << (int)INT_SCALE), value);
    }

    public static int byteArrayGetInt(byte[] array, int index) {
        assert (index > -1 && index < array.length - 3);
        return Unsafe.getUnsafe().getInt(array, BYTE_OFFSET + (long)index);
    }

    public static long byteArrayGetLong(byte[] array, int index) {
        assert (index > -1 && index < array.length - 7);
        return Unsafe.getUnsafe().getLong(array, BYTE_OFFSET + (long)index);
    }

    public static long calloc(long size, int memoryTag) {
        long ptr = Unsafe.malloc(size, memoryTag);
        Vect.memset(ptr, size, 0);
        return ptr;
    }

    public static boolean cas(Object o, long offset, long expected, long value) {
        return UNSAFE.compareAndSwapLong(o, offset, expected, value);
    }

    public static boolean cas(Object o, long offset, int expected, int value) {
        return UNSAFE.compareAndSwapInt(o, offset, expected, value);
    }

    public static boolean cas(long[] array, int index, long expected, long value) {
        assert (index > -1 && index < array.length);
        return Unsafe.cas((Object)array, LONG_OFFSET + ((long)index << (int)LONG_SCALE), expected, value);
    }

    @Nullable
    public static Class<?> defineAnonymousClass(Class<?> hostClass, byte[] data) {
        return anonymousClassDefiner.define(hostClass, data);
    }

    public static long free(long ptr, long size, int memoryTag) {
        if (ptr != 0L) {
            Unsafe.getUnsafe().freeMemory(ptr);
            FREE_COUNT.incrementAndGet();
            Unsafe.recordMemAlloc(-size, memoryTag);
        }
        return 0L;
    }

    public static boolean getBool(long address) {
        return UNSAFE.getByte(address) == 1;
    }

    public static long getFieldOffset(Class<?> clazz, String name) {
        try {
            return UNSAFE.objectFieldOffset(clazz.getDeclaredField(name));
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static long getFreeCount() {
        return FREE_COUNT.get();
    }

    public static long getMallocCount() {
        return MALLOC_COUNT.get();
    }

    public static long getMemUsed() {
        return MEM_USED.get();
    }

    public static long getMemUsedByTag(int memoryTag) {
        assert (memoryTag >= 0 && memoryTag < 54);
        return COUNTERS[memoryTag].sum();
    }

    public static long getReallocCount() {
        return REALLOC_COUNT.get();
    }

    public static sun.misc.Unsafe getUnsafe() {
        return UNSAFE;
    }

    public static void makeAccessible(AccessibleObject accessibleObject) {
        UNSAFE.putBooleanVolatile(accessibleObject, OVERRIDE, true);
    }

    public static long malloc(long size, int memoryTag) {
        try {
            long ptr = Unsafe.getUnsafe().allocateMemory(size);
            Unsafe.recordMemAlloc(size, memoryTag);
            MALLOC_COUNT.incrementAndGet();
            return ptr;
        }
        catch (OutOfMemoryError oom) {
            System.err.printf("Unsafe.malloc() OutOfMemoryError, mem_used=%d, size=%d, memoryTag=%d", MEM_USED.get(), size, memoryTag);
            throw oom;
        }
    }

    public static long realloc(long address, long oldSize, long newSize, int memoryTag) {
        try {
            long ptr = Unsafe.getUnsafe().reallocateMemory(address, newSize);
            Unsafe.recordMemAlloc(-oldSize + newSize, memoryTag);
            REALLOC_COUNT.incrementAndGet();
            return ptr;
        }
        catch (OutOfMemoryError oom) {
            System.err.printf("Unsafe.realloc() OutOfMemoryError, mem_used=%d, old_size=%d, new_size=%d, memoryTag=%d", MEM_USED.get(), oldSize, newSize, memoryTag);
            throw oom;
        }
    }

    public static void recordMemAlloc(long size, int memoryTag) {
        long mem = MEM_USED.addAndGet(size);
        assert (mem >= 0L);
        assert (memoryTag >= 0 && memoryTag < 54);
        COUNTERS[memoryTag].add(size);
    }

    private static long AccessibleObject_override_fieldOffset() {
        if (Unsafe.isJava8Or11()) {
            return Unsafe.getFieldOffset(AccessibleObject.class, "override");
        }
        boolean is32BitJVM = Unsafe.is32BitJVM();
        if (is32BitJVM) {
            return 8L;
        }
        if (Unsafe.getOrdinaryObjectPointersCompressionStatus(is32BitJVM)) {
            return 12L;
        }
        return 16L;
    }

    private static boolean getOrdinaryObjectPointersCompressionStatus(boolean is32BitJVM) {
        class Probe {
            private int intField;
            final /* synthetic */ boolean val$is32BitJVM;

            Probe(boolean bl) {
                this.val$is32BitJVM = bl;
            }

            boolean probe() {
                long offset = Unsafe.getFieldOffset(Probe.class, "intField");
                if (offset == 8L) {
                    assert (this.val$is32BitJVM);
                    return false;
                }
                if (offset == 12L) {
                    return true;
                }
                if (offset == 16L) {
                    return false;
                }
                throw new AssertionError(offset);
            }
        }
        return new Probe(is32BitJVM).probe();
    }

    private static boolean is32BitJVM() {
        String sunArchDataModel = System.getProperty("sun.arch.data.model");
        return sunArchDataModel.equals("32");
    }

    private static boolean isJava8Or11() {
        String javaVersion = System.getProperty("java.version");
        return javaVersion.startsWith("11") || javaVersion.startsWith("1.8");
    }

    private static int msb(int value) {
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    static {
        JAVA_BASE_MODULE = System.class.getModule();
        MEM_USED = new AtomicLong(0L);
        COUNTERS = new LongAdder[54];
        FREE_COUNT = new AtomicLong(0L);
        MALLOC_COUNT = new AtomicLong(0L);
        REALLOC_COUNT = new AtomicLong(0L);
        try {
            Field theUnsafe = sun.misc.Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (sun.misc.Unsafe)theUnsafe.get(null);
            BYTE_OFFSET = Unsafe.getUnsafe().arrayBaseOffset(byte[].class);
            BYTE_SCALE = Unsafe.msb(Unsafe.getUnsafe().arrayIndexScale(byte[].class));
            INT_OFFSET = Unsafe.getUnsafe().arrayBaseOffset(int[].class);
            INT_SCALE = Unsafe.msb(Unsafe.getUnsafe().arrayIndexScale(int[].class));
            LONG_OFFSET = Unsafe.getUnsafe().arrayBaseOffset(long[].class);
            LONG_SCALE = Unsafe.msb(Unsafe.getUnsafe().arrayIndexScale(long[].class));
            OVERRIDE = Unsafe.AccessibleObject_override_fieldOffset();
            implAddExports = Module.class.getDeclaredMethod("implAddExports", String.class, Module.class);
            AnonymousClassDefiner classDefiner = UnsafeClassDefiner.newInstance();
            if (classDefiner == null) {
                classDefiner = MethodHandlesClassDefiner.newInstance();
            }
            if (classDefiner == null) {
                throw new InstantiationException("failed to initialize class definer");
            }
            anonymousClassDefiner = classDefiner;
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        Unsafe.makeAccessible(implAddExports);
        for (int i = 0; i < COUNTERS.length; ++i) {
            Unsafe.COUNTERS[i] = new LongAdder();
        }
    }

    static class UnsafeClassDefiner
    implements AnonymousClassDefiner {
        private static Method defineMethod;

        UnsafeClassDefiner() {
        }

        @Nullable
        public static UnsafeClassDefiner newInstance() {
            if (defineMethod == null) {
                try {
                    defineMethod = sun.misc.Unsafe.class.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
                }
                catch (ReflectiveOperationException e) {
                    return null;
                }
            }
            return new UnsafeClassDefiner();
        }

        @Override
        public Class<?> define(Class<?> hostClass, byte[] data) {
            try {
                return (Class)defineMethod.invoke((Object)UNSAFE, hostClass, data, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    static class MethodHandlesClassDefiner
    implements AnonymousClassDefiner {
        private static Method defineMethod;
        private static Object hiddenClassOptions;
        private static Object lookupBase;
        private static long lookupOffset;

        MethodHandlesClassDefiner() {
        }

        @Nullable
        public static MethodHandlesClassDefiner newInstance() {
            if (defineMethod == null) {
                try {
                    Field trustedLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                    lookupBase = UNSAFE.staticFieldBase(trustedLookupField);
                    lookupOffset = UNSAFE.staticFieldOffset(trustedLookupField);
                    hiddenClassOptions = MethodHandlesClassDefiner.hiddenClassOptions("NESTMATE");
                    defineMethod = MethodHandles.Lookup.class.getMethod("defineHiddenClass", byte[].class, Boolean.TYPE, hiddenClassOptions.getClass());
                }
                catch (ReflectiveOperationException e) {
                    return null;
                }
            }
            return new MethodHandlesClassDefiner();
        }

        @Override
        public Class<?> define(Class<?> hostClass, byte[] data) {
            try {
                MethodHandles.Lookup trustedLookup = (MethodHandles.Lookup)UNSAFE.getObject(lookupBase, lookupOffset);
                MethodHandles.Lookup definedLookup = (MethodHandles.Lookup)defineMethod.invoke((Object)trustedLookup.in(hostClass), data, false, hiddenClassOptions);
                return definedLookup.lookupClass();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private static Object hiddenClassOptions(String ... options) throws ClassNotFoundException {
            Class<?> optionClass = Class.forName(MethodHandles.Lookup.class.getName() + "$ClassOption");
            Object classOptions = Array.newInstance(optionClass, options.length);
            for (int i = 0; i < options.length; ++i) {
                Array.set(classOptions, i, Enum.valueOf(optionClass, options[i]));
            }
            return classOptions;
        }
    }

    static interface AnonymousClassDefiner {
        public Class<?> define(Class<?> var1, byte[] var2);
    }
}

