/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.ImplicitCastException;
import io.questdb.std.Chars;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256FromCharSequenceDecoder;
import io.questdb.std.Long256Impl;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.fastdouble.FastDoubleParser;
import io.questdb.std.fastdouble.FastFloatParser;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import java.util.Arrays;
import jdk.internal.math.FDBigInteger;
import org.jetbrains.annotations.NotNull;

public final class Numbers {
    public static final int INT_NaN = Integer.MIN_VALUE;
    public static final long JULIAN_EPOCH_OFFSET_USEC = 946684800000000L;
    public static final long LONG_NaN = Long.MIN_VALUE;
    public static final int MAX_SCALE = 19;
    public static final int SIGNIFICAND_WIDTH = 53;
    public static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    public static final int SIZE_1MB = 0x100000;
    public static final long SIZE_1GB = 0x40000000L;
    public static final long SIZE_1TB = 0x10000000000L;
    public static final double TOLERANCE = 1.0E-15;
    public static final char[] hexDigits;
    public static final int[] hexNumbers;
    public static final int pow10max;
    private static final int EXP_BIAS = 1023;
    private static final long EXP_BIT_MASK = 0x7FF0000000000000L;
    private static final int EXP_SHIFT = 52;
    static final long EXP_ONE = 0x3FF0000000000000L;
    private static final long FRACT_HOB = 0x10000000000000L;
    private static final long[] LONG_5_POW;
    private static final int MAX_SMALL_BIN_EXP = 62;
    private static final int MIN_SMALL_BIN_EXP = -21;
    private static final int[] N_5_BITS;
    private static final long SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final int[] SMALL_5_POW;
    private static final int[] insignificantDigitsNumber;
    private static final LongHexAppender[] longHexAppender;
    private static final LongHexAppender[] longHexAppenderPad64;
    private static final long[] pow10;
    private static final double[] pow10dNeg;

    private Numbers() {
    }

    public static void append(CharSink sink, float value, int scale) {
        int z;
        int targetScale;
        float f = value;
        if (f == Float.POSITIVE_INFINITY) {
            sink.put("Infinity");
            return;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            sink.put("-Infinity");
            return;
        }
        if (Float.isNaN(f)) {
            sink.put("NaN");
            return;
        }
        if (f < 0.0f || 1.0f / f == Float.NEGATIVE_INFINITY) {
            sink.put('-');
            f = -f;
        }
        int factor = (int)pow10[scale];
        int scaled = (int)((double)(f * (float)factor) + 0.5);
        for (targetScale = scale + 1; targetScale < 11 && (z = factor * 10) <= scaled; ++targetScale) {
            factor = z;
        }
        if (targetScale == 11) {
            sink.put(Float.toString(f));
            return;
        }
        while (targetScale > 0) {
            if (targetScale-- == scale) {
                sink.put('.');
            }
            sink.put((char)(48 + scaled / factor % 10));
            factor /= 10;
        }
    }

    public static void append(CharSink sink, int value) {
        int i = value;
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                sink.put("NaN");
                return;
            }
            sink.put('-');
            i = -i;
        }
        if (i < 10) {
            sink.put((char)(48 + i));
        } else if (i < 100) {
            Numbers.appendInt2(sink, i);
        } else if (i < 1000) {
            Numbers.appendInt3(sink, i);
        } else if (i < 10000) {
            Numbers.appendInt4(sink, i);
        } else if (i < 100000) {
            Numbers.appendInt5(sink, i);
        } else if (i < 1000000) {
            Numbers.appendInt6(sink, i);
        } else if (i < 10000000) {
            Numbers.appendInt7(sink, i);
        } else if (i < 100000000) {
            Numbers.appendInt8(sink, i);
        } else if (i < 1000000000) {
            Numbers.appendInt9(sink, i);
        } else {
            Numbers.appendInt10(sink, i);
        }
    }

    public static void append(CharSink sink, long value) {
        Numbers.append(sink, value, true);
    }

    public static void append(CharSink sink, long value, boolean checkNaN) {
        long i = value;
        if (i < 0L) {
            if (i == Long.MIN_VALUE) {
                if (checkNaN) {
                    sink.put("NaN");
                } else {
                    sink.put("-9223372036854775808");
                }
                return;
            }
            sink.put('-');
            i = -i;
        }
        if (i < 10L) {
            sink.put((char)(48L + i));
        } else if (i < 100L) {
            Numbers.appendLong2(sink, i);
        } else if (i < 1000L) {
            Numbers.appendLong3(sink, i);
        } else if (i < 10000L) {
            Numbers.appendLong4(sink, i);
        } else if (i < 100000L) {
            Numbers.appendLong5(sink, i);
        } else if (i < 1000000L) {
            Numbers.appendLong6(sink, i);
        } else if (i < 10000000L) {
            Numbers.appendLong7(sink, i);
        } else if (i < 100000000L) {
            Numbers.appendLong8(sink, i);
        } else if (i < 1000000000L) {
            Numbers.appendLong9(sink, i);
        } else if (i < 10000000000L) {
            Numbers.appendLong10(sink, i);
        } else if (i < 100000000000L) {
            Numbers.appendLong11(sink, i);
        } else if (i < 1000000000000L) {
            Numbers.appendLong12(sink, i);
        } else if (i < 10000000000000L) {
            Numbers.appendLong13(sink, i);
        } else if (i < 100000000000000L) {
            Numbers.appendLong14(sink, i);
        } else if (i < 1000000000000000L) {
            Numbers.appendLong15(sink, i);
        } else if (i < 10000000000000000L) {
            Numbers.appendLong16(sink, i);
        } else if (i < 100000000000000000L) {
            Numbers.appendLong17(sink, i);
        } else if (i < 1000000000000000000L) {
            Numbers.appendLong18(sink, i);
        } else {
            Numbers.appendLong19(sink, i);
        }
    }

    public static void append(CharSink sink, double value) {
        Numbers.append(sink, value, 19);
    }

    public static void append(CharSink sink, double value, int scale) {
        char[] digits = sink.getDoubleDigitsBuffer();
        long doubleBits = Double.doubleToRawLongBits(value);
        boolean negative = (doubleBits & Long.MIN_VALUE) != 0L;
        long significantBitCount = doubleBits & 0xFFFFFFFFFFFFFL;
        int binExp = (int)((doubleBits & 0x7FF0000000000000L) >> 52);
        if (binExp == 2047) {
            if (significantBitCount == 0L) {
                if (negative) {
                    sink.put("-Infinity");
                } else {
                    sink.put("Infinity");
                }
            } else {
                sink.put("NaN");
            }
        } else {
            int fractionBits;
            if (binExp == 0) {
                if (significantBitCount == 0L) {
                    if (negative) {
                        sink.put("-0.0");
                    } else {
                        sink.put("0.0");
                    }
                    return;
                }
                int leadingZeros = Long.numberOfLeadingZeros(significantBitCount);
                int shift = leadingZeros - 11;
                significantBitCount <<= shift;
                binExp = 1 - shift;
                fractionBits = 64 - leadingZeros;
            } else {
                significantBitCount |= 0x10000000000000L;
                fractionBits = 53;
            }
            Numbers.appendDouble0(binExp -= 1023, significantBitCount, fractionBits, negative, digits, sink, scale);
        }
    }

    public static void appendHex(CharSink sink, int value) {
        int i = value;
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                sink.put("NaN");
                return;
            }
            sink.put('-');
            i = -i;
        }
        if (i < 16) {
            sink.put('0');
            sink.put(hexDigits[i]);
        } else if (i < 256) {
            sink.put(hexDigits[i / 16]);
            sink.put(hexDigits[i % 16]);
        } else if (i < 4096) {
            sink.put('0');
            sink.put(hexDigits[i / 256]);
            int c = i % 256;
            sink.put(hexDigits[c / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 65536) {
            sink.put(hexDigits[i / 4096]);
            int c = i % 4096;
            sink.put(hexDigits[c / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 0x100000) {
            sink.put('0');
            sink.put(hexDigits[i / 65536]);
            int c = i % 65536;
            sink.put(hexDigits[c / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 0x1000000) {
            sink.put(hexDigits[i / 0x100000]);
            int c = i % 0x100000;
            sink.put(hexDigits[c / 65536]);
            sink.put(hexDigits[(c %= 65536) / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 0x10000000) {
            sink.put('0');
            sink.put(hexDigits[i / 0x1000000]);
            int c = i % 0x1000000;
            sink.put(hexDigits[c / 0x100000]);
            sink.put(hexDigits[(c %= 0x100000) / 65536]);
            sink.put(hexDigits[(c %= 65536) / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else {
            sink.put(hexDigits[i / 0x10000000]);
            int c = i % 0x10000000;
            sink.put(hexDigits[c / 0x1000000]);
            sink.put(hexDigits[(c %= 0x1000000) / 0x100000]);
            sink.put(hexDigits[(c %= 0x100000) / 65536]);
            sink.put(hexDigits[(c %= 65536) / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        }
    }

    public static void appendHex(CharSink sink, long value, boolean pad) {
        if (value == Integer.MIN_VALUE) {
            sink.put("NaN");
            return;
        }
        int bit = value == 0L ? 0 : 64 - Long.numberOfLeadingZeros(value);
        LongHexAppender[] array = pad ? longHexAppenderPad64 : longHexAppender;
        array[bit].append(sink, value);
    }

    public static void appendHexPadded(CharSink sink, long value, int padToBytes) {
        assert (padToBytes >= 0 && padToBytes <= 8);
        int leadingZeroBits = Long.numberOfLeadingZeros(value);
        int padToBits = padToBytes << 3;
        int bitsToPad = padToBits - (64 - leadingZeroBits);
        int bytesToPad = bitsToPad >> 3;
        for (int i = 0; i < bytesToPad; ++i) {
            sink.put('0');
            sink.put('0');
        }
        if (value == 0L) {
            return;
        }
        int bit = 64 - leadingZeroBits;
        longHexAppender[bit].append(sink, value);
    }

    public static void appendHexPadded(CharSink sink, int value) {
        int i = value;
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                sink.put("NaN");
                return;
            }
            sink.put('-');
            i = -i;
        }
        if (i < 16) {
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put(hexDigits[i]);
        } else if (i < 256) {
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put(hexDigits[i / 16]);
            sink.put(hexDigits[i % 16]);
        } else if (i < 4096) {
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put(hexDigits[i / 256]);
            int c = i % 256;
            sink.put(hexDigits[c / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 65536) {
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put(hexDigits[i / 4096]);
            int c = i % 4096;
            sink.put(hexDigits[c / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 0x100000) {
            sink.put('0');
            sink.put('0');
            sink.put('0');
            sink.put(hexDigits[i / 65536]);
            int c = i % 65536;
            sink.put(hexDigits[c / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 0x1000000) {
            sink.put('0');
            sink.put('0');
            sink.put(hexDigits[i / 0x100000]);
            int c = i % 0x100000;
            sink.put(hexDigits[c / 65536]);
            sink.put(hexDigits[(c %= 65536) / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 0x10000000) {
            sink.put('0');
            sink.put(hexDigits[i / 0x1000000]);
            int c = i % 0x1000000;
            sink.put(hexDigits[c / 0x100000]);
            sink.put(hexDigits[(c %= 0x100000) / 65536]);
            sink.put(hexDigits[(c %= 65536) / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else {
            sink.put(hexDigits[i / 0x10000000]);
            int c = i % 0x10000000;
            sink.put(hexDigits[c / 0x1000000]);
            sink.put(hexDigits[(c %= 0x1000000) / 0x100000]);
            sink.put(hexDigits[(c %= 0x100000) / 65536]);
            sink.put(hexDigits[(c %= 65536) / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        }
    }

    public static void appendLong256(long a, long b, long c, long d, CharSink sink) {
        if (a == Long.MIN_VALUE && b == Long.MIN_VALUE && c == Long.MIN_VALUE && d == Long.MIN_VALUE) {
            return;
        }
        sink.put("0x");
        if (d != 0L) {
            Numbers.appendLong256Four(a, b, c, d, sink);
            return;
        }
        if (c != 0L) {
            Numbers.appendLong256Three(a, b, c, sink);
            return;
        }
        if (b != 0L) {
            Numbers.appendLong256Two(a, b, sink);
            return;
        }
        Numbers.appendHex(sink, a, false);
    }

    public static void appendUuid(long lo, long hi, CharSink sink) {
        Numbers.appendHexPadded(sink, hi >> 32 & 0xFFFFFFFFL, 4);
        sink.put('-');
        Numbers.appendHexPadded(sink, hi >> 16 & 0xFFFFL, 2);
        sink.put('-');
        Numbers.appendHexPadded(sink, hi & 0xFFFFL, 2);
        sink.put('-');
        Numbers.appendHexPadded(sink, lo >> 48 & 0xFFFFL, 2);
        sink.put('-');
        Numbers.appendHexPadded(sink, lo & 0xFFFFFFFFFFFFL, 6);
    }

    public static int bswap(int value) {
        return value >> 24 & 0xFF | value << 8 & 0xFF0000 | value >> 8 & 0xFF00 | value << 24 & 0xFF000000;
    }

    public static short bswap(short value) {
        return (short)((value >> 8 & 0xFF | value << 8) & 0xFFFF);
    }

    public static long bswap(long val) {
        val = val << 8 & 0xFF00FF00FF00FF00L | val >> 8 & 0xFF00FF00FF00FFL;
        val = val << 16 & 0xFFFF0000FFFF0000L | val >> 16 & 0xFFFF0000FFFFL;
        return val << 32 | val >> 32 & 0xFFFFFFFFL;
    }

    public static int ceilPow2(int value) {
        int i = value;
        if (i != 0 && (i & i - 1) > 0) {
            i |= i >>> 1;
            i |= i >>> 2;
            i |= i >>> 4;
            i |= i >>> 8;
            i |= i >>> 16;
            if (++i < 0) {
                i >>>= 1;
            }
        }
        return i;
    }

    public static long ceilPow2(long value) {
        long i = value;
        if (i != 0L && (i & i - 1L) > 0L) {
            i |= i >>> 1;
            i |= i >>> 2;
            i |= i >>> 4;
            i |= i >>> 8;
            i |= i >>> 16;
            i |= i >>> 32;
            if (++i < 0L) {
                i >>>= 1;
            }
        }
        return i;
    }

    public static int compare(double a, double b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        long thisBits = Double.doubleToLongBits(a);
        long anotherBits = Double.doubleToLongBits(b);
        return Long.compare(thisBits, anotherBits);
    }

    public static int compare(float a, float b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        int thisBits = Float.floatToIntBits(a);
        int anotherBits = Float.floatToIntBits(b);
        return Integer.compare(thisBits, anotherBits);
    }

    public static int decodeHighInt(long val) {
        return (int)(val >> 32);
    }

    public static short decodeHighShort(int val) {
        return (short)(val >> 16);
    }

    public static int decodeLowInt(long val) {
        return (int)(val & 0xFFFFFFFFL);
    }

    public static short decodeLowShort(int val) {
        return (short)(val & 0xFFFF);
    }

    public static long encodeLowHighInts(int low, int high) {
        return Integer.toUnsignedLong(high) << 32 | Integer.toUnsignedLong(low);
    }

    public static int encodeLowHighShorts(short low, short high) {
        return Short.toUnsignedInt(high) << 16 | Short.toUnsignedInt(low);
    }

    public static boolean equals(double l, double r) {
        return Double.isNaN(l) && Double.isNaN(r) || Math.abs(l - r) < 1.0E-10 || l == r;
    }

    public static boolean extractLong256(CharSequence value, int len, Long256Acceptor acceptor) {
        if (len > 2 && (len & 1) == 0 && len < 67 && value.charAt(0) == '0' && value.charAt(1) == 'x') {
            try {
                Long256FromCharSequenceDecoder.decode(value, 2, len, acceptor);
                return true;
            }
            catch (ImplicitCastException e) {
                return false;
            }
        }
        return false;
    }

    public static int hexToDecimal(int c) throws NumericException {
        if (c > 127) {
            throw NumericException.INSTANCE;
        }
        int r = hexNumbers[c];
        if (r == -1) {
            throw NumericException.INSTANCE;
        }
        return r;
    }

    public static double intToDouble(int value) {
        if (value != Integer.MIN_VALUE) {
            return value;
        }
        return Double.NaN;
    }

    public static float intToFloat(int value) {
        if (value != Integer.MIN_VALUE) {
            return value;
        }
        return Float.NaN;
    }

    public static long intToLong(int value) {
        if (value != Integer.MIN_VALUE) {
            return value;
        }
        return Long.MIN_VALUE;
    }

    public static long interleaveBits(long x, long y) {
        return Numbers.spreadBits(x) | Numbers.spreadBits(y) << 1;
    }

    public static boolean isFinite(double d) {
        return (Double.doubleToRawLongBits(d) & 0x7FF0000000000000L) != 0x7FF0000000000000L;
    }

    public static boolean isPow2(int value) {
        return (value & value - 1) == 0;
    }

    public static float longToFloat(long value) {
        if (value != Long.MIN_VALUE) {
            return value;
        }
        return Float.NaN;
    }

    public static int msb(int value) {
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static int msb(long value) {
        return 63 - Long.numberOfLeadingZeros(value);
    }

    public static boolean notDigit(char c) {
        return c < '0' || c > '9';
    }

    public static double parseDouble(CharSequence sequence) throws NumericException {
        return FastDoubleParser.parseDouble(sequence, true);
    }

    public static double parseDouble(long str, int len) throws NumericException {
        return FastDoubleParser.parseDouble(str, len, true);
    }

    public static double parseDoubleQuiet(CharSequence sequence) {
        if (sequence == null) {
            return Double.NaN;
        }
        try {
            return Numbers.parseDouble(sequence);
        }
        catch (NumericException e) {
            return Double.NaN;
        }
    }

    public static float parseFloat(CharSequence sequence) throws NumericException {
        return FastFloatParser.parseFloat(sequence, true);
    }

    public static int parseHexInt(CharSequence sequence) throws NumericException {
        return Numbers.parseHexInt(sequence, 0, sequence.length());
    }

    public static int parseHexInt(CharSequence sequence, int lo, int hi) throws NumericException {
        if (hi == 0) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        for (int i = lo; i < hi; ++i) {
            int r;
            char c = sequence.charAt(i);
            int n = val << 4;
            val = r = n + Numbers.hexToDecimal(c);
        }
        return val;
    }

    public static long parseHexLong(CharSequence sequence) throws NumericException {
        return Numbers.parseHexLong(sequence, 0, sequence.length());
    }

    public static long parseHexLong(CharSequence sequence, int lo, int hi) throws NumericException {
        if (hi == 0) {
            throw NumericException.INSTANCE;
        }
        long val = 0L;
        for (int i = lo; i < hi; ++i) {
            long r;
            char c = sequence.charAt(i);
            long n = val << 4;
            val = r = n + (long)Numbers.hexToDecimal(c);
        }
        return val;
    }

    public static int parseInt(CharSequence sequence) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseInt0(sequence, 0, sequence.length());
    }

    public static int parseInt(CharSequence sequence, int p, int lim) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseInt0(sequence, p, lim);
    }

    public static long parseInt000Greedy(CharSequence sequence, int p, int lim) throws NumericException {
        char c;
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(p) == '-';
        int i = p;
        if (negative) {
            ++i;
        }
        if (i >= lim || Numbers.notDigit(sequence.charAt(i))) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        while (i < lim && !Numbers.notDigit(c = sequence.charAt(i))) {
            int r = (val << 3) + (val << 1) - (c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        int len = i - p;
        if (len > 3 || val == Integer.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        while (i - p < 3) {
            val *= 10;
            ++i;
        }
        return Numbers.encodeLowHighInts(negative ? val : -val, len);
    }

    public static int parseIntQuiet(CharSequence sequence) {
        try {
            if (sequence == null || Chars.equals((CharSequence)"NaN", sequence)) {
                return Integer.MIN_VALUE;
            }
            return Numbers.parseInt0(sequence, 0, sequence.length());
        }
        catch (NumericException e) {
            return Integer.MIN_VALUE;
        }
    }

    public static long parseIntSafely(CharSequence sequence, int p, int lim) throws NumericException {
        char c;
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(p) == '-';
        int i = p;
        if (negative) {
            ++i;
        }
        if (i >= lim || Numbers.notDigit(sequence.charAt(i))) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        while (i < lim && !Numbers.notDigit(c = sequence.charAt(i))) {
            int r = (val << 3) + (val << 1) - (c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val == Integer.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        return Numbers.encodeLowHighInts(negative ? val : -val, i - p);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseIntSize(CharSequence sequence) throws NumericException {
        int lim = sequence.length();
        if (lim == 0) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(0) == '-';
        int i = 0;
        if (negative) {
            ++i;
        }
        if (i >= lim) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        block4: while (i < lim) {
            int r;
            char c = sequence.charAt(i);
            if (c < '0' || c > '9') {
                if (i != lim - 1) throw NumericException.INSTANCE;
                switch (c) {
                    case 'K': 
                    case 'k': {
                        r = val * 1024;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block4;
                    }
                    case 'M': 
                    case 'm': {
                        r = val * 1024 * 1024;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block4;
                    }
                    default: {
                        throw NumericException.INSTANCE;
                    }
                }
            }
            r = (val << 3) + (val << 1) - (c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val != Integer.MIN_VALUE || negative) return negative ? val : -val;
        throw NumericException.INSTANCE;
    }

    public static long parseLong(CharSequence sequence) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseLong0(sequence, 0, sequence.length());
    }

    public static long parseLong(CharSequence sequence, int p, int lim) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseLong0(sequence, p, lim);
    }

    public static long parseLong000000Greedy(CharSequence sequence, int p, int lim) throws NumericException {
        char c;
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(p) == '-';
        int i = p;
        if (negative) {
            ++i;
        }
        if (i >= lim || Numbers.notDigit(sequence.charAt(i))) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        while (i < lim && !Numbers.notDigit(c = sequence.charAt(i))) {
            int r = (val << 3) + (val << 1) - (c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        int len = i - p;
        if (len > 6 || val == Integer.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        while (i - p < 6) {
            val *= 10;
            ++i;
        }
        return Numbers.encodeLowHighInts(negative ? val : -val, len);
    }

    @NotNull
    public static Long256Impl parseLong256(CharSequence text, int len, Long256Impl long256) {
        return Numbers.extractLong256(text, len, long256) ? long256 : Long256Impl.NULL_LONG256;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long parseLongDuration(CharSequence sequence) throws NumericException {
        boolean negative;
        int lim = sequence.length();
        if (lim == 0) {
            throw NumericException.INSTANCE;
        }
        boolean bl = negative = sequence.charAt(0) == '-';
        if (negative) {
            throw NumericException.INSTANCE;
        }
        long val = 0L;
        block9: for (int i = 0; i < lim; ++i) {
            long r;
            char c = sequence.charAt(i);
            if (c < '0' || c > '9') {
                if (i != lim - 1) throw NumericException.INSTANCE;
                switch (c) {
                    case 's': {
                        r = val * 1000000L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block9;
                    }
                    case 'm': {
                        r = val * 60000000L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block9;
                    }
                    case 'h': {
                        r = val * 3600000000L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block9;
                    }
                    case 'd': {
                        r = val * 86400000000L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block9;
                    }
                    case 'w': {
                        r = val * 604800000000L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block9;
                    }
                    case 'M': {
                        r = val * 86400000000L * 30L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block9;
                    }
                    case 'y': {
                        r = val * 86400000000L * 365L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block9;
                    }
                    default: {
                        throw NumericException.INSTANCE;
                    }
                }
            }
            r = (val << 3) + (val << 1) - (long)(c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
        }
        if (val != Long.MIN_VALUE) return -val;
        throw NumericException.INSTANCE;
    }

    public static long parseLongQuiet(CharSequence sequence) {
        if (sequence == null) {
            return Long.MIN_VALUE;
        }
        try {
            return Numbers.parseLong0(sequence, 0, sequence.length());
        }
        catch (NumericException e) {
            return Long.MIN_VALUE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long parseLongSize(CharSequence sequence) throws NumericException {
        int lim = sequence.length();
        if (lim == 0) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(0) == '-';
        int i = 0;
        if (negative) {
            ++i;
        }
        if (i >= lim) {
            throw NumericException.INSTANCE;
        }
        long val = 0L;
        block5: while (i < lim) {
            long r;
            char c = sequence.charAt(i);
            if (c < '0' || c > '9') {
                if (i != lim - 1) throw NumericException.INSTANCE;
                switch (c) {
                    case 'K': 
                    case 'k': {
                        r = val * 1024L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block5;
                    }
                    case 'M': 
                    case 'm': {
                        r = val * 1024L * 1024L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block5;
                    }
                    case 'G': 
                    case 'g': {
                        r = val * 1024L * 1024L * 1024L;
                        if (r > val) {
                            throw NumericException.INSTANCE;
                        }
                        val = r;
                        break block5;
                    }
                    default: {
                        throw NumericException.INSTANCE;
                    }
                }
            }
            r = (val << 3) + (val << 1) - (long)(c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val != Long.MIN_VALUE || negative) return negative ? val : -val;
        throw NumericException.INSTANCE;
    }

    public static short parseShort(CharSequence sequence) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseShort0(sequence, 0, sequence.length());
    }

    public static short parseShort(CharSequence sequence, int p, int lim) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseShort0(sequence, p, lim);
    }

    public static double roundDown(double value, int scale) throws NumericException {
        if (scale < pow10max && scale > -pow10max) {
            return Numbers.roundDown0(value, scale);
        }
        throw NumericException.INSTANCE;
    }

    public static double roundDownNegScale(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundDown00NegScale(absValue, scale)) | signMask);
    }

    public static double roundDownPosScale(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundDown00PosScale(absValue, scale)) | signMask);
    }

    public static double roundHalfDown(double value, int scale) throws NumericException {
        if (scale + 2 < pow10max && scale > -pow10max) {
            return value > 0.0 ? Numbers.roundHalfDown0(value, scale) : -Numbers.roundHalfDown0(-value, scale);
        }
        throw NumericException.INSTANCE;
    }

    public static double roundHalfEven(double value, int scale) throws NumericException {
        if (scale + 2 < pow10max && scale > -pow10max) {
            return value > 0.0 ? Numbers.roundHalfEven0(value, scale) : -Numbers.roundHalfEven0(-value, scale);
        }
        throw NumericException.INSTANCE;
    }

    public static double roundHalfEven0NegScale(double value, int scale) {
        long val = (long)(value * pow10dNeg[scale] * (double)pow10[2] + 1.0E-15);
        long remainder = val % 100L;
        if (remainder < 50L) {
            return Numbers.roundDown00NegScale(value, scale);
        }
        if (remainder == 50L && ((long)(value * pow10dNeg[scale]) & 1L) == 0L) {
            return Numbers.roundDown00NegScale(value, scale);
        }
        return Numbers.roundUp00NegScale(value, scale);
    }

    public static double roundHalfEven0PosScale(double value, int scale) {
        long val = (long)(value * (double)pow10[scale] * (double)pow10[2] + 1.0E-15);
        long remainder = val % 100L;
        if (remainder < 50L) {
            return Numbers.roundDown00PosScale(value, scale);
        }
        if (remainder == 50L && ((long)(value * (double)pow10[scale]) & 1L) == 0L) {
            return Numbers.roundDown00PosScale(value, scale);
        }
        return Numbers.roundUp00PosScale(value, scale);
    }

    public static double roundHalfEvenNegScale(double value, int scale) {
        return value > 0.0 ? Numbers.roundHalfEven0NegScale(value, scale) : -Numbers.roundHalfEven0NegScale(-value, scale);
    }

    public static double roundHalfEvenPosScale(double value, int scale) {
        return value > 0.0 ? Numbers.roundHalfEven0PosScale(value, scale) : -Numbers.roundHalfEven0PosScale(-value, scale);
    }

    public static double roundHalfUp(double value, int scale) throws NumericException {
        if (scale + 2 < pow10max && scale > -pow10max) {
            long valueBits = Double.doubleToRawLongBits(value);
            long signMask = valueBits & Long.MIN_VALUE;
            double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
            return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundHalfUp0(absValue, scale)) | signMask);
        }
        throw NumericException.INSTANCE;
    }

    public static double roundHalfUpNegScale(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundHalfUp0NegScale(absValue, scale)) | signMask);
    }

    public static double roundHalfUpPosScale(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundHalfUp0PosScale(absValue, scale)) | signMask);
    }

    public static double roundUp(double value, int scale) throws NumericException {
        if (scale < pow10max && scale > -pow10max) {
            return Numbers.roundUp0(value, scale);
        }
        throw NumericException.INSTANCE;
    }

    public static double roundUpNegScale(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundUp00NegScale(absValue, scale)) | signMask);
    }

    public static double roundUpPosScale(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundUp00PosScale(absValue, scale)) | signMask);
    }

    public static long spreadBits(long v) {
        v = (v | v << 16) & 0xFFFF0000FFFFL;
        v = (v | v << 8) & 0xFF00FF00FF00FFL;
        v = (v | v << 4) & 0xF0F0F0F0F0F0F0FL;
        v = (v | v << 2) & 0x3333333333333333L;
        v = (v | v << 1) & 0x5555555555555555L;
        return v;
    }

    public static String toHexStrPadded(long value) {
        StringSink sink = new StringSink();
        Numbers.appendHexPadded(sink, value, 8);
        return sink.toString();
    }

    private static void appendDouble0(int binExp, long fractionBits, int significantBitCount, boolean negative, char[] digits, CharSink out, int outScale) {
        int nDigits;
        int firstDigitIndex;
        int decExp;
        assert (fractionBits > 0L);
        assert ((fractionBits & 0x10000000000000L) != 0L);
        int tailZeroes = Long.numberOfTrailingZeros(fractionBits);
        int fractBitCount = 53 - tailZeroes;
        int tinyBitCount = Math.max(0, fractBitCount - binExp - 1);
        if (binExp < 63 && binExp > -22 && tinyBitCount < LONG_5_POW.length && fractBitCount + N_5_BITS[tinyBitCount] < 64 && tinyBitCount == 0) {
            int digit;
            int insignificant = binExp > significantBitCount ? Numbers.insignificantDigitsForPow2(binExp - significantBitCount - 1) : 0;
            fractionBits = binExp >= 52 ? (fractionBits <<= binExp - 52) : (fractionBits >>>= 52 - binExp);
            int binExp2 = 0;
            if (insignificant != 0) {
                long pow10 = LONG_5_POW[insignificant] << insignificant;
                long residue = fractionBits % pow10;
                fractionBits /= pow10;
                binExp2 += insignificant;
                if (residue >= pow10 >> 1) {
                    ++fractionBits;
                }
            }
            int digitIndex = digits.length - 1;
            if (fractionBits <= Integer.MAX_VALUE) {
                assert (fractionBits > 0L) : fractionBits;
                int fractRemaining = (int)fractionBits;
                digit = fractRemaining % 10;
                fractRemaining /= 10;
                while (digit == 0) {
                    ++binExp2;
                    digit = fractRemaining % 10;
                    fractRemaining /= 10;
                }
                while (fractRemaining != 0) {
                    digits[digitIndex--] = (char)(digit + 48);
                    ++binExp2;
                    digit = fractRemaining % 10;
                    fractRemaining /= 10;
                }
            } else {
                digit = (int)(fractionBits % 10L);
                fractionBits /= 10L;
                while (digit == 0) {
                    ++binExp2;
                    digit = (int)(fractionBits % 10L);
                    fractionBits /= 10L;
                }
                while (fractionBits != 0L) {
                    digits[digitIndex--] = (char)(digit + 48);
                    ++binExp2;
                    digit = (int)(fractionBits % 10L);
                    fractionBits /= 10L;
                }
            }
            digits[digitIndex] = (char)(digit + 48);
            decExp = binExp2 + 1;
            firstDigitIndex = digitIndex;
            nDigits = digits.length - digitIndex;
        } else {
            long lowDigitDifference;
            boolean high;
            boolean low;
            int digitIndex;
            int estDecExp = Numbers.estimateDecExpDouble(fractionBits, binExp);
            int B5 = Math.max(0, -estDecExp);
            int B2 = B5 + tinyBitCount + binExp;
            int S5 = Math.max(0, estDecExp);
            int S2 = S5 + tinyBitCount;
            int M2 = B2 - significantBitCount;
            fractionBits >>>= tailZeroes;
            int common2factor = Math.min(B2 -= fractBitCount - 1, S2);
            B2 -= common2factor;
            S2 -= common2factor;
            M2 -= common2factor;
            if (fractBitCount == 1) {
                --M2;
            }
            if (M2 < 0) {
                B2 -= M2;
                S2 -= M2;
                M2 = 0;
            }
            int bBits = fractBitCount + B2 + (B5 < N_5_BITS.length ? N_5_BITS[B5] : B5 * 3);
            int tenBits = S2 + 1 + (S5 + 1 < N_5_BITS.length ? N_5_BITS[S5 + 1] : (S5 + 1) * 3);
            if (bBits < 64 && tenBits < 64) {
                if (bBits < 32 && tenBits < 32) {
                    int b = (int)fractionBits * SMALL_5_POW[B5] << B2;
                    int s = SMALL_5_POW[S5] << S2;
                    int m = SMALL_5_POW[B5] << M2;
                    int tens = s * 10;
                    digitIndex = 0;
                    int q = b / s;
                    low = (b = 10 * (b % s)) < (m *= 10);
                    boolean bl = high = b + m > tens;
                    assert (q < 10) : q;
                    if (q == 0 && !high) {
                        --estDecExp;
                    } else {
                        digits[digitIndex++] = (char)(48 + q);
                    }
                    if (estDecExp < -3 || estDecExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = b / s;
                        b = 10 * (b % s);
                        m *= 10;
                        assert (q < 10) : q;
                        if ((long)m > 0L) {
                            low = b < m;
                            high = b + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        digits[digitIndex++] = (char)(48 + q);
                    }
                    lowDigitDifference = ((long)b << 1) - (long)tens;
                } else {
                    long b = fractionBits * LONG_5_POW[B5] << B2;
                    long s = LONG_5_POW[S5] << S2;
                    long m = LONG_5_POW[B5] << M2;
                    long tens = s * 10L;
                    digitIndex = 0;
                    int q = (int)(b / s);
                    low = (b = 10L * (b % s)) < (m *= 10L);
                    boolean bl = high = b + m > tens;
                    assert (q < 10) : q;
                    if (q == 0 && !high) {
                        --estDecExp;
                    } else {
                        digits[digitIndex++] = (char)(48 + q);
                    }
                    if (estDecExp < -3 || estDecExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = (int)(b / s);
                        b = 10L * (b % s);
                        m *= 10L;
                        assert (q < 10) : q;
                        if (m > 0L) {
                            low = b < m;
                            high = b + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        digits[digitIndex++] = (char)(48 + q);
                    }
                    lowDigitDifference = (b << 1) - tens;
                }
            } else {
                FDBigInteger sVal = FDBigInteger.valueOfPow52(S5, S2);
                int shiftBias = sVal.getNormalizationBias();
                sVal = sVal.leftShift(shiftBias);
                FDBigInteger bVal = FDBigInteger.valueOfMulPow52(fractionBits, B5, B2 + shiftBias);
                FDBigInteger mVal = FDBigInteger.valueOfPow52(B5 + 1, M2 + shiftBias + 1);
                FDBigInteger tensVal = FDBigInteger.valueOfPow52(S5 + 1, S2 + shiftBias + 1);
                digitIndex = 0;
                int q = bVal.quoRemIteration(sVal);
                low = bVal.cmp(mVal) < 0;
                boolean bl = high = tensVal.addAndCmp(bVal, mVal) <= 0;
                assert (q < 10) : q;
                if (q == 0 && !high) {
                    --estDecExp;
                } else {
                    digits[digitIndex++] = (char)(48 + q);
                }
                if (estDecExp < -3 || estDecExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = bVal.quoRemIteration(sVal);
                    assert (q < 10) : q;
                    low = bVal.cmp(mVal = mVal.multBy10()) < 0;
                    high = tensVal.addAndCmp(bVal, mVal) <= 0;
                    digits[digitIndex++] = (char)(48 + q);
                }
                if (high && low) {
                    bVal = bVal.leftShift(1);
                    lowDigitDifference = bVal.cmp(tensVal);
                } else {
                    lowDigitDifference = 0L;
                }
            }
            decExp = estDecExp + 1;
            firstDigitIndex = 0;
            nDigits = digitIndex;
            if (high) {
                if (low) {
                    if (lowDigitDifference == 0L) {
                        if ((digits[firstDigitIndex + nDigits - 1] & '\u0001') != 0 && Numbers.roundupDouble(firstDigitIndex, digits, nDigits)) {
                            ++decExp;
                        }
                    } else if (lowDigitDifference > 0L && Numbers.roundupDouble(firstDigitIndex, digits, nDigits)) {
                        ++decExp;
                    }
                } else if (Numbers.roundupDouble(firstDigitIndex, digits, nDigits)) {
                    ++decExp;
                }
            }
        }
        Numbers.appendDouble00(digits, firstDigitIndex, nDigits, negative, decExp, out, outScale);
    }

    private static void appendDouble00(char[] digits, int firstDigitIndex, int nDigits, boolean isNegative, int decExp, CharSink sink, int outScale) {
        assert (nDigits <= 19) : nDigits;
        if (isNegative) {
            sink.put('-');
        }
        if (decExp > 0 && decExp < 8) {
            int exp = Math.min(nDigits, decExp);
            sink.put(digits, firstDigitIndex, exp);
            if (exp < decExp) {
                exp = decExp - exp;
                sink.fill('0', exp);
                sink.put('.');
                sink.put('0');
            } else {
                sink.put('.');
                if (exp < nDigits) {
                    sink.put(digits, firstDigitIndex + exp, Math.min(nDigits - exp, outScale));
                } else {
                    sink.put('0');
                }
            }
        } else if (decExp <= 0 && decExp > -3) {
            sink.put('0').put('.');
            if (decExp != 0) {
                sink.fill('0', -decExp);
            }
            sink.put(digits, firstDigitIndex, Math.min(nDigits, outScale));
        } else {
            int exp;
            sink.put(digits[firstDigitIndex]);
            sink.put('.');
            if (nDigits > 1) {
                sink.put(digits, firstDigitIndex + 1, nDigits - 1);
            } else {
                sink.put('0');
            }
            sink.put('E');
            if (decExp <= 0) {
                sink.put('-');
                exp = -decExp + 1;
            } else {
                exp = decExp - 1;
            }
            if (exp < 10) {
                sink.put((char)(exp + 48));
            } else if (exp < 100) {
                sink.put((char)(exp / 10 + 48));
                sink.put((char)(exp % 10 + 48));
            } else {
                sink.put((char)(exp / 100 + 48));
                sink.put((char)((exp %= 100) / 10 + 48));
                sink.put((char)(exp % 10 + 48));
            }
        }
    }

    private static void appendInt10(CharSink sink, int i) {
        sink.put((char)(48 + i / 1000000000));
        int c = i % 1000000000;
        sink.put((char)(48 + c / 100000000));
        sink.put((char)(48 + (c %= 100000000) / 10000000));
        sink.put((char)(48 + (c %= 10000000) / 1000000));
        sink.put((char)(48 + (c %= 1000000) / 100000));
        sink.put((char)(48 + (c %= 100000) / 10000));
        sink.put((char)(48 + (c %= 10000) / 1000));
        sink.put((char)(48 + (c %= 1000) / 100));
        sink.put((char)(48 + (c %= 100) / 10));
        sink.put((char)(48 + c % 10));
    }

    private static void appendInt2(CharSink sink, int i) {
        sink.put((char)(48 + i / 10));
        sink.put((char)(48 + i % 10));
    }

    private static void appendInt3(CharSink sink, int i) {
        sink.put((char)(48 + i / 100));
        int c = i % 100;
        sink.put((char)(48 + c / 10));
        sink.put((char)(48 + c % 10));
    }

    private static void appendInt4(CharSink sink, int i) {
        sink.put((char)(48 + i / 1000));
        int c = i % 1000;
        sink.put((char)(48 + c / 100));
        sink.put((char)(48 + (c %= 100) / 10));
        sink.put((char)(48 + c % 10));
    }

    private static void appendInt5(CharSink sink, int i) {
        sink.put((char)(48 + i / 10000));
        int c = i % 10000;
        sink.put((char)(48 + c / 1000));
        sink.put((char)(48 + (c %= 1000) / 100));
        sink.put((char)(48 + (c %= 100) / 10));
        sink.put((char)(48 + c % 10));
    }

    private static void appendInt6(CharSink sink, int i) {
        sink.put((char)(48 + i / 100000));
        int c = i % 100000;
        sink.put((char)(48 + c / 10000));
        sink.put((char)(48 + (c %= 10000) / 1000));
        sink.put((char)(48 + (c %= 1000) / 100));
        sink.put((char)(48 + (c %= 100) / 10));
        sink.put((char)(48 + c % 10));
    }

    private static void appendInt7(CharSink sink, int i) {
        sink.put((char)(48 + i / 1000000));
        int c = i % 1000000;
        sink.put((char)(48 + c / 100000));
        sink.put((char)(48 + (c %= 100000) / 10000));
        sink.put((char)(48 + (c %= 10000) / 1000));
        sink.put((char)(48 + (c %= 1000) / 100));
        sink.put((char)(48 + (c %= 100) / 10));
        sink.put((char)(48 + c % 10));
    }

    private static void appendInt8(CharSink sink, int i) {
        sink.put((char)(48 + i / 10000000));
        int c = i % 10000000;
        sink.put((char)(48 + c / 1000000));
        sink.put((char)(48 + (c %= 1000000) / 100000));
        sink.put((char)(48 + (c %= 100000) / 10000));
        sink.put((char)(48 + (c %= 10000) / 1000));
        sink.put((char)(48 + (c %= 1000) / 100));
        sink.put((char)(48 + (c %= 100) / 10));
        sink.put((char)(48 + c % 10));
    }

    private static void appendInt9(CharSink sink, int i) {
        sink.put((char)(48 + i / 100000000));
        int c = i % 100000000;
        sink.put((char)(48 + c / 10000000));
        sink.put((char)(48 + (c %= 10000000) / 1000000));
        sink.put((char)(48 + (c %= 1000000) / 100000));
        sink.put((char)(48 + (c %= 100000) / 10000));
        sink.put((char)(48 + (c %= 10000) / 1000));
        sink.put((char)(48 + (c %= 1000) / 100));
        sink.put((char)(48 + (c %= 100) / 10));
        sink.put((char)(48 + c % 10));
    }

    private static void appendLong10(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000000000L));
        long c = i % 1000000000L;
        sink.put((char)(48L + c / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong11(CharSink sink, long i) {
        sink.put((char)(48L + i / 10000000000L));
        long c = i % 10000000000L;
        sink.put((char)(48L + c / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong12(CharSink sink, long i) {
        sink.put((char)(48L + i / 100000000000L));
        long c = i % 100000000000L;
        sink.put((char)(48L + c / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong13(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000000000000L));
        long c = i % 1000000000000L;
        sink.put((char)(48L + c / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong14(CharSink sink, long i) {
        sink.put((char)(48L + i / 10000000000000L));
        long c = i % 10000000000000L;
        sink.put((char)(48L + c / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong15(CharSink sink, long i) {
        sink.put((char)(48L + i / 100000000000000L));
        long c = i % 100000000000000L;
        sink.put((char)(48L + c / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong16(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000000000000000L));
        long c = i % 1000000000000000L;
        sink.put((char)(48L + c / 100000000000000L));
        sink.put((char)(48L + (c %= 100000000000000L) / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong17(CharSink sink, long i) {
        sink.put((char)(48L + i / 10000000000000000L));
        long c = i % 10000000000000000L;
        sink.put((char)(48L + c / 1000000000000000L));
        sink.put((char)(48L + (c %= 1000000000000000L) / 100000000000000L));
        sink.put((char)(48L + (c %= 100000000000000L) / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong18(CharSink sink, long i) {
        sink.put((char)(48L + i / 100000000000000000L));
        long c = i % 100000000000000000L;
        sink.put((char)(48L + c / 10000000000000000L));
        sink.put((char)(48L + (c %= 10000000000000000L) / 1000000000000000L));
        sink.put((char)(48L + (c %= 1000000000000000L) / 100000000000000L));
        sink.put((char)(48L + (c %= 100000000000000L) / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong19(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000000000000000000L));
        long c = i % 1000000000000000000L;
        sink.put((char)(48L + c / 100000000000000000L));
        sink.put((char)(48L + (c %= 100000000000000000L) / 10000000000000000L));
        sink.put((char)(48L + (c %= 10000000000000000L) / 1000000000000000L));
        sink.put((char)(48L + (c %= 1000000000000000L) / 100000000000000L));
        sink.put((char)(48L + (c %= 100000000000000L) / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong2(CharSink sink, long i) {
        sink.put((char)(48L + i / 10L));
        sink.put((char)(48L + i % 10L));
    }

    private static void appendLong256Four(long a, long b, long c, long d, CharSink sink) {
        Numbers.appendLong256Three(b, c, d, sink);
        Numbers.appendHex(sink, a, true);
    }

    private static void appendLong256Three(long a, long b, long c, CharSink sink) {
        Numbers.appendLong256Two(b, c, sink);
        Numbers.appendHex(sink, a, true);
    }

    private static void appendLong256Two(long a, long b, CharSink sink) {
        Numbers.appendHex(sink, b, false);
        Numbers.appendHex(sink, a, true);
    }

    private static void appendLong3(CharSink sink, long i) {
        sink.put((char)(48L + i / 100L));
        long c = i % 100L;
        sink.put((char)(48L + c / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong4(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000L));
        long c = i % 1000L;
        sink.put((char)(48L + c / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong5(CharSink sink, long i) {
        sink.put((char)(48L + i / 10000L));
        long c = i % 10000L;
        sink.put((char)(48L + c / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong6(CharSink sink, long i) {
        sink.put((char)(48L + i / 100000L));
        long c = i % 100000L;
        sink.put((char)(48L + c / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong7(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000000L));
        long c = i % 1000000L;
        sink.put((char)(48L + c / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong8(CharSink sink, long i) {
        sink.put((char)(48L + i / 10000000L));
        long c = i % 10000000L;
        sink.put((char)(48L + c / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong9(CharSink sink, long i) {
        sink.put((char)(48L + i / 100000000L));
        long c = i % 100000000L;
        sink.put((char)(48L + c / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLongHex12(CharSink sink, long value) {
        Numbers.appendLongHexPad(sink, hexDigits[(int)(value >> 8 & 0xFL)]);
        Numbers.appendLongHex8(sink, value);
    }

    private static void appendLongHex12Pad64(CharSink sink, long value) {
        sink.put("000000000000");
        Numbers.appendLongHex12(sink, value);
    }

    private static void appendLongHex16(CharSink sink, long value) {
        sink.put(hexDigits[(int)(value >> 12 & 0xFL)]);
        sink.put(hexDigits[(int)(value >> 8 & 0xFL)]);
        Numbers.appendLongHex8(sink, value);
    }

    private static void appendLongHex16Pad64(CharSink sink, long value) {
        sink.put("000000000000");
        Numbers.appendLongHex16(sink, value);
    }

    private static void appendLongHex20(CharSink sink, long value) {
        Numbers.appendLongHexPad(sink, hexDigits[(int)(value >> 16 & 0xFL)]);
        Numbers.appendLongHex16(sink, value);
    }

    private static void appendLongHex20Pad64(CharSink sink, long value) {
        sink.put("0000000000");
        Numbers.appendLongHex20(sink, value);
    }

    private static void appendLongHex24(CharSink sink, long value) {
        sink.put(hexDigits[(int)(value >> 20 & 0xFL)]);
        sink.put(hexDigits[(int)(value >> 16 & 0xFL)]);
        Numbers.appendLongHex16(sink, value);
    }

    private static void appendLongHex24Pad64(CharSink sink, long value) {
        sink.put("0000000000");
        Numbers.appendLongHex24(sink, value);
    }

    private static void appendLongHex28(CharSink sink, long value) {
        Numbers.appendLongHexPad(sink, hexDigits[(int)(value >> 24 & 0xFL)]);
        Numbers.appendLongHex24(sink, value);
    }

    private static void appendLongHex28Pad64(CharSink sink, long value) {
        sink.put("00000000");
        Numbers.appendLongHex28(sink, value);
    }

    private static void appendLongHex32(CharSink sink, long value) {
        sink.put(hexDigits[(int)(value >> 28 & 0xFL)]);
        sink.put(hexDigits[(int)(value >> 24 & 0xFL)]);
        Numbers.appendLongHex24(sink, value);
    }

    private static void appendLongHex32Pad64(CharSink sink, long value) {
        sink.put("00000000");
        Numbers.appendLongHex32(sink, value);
    }

    private static void appendLongHex36(CharSink sink, long value) {
        Numbers.appendLongHexPad(sink, hexDigits[(int)(value >> 32 & 0xFL)]);
        Numbers.appendLongHex32(sink, value);
    }

    private static void appendLongHex36Pad64(CharSink sink, long value) {
        sink.put("000000");
        Numbers.appendLongHex36(sink, value);
    }

    private static void appendLongHex4(CharSink sink, long value) {
        Numbers.appendLongHexPad(sink, hexDigits[(int)(value & 0xFL)]);
    }

    private static void appendLongHex40(CharSink sink, long value) {
        sink.put(hexDigits[(int)(value >> 36 & 0xFL)]);
        sink.put(hexDigits[(int)(value >> 32 & 0xFL)]);
        Numbers.appendLongHex32(sink, value);
    }

    private static void appendLongHex40Pad64(CharSink sink, long value) {
        sink.put("000000");
        Numbers.appendLongHex40(sink, value);
    }

    private static void appendLongHex44(CharSink sink, long value) {
        Numbers.appendLongHexPad(sink, hexDigits[(int)(value >> 40 & 0xFL)]);
        Numbers.appendLongHex40(sink, value);
    }

    private static void appendLongHex44Pad64(CharSink sink, long value) {
        sink.put("0000");
        Numbers.appendLongHex44(sink, value);
    }

    private static void appendLongHex48(CharSink sink, long value) {
        sink.put(hexDigits[(int)(value >> 44 & 0xFL)]);
        sink.put(hexDigits[(int)(value >> 40 & 0xFL)]);
        Numbers.appendLongHex40(sink, value);
    }

    private static void appendLongHex48Pad64(CharSink sink, long value) {
        sink.put("0000");
        Numbers.appendLongHex48(sink, value);
    }

    private static void appendLongHex4Pad64(CharSink sink, long value) {
        sink.put("00000000000000");
        Numbers.appendLongHex4(sink, value);
    }

    private static void appendLongHex52(CharSink sink, long value) {
        Numbers.appendLongHexPad(sink, hexDigits[(int)(value >> 48 & 0xFL)]);
        Numbers.appendLongHex48(sink, value);
    }

    private static void appendLongHex52Pad64(CharSink sink, long value) {
        sink.put("00");
        Numbers.appendLongHex52(sink, value);
    }

    private static void appendLongHex56(CharSink sink, long value) {
        sink.put(hexDigits[(int)(value >> 52 & 0xFL)]);
        sink.put(hexDigits[(int)(value >> 48 & 0xFL)]);
        Numbers.appendLongHex48(sink, value);
    }

    private static void appendLongHex56Pad64(CharSink sink, long value) {
        sink.put("00");
        Numbers.appendLongHex56(sink, value);
    }

    private static void appendLongHex60(CharSink sink, long value) {
        Numbers.appendLongHexPad(sink, hexDigits[(int)(value >> 56 & 0xFL)]);
        Numbers.appendLongHex56(sink, value);
    }

    private static void appendLongHex64(CharSink sink, long value) {
        sink.put(hexDigits[(int)(value >> 60 & 0xFL)]);
        sink.put(hexDigits[(int)(value >> 56 & 0xFL)]);
        Numbers.appendLongHex56(sink, value);
    }

    private static void appendLongHex8(CharSink sink, long value) {
        sink.put(hexDigits[(int)(value >> 4 & 0xFL)]);
        sink.put(hexDigits[(int)(value & 0xFL)]);
    }

    private static void appendLongHex8Pad64(CharSink sink, long value) {
        sink.put("00000000000000");
        Numbers.appendLongHex8(sink, value);
    }

    private static void appendLongHexPad(CharSink sink, char hexDigit) {
        sink.put('0');
        sink.put(hexDigit);
    }

    private static int estimateDecExpDouble(long fractBits, int binExp) {
        boolean isNegative;
        double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFFFFFFFFFFFFL);
        double d = (d2 - 1.5) * 0.289529654 + 0.176091259 + (double)binExp * 0.301029995663981;
        long dBits = Double.doubleToRawLongBits(d);
        int exponent = (int)((dBits & 0x7FF0000000000000L) >> 52) - 1023;
        boolean bl = isNegative = (dBits & Long.MIN_VALUE) != 0L;
        if (exponent > -1 && exponent < 52) {
            long mask = 0xFFFFFFFFFFFFFL >> exponent;
            int r = (int)((dBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L) >> 52 - exponent);
            return isNegative ? ((mask & dBits) == 0L ? -r : -r - 1) : r;
        }
        if (exponent < 0) {
            return (dBits & Long.MAX_VALUE) == 0L ? 0 : (isNegative ? -1 : 0);
        }
        return (int)d;
    }

    private static int insignificantDigitsForPow2(int p2) {
        return p2 > 1 && p2 < insignificantDigitsNumber.length ? insignificantDigitsNumber[p2] : 0;
    }

    private static int parseInt0(CharSequence sequence, int p, int lim) throws NumericException {
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        char sign = sequence.charAt(p);
        boolean negative = sign == '-';
        int i = p;
        if (negative || sign == '+') {
            ++i;
        }
        if (i >= lim) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        while (i < lim) {
            char c = sequence.charAt(i);
            if (c < '0' || c > '9') {
                throw NumericException.INSTANCE;
            }
            if (val < -214748364) {
                throw NumericException.INSTANCE;
            }
            int r = (val << 3) + (val << 1) - (c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val == Integer.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        return negative ? val : -val;
    }

    private static long parseLong0(CharSequence sequence, int p, int lim) throws NumericException {
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(p) == '-';
        int i = p;
        if (negative) {
            ++i;
        }
        if (i >= lim) {
            throw NumericException.INSTANCE;
        }
        long val = 0L;
        while (i < lim) {
            char c = sequence.charAt(i);
            if (c == 'L' || c == 'l') {
                if (i != 0 && i + 1 >= lim) break;
                throw NumericException.INSTANCE;
            }
            if (c < '0' || c > '9') {
                throw NumericException.INSTANCE;
            }
            long r = (val << 3) + (val << 1) - (long)(c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val == Long.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        return negative ? val : -val;
    }

    private static short parseShort0(CharSequence sequence, int p, int lim) throws NumericException {
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(p) == '-';
        int i = p;
        if (negative) {
            ++i;
        }
        if (i >= lim) {
            throw NumericException.INSTANCE;
        }
        short val = 0;
        while (i < lim) {
            char c = sequence.charAt(i);
            if (c < '0' || c > '9') {
                throw NumericException.INSTANCE;
            }
            if (val < -3276) {
                throw NumericException.INSTANCE;
            }
            short r = (short)((val << 3) + (val << 1) - (c - 48));
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val == Short.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        return negative ? val : (short)(-val);
    }

    private static double roundDown0(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundDown00(absValue, scale)) | signMask);
    }

    private static double roundDown00(double value, int scale) {
        return scale < 0 ? Numbers.roundDown00NegScale(value, -scale) : Numbers.roundDown00PosScale(value, scale);
    }

    private static double roundDown00NegScale(double value, int scale) {
        long powten = pow10[scale];
        double powtenNeg = pow10dNeg[scale];
        return (double)((long)((value + 1.0E-15) * powtenNeg)) * (double)powten;
    }

    private static double roundDown00PosScale(double value, int scale) {
        long powten = pow10[scale];
        double powtenNeg = pow10dNeg[scale];
        return (double)((long)((value + 1.0E-15) * (double)powten)) * powtenNeg;
    }

    private static double roundDown0NegScale(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundDown00NegScale(absValue, scale)) | signMask);
    }

    private static double roundHalfDown0(double value, int scale) {
        long val = (long)(value * (double)pow10[scale + 2] + 1.0E-15);
        return val % 100L > 50L ? Numbers.roundUp0(value, scale) : Numbers.roundDown0(value, scale);
    }

    private static double roundHalfEven0(double value, int scale) {
        return scale > 0 ? Numbers.roundHalfEven0PosScale(value, scale) : Numbers.roundHalfEven0NegScale(value, -scale);
    }

    private static double roundHalfUp0(double value, int scale) {
        return scale > 0 ? Numbers.roundHalfUp0PosScale(value, scale) : Numbers.roundHalfUp0NegScale(value, -scale);
    }

    private static double roundHalfUp0NegScale(double value, int scale) {
        long val = (long)(value * pow10dNeg[scale] * (double)pow10[2] + 1.0E-15);
        return val % 100L < 50L ? Numbers.roundDown0NegScale(value, scale) : Numbers.roundUp0NegScale(value, scale);
    }

    private static double roundHalfUp0PosScale(double value, int scale) {
        long val = (long)((value + 1.0E-15) * (double)pow10[scale + 2]);
        return val % 100L < 50L ? Numbers.roundDown00PosScale(value, scale) : Numbers.roundUp00PosScale(value, scale);
    }

    private static double roundUp0(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundUp00(absValue, scale)) | signMask);
    }

    private static double roundUp00(double value, int scale) {
        return scale < 0 ? Numbers.roundUp00NegScale(value, -scale) : Numbers.roundUp00PosScale(value, scale);
    }

    private static double roundUp00NegScale(double value, int scale) {
        long powten = pow10[scale];
        double powtenNeg = pow10dNeg[scale];
        return (double)((long)(value * powtenNeg + 1.0 - 1.0E-15)) * (double)powten;
    }

    private static double roundUp00PosScale(double value, int scale) {
        long powten = pow10[scale];
        double powtenNeg = pow10dNeg[scale];
        return (double)((long)(value * (double)powten + 1.0 - 1.0E-15)) * powtenNeg;
    }

    private static double roundUp0NegScale(double value, int scale) {
        long valueBits = Double.doubleToRawLongBits(value);
        long signMask = valueBits & Long.MIN_VALUE;
        double absValue = Double.longBitsToDouble(valueBits & Long.MAX_VALUE);
        return Double.longBitsToDouble(Double.doubleToRawLongBits(Numbers.roundUp00NegScale(absValue, scale)) | signMask);
    }

    private static boolean roundupDouble(int firstDigitIndex, char[] digits, int nDigits) {
        int charIndex = firstDigitIndex + nDigits - 1;
        char c = digits[charIndex];
        if (c == '9') {
            while (true) {
                if (c != '9' || charIndex <= firstDigitIndex) {
                    if (c != '9') break;
                    digits[firstDigitIndex] = 49;
                    return true;
                }
                digits[charIndex] = 48;
                c = digits[--charIndex];
            }
        }
        digits[charIndex] = (char)(c + '\u0001');
        return false;
    }

    static {
        LongHexAppender a64;
        LongHexAppender a60;
        LongHexAppender a56;
        LongHexAppender a52;
        LongHexAppender a48;
        LongHexAppender a44;
        LongHexAppender a40;
        LongHexAppender a36;
        LongHexAppender a32;
        LongHexAppender a28;
        LongHexAppender a24;
        LongHexAppender a20;
        LongHexAppender a16;
        LongHexAppender a12;
        LongHexAppender a8;
        LongHexAppender a4;
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        LONG_5_POW = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
        N_5_BITS = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
        SMALL_5_POW = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        insignificantDigitsNumber = new int[]{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 17, 17, 17, 18, 18, 18, 19};
        longHexAppender = new LongHexAppender[65];
        longHexAppenderPad64 = new LongHexAppender[65];
        pow10dNeg = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11, 1.0E-12, 1.0E-13, 1.0E-14, 1.0E-15, 1.0E-16, 1.0E-17, 1.0E-18, 1.0E-19, 1.0E-20, 1.0E-21, 1.0E-22, 1.0E-23, 1.0E-24, 1.0E-25, 1.0E-26, 1.0E-27, 1.0E-28, 1.0E-29, 1.0E-30, 1.0E-31, 1.0E-32, 1.0E-33, 1.0E-34, 1.0E-35, 1.0E-36, 1.0E-37, 1.0E-38, 1.0E-39, 1.0E-40, 1.0E-41, 1.0E-42, 1.0E-43, 1.0E-44, 1.0E-45, 1.0E-46, 1.0E-47, 1.0E-48, 1.0E-49, 1.0E-50, 1.0E-51, 1.0E-52, 1.0E-53, 1.0E-54, 1.0E-55, 1.0E-56, 1.0E-57, 1.0E-58, 1.0E-59, 1.0E-60, 1.0E-61, 1.0E-62, 1.0E-63, 1.0E-64, 1.0E-65, 1.0E-66, 1.0E-67, 1.0E-68, 1.0E-69, 1.0E-70, 1.0E-71, 1.0E-72, 1.0E-73, 1.0E-74, 1.0E-75, 1.0E-76, 1.0E-77, 1.0E-78, 1.0E-79, 1.0E-80, 1.0E-81, 1.0E-82, 1.0E-83, 1.0E-84, 1.0E-85, 1.0E-86, 1.0E-87, 1.0E-88, 1.0E-89, 1.0E-90, 1.0E-91, 1.0E-92, 1.0E-93, 1.0E-94, 1.0E-95, 1.0E-96, 1.0E-97, 1.0E-98, 1.0E-99, 1.0E-100, 1.0E-101, 1.0E-102, 1.0E-103, 1.0E-104, 1.0E-105, 1.0E-106, 1.0E-107, 1.0E-108, 1.0E-109, 1.0E-110, 1.0E-111, 1.0E-112, 1.0E-113, 1.0E-114, 1.0E-115, 1.0E-116, 1.0E-117, 1.0E-118, 1.0E-119, 1.0E-120, 1.0E-121, 1.0E-122, 1.0E-123, 1.0E-124, 1.0E-125, 1.0E-126, 1.0E-127, 1.0E-128, 1.0E-129, 1.0E-130, 1.0E-131, 1.0E-132, 1.0E-133, 1.0E-134, 1.0E-135, 1.0E-136, 1.0E-137, 1.0E-138, 1.0E-139, 1.0E-140, 1.0E-141, 1.0E-142, 1.0E-143, 1.0E-144, 1.0E-145, 1.0E-146, 1.0E-147, 1.0E-148, 1.0E-149, 1.0E-150, 1.0E-151, 1.0E-152, 1.0E-153, 1.0E-154, 1.0E-155, 1.0E-156, 1.0E-157, 1.0E-158, 1.0E-159, 1.0E-160, 1.0E-161, 1.0E-162, 1.0E-163, 1.0E-164, 1.0E-165, 1.0E-166, 1.0E-167, 1.0E-168, 1.0E-169, 1.0E-170, 1.0E-171, 1.0E-172, 1.0E-173, 1.0E-174, 1.0E-175, 1.0E-176, 1.0E-177, 1.0E-178, 1.0E-179, 1.0E-180, 1.0E-181, 1.0E-182, 1.0E-183, 1.0E-184, 1.0E-185, 1.0E-186, 1.0E-187, 1.0E-188, 1.0E-189, 1.0E-190, 1.0E-191, 1.0E-192, 1.0E-193, 1.0E-194, 1.0E-195, 1.0E-196, 1.0E-197, 1.0E-198, 1.0E-199, 1.0E-200, 1.0E-201, 1.0E-202, 1.0E-203, 1.0E-204, 1.0E-205, 1.0E-206, 1.0E-207, 1.0E-208, 1.0E-209, 1.0E-210, 1.0E-211, 1.0E-212, 1.0E-213, 1.0E-214, 1.0E-215, 1.0E-216, 1.0E-217, 1.0E-218, 1.0E-219, 1.0E-220, 1.0E-221, 1.0E-222, 1.0E-223, 1.0E-224, 1.0E-225, 1.0E-226, 1.0E-227, 1.0E-228, 1.0E-229, 1.0E-230, 1.0E-231, 1.0E-232, 1.0E-233, 1.0E-234, 1.0E-235, 1.0E-236, 1.0E-237, 1.0E-238, 1.0E-239, 1.0E-240, 1.0E-241, 1.0E-242, 1.0E-243, 1.0E-244, 1.0E-245, 1.0E-246, 1.0E-247, 1.0E-248, 1.0E-249, 1.0E-250, 1.0E-251, 1.0E-252, 1.0E-253, 1.0E-254, 1.0E-255, 1.0E-256, 1.0E-257, 1.0E-258, 1.0E-259, 1.0E-260, 1.0E-261, 1.0E-262, 1.0E-263, 1.0E-264, 1.0E-265, 1.0E-266, 1.0E-267, 1.0E-268, 1.0E-269, 1.0E-270, 1.0E-271, 1.0E-272, 1.0E-273, 1.0E-274, 1.0E-275, 1.0E-276, 1.0E-277, 1.0E-278, 1.0E-279, 1.0E-280, 1.0E-281, 1.0E-282, 1.0E-283, 1.0E-284, 1.0E-285, 1.0E-286, 1.0E-287, 1.0E-288, 1.0E-289, 1.0E-290, 1.0E-291, 1.0E-292, 1.0E-293, 1.0E-294, 1.0E-295, 1.0E-296, 1.0E-297, 1.0E-298, 1.0E-299, 1.0E-300, 1.0E-301, 1.0E-302, 1.0E-303, 1.0E-304, 1.0E-305, 1.0E-306, 1.0E-307, 1.0E-308};
        Module currentModule = Numbers.class.getModule();
        Unsafe.addExports(Unsafe.JAVA_BASE_MODULE, currentModule, "jdk.internal.math");
        pow10 = new long[20];
        pow10max = 18;
        Numbers.pow10[0] = 1L;
        for (int i = 1; i < pow10.length; ++i) {
            Numbers.pow10[i] = pow10[i - 1] * 10L;
        }
        hexNumbers = new int[128];
        Arrays.fill(hexNumbers, -1);
        Numbers.hexNumbers[48] = 0;
        Numbers.hexNumbers[49] = 1;
        Numbers.hexNumbers[50] = 2;
        Numbers.hexNumbers[51] = 3;
        Numbers.hexNumbers[52] = 4;
        Numbers.hexNumbers[53] = 5;
        Numbers.hexNumbers[54] = 6;
        Numbers.hexNumbers[55] = 7;
        Numbers.hexNumbers[56] = 8;
        Numbers.hexNumbers[57] = 9;
        Numbers.hexNumbers[65] = 10;
        Numbers.hexNumbers[97] = 10;
        Numbers.hexNumbers[66] = 11;
        Numbers.hexNumbers[98] = 11;
        Numbers.hexNumbers[67] = 12;
        Numbers.hexNumbers[99] = 12;
        Numbers.hexNumbers[68] = 13;
        Numbers.hexNumbers[100] = 13;
        Numbers.hexNumbers[69] = 14;
        Numbers.hexNumbers[101] = 14;
        Numbers.hexNumbers[70] = 15;
        Numbers.hexNumbers[102] = 15;
        Numbers.longHexAppender[0] = a4 = Numbers::appendLongHex4;
        Numbers.longHexAppender[1] = a4;
        Numbers.longHexAppender[2] = a4;
        Numbers.longHexAppender[3] = a4;
        Numbers.longHexAppender[4] = a4;
        Numbers.longHexAppender[5] = a8 = Numbers::appendLongHex8;
        Numbers.longHexAppender[6] = a8;
        Numbers.longHexAppender[7] = a8;
        Numbers.longHexAppender[8] = a8;
        Numbers.longHexAppender[9] = a12 = Numbers::appendLongHex12;
        Numbers.longHexAppender[10] = a12;
        Numbers.longHexAppender[11] = a12;
        Numbers.longHexAppender[12] = a12;
        Numbers.longHexAppender[13] = a16 = Numbers::appendLongHex16;
        Numbers.longHexAppender[14] = a16;
        Numbers.longHexAppender[15] = a16;
        Numbers.longHexAppender[16] = a16;
        Numbers.longHexAppender[17] = a20 = Numbers::appendLongHex20;
        Numbers.longHexAppender[18] = a20;
        Numbers.longHexAppender[19] = a20;
        Numbers.longHexAppender[20] = a20;
        Numbers.longHexAppender[21] = a24 = Numbers::appendLongHex24;
        Numbers.longHexAppender[22] = a24;
        Numbers.longHexAppender[23] = a24;
        Numbers.longHexAppender[24] = a24;
        Numbers.longHexAppender[25] = a28 = Numbers::appendLongHex28;
        Numbers.longHexAppender[26] = a28;
        Numbers.longHexAppender[27] = a28;
        Numbers.longHexAppender[28] = a28;
        Numbers.longHexAppender[29] = a32 = Numbers::appendLongHex32;
        Numbers.longHexAppender[30] = a32;
        Numbers.longHexAppender[31] = a32;
        Numbers.longHexAppender[32] = a32;
        Numbers.longHexAppender[33] = a36 = Numbers::appendLongHex36;
        Numbers.longHexAppender[34] = a36;
        Numbers.longHexAppender[35] = a36;
        Numbers.longHexAppender[36] = a36;
        Numbers.longHexAppender[37] = a40 = Numbers::appendLongHex40;
        Numbers.longHexAppender[38] = a40;
        Numbers.longHexAppender[39] = a40;
        Numbers.longHexAppender[40] = a40;
        Numbers.longHexAppender[41] = a44 = Numbers::appendLongHex44;
        Numbers.longHexAppender[42] = a44;
        Numbers.longHexAppender[43] = a44;
        Numbers.longHexAppender[44] = a44;
        Numbers.longHexAppender[45] = a48 = Numbers::appendLongHex48;
        Numbers.longHexAppender[46] = a48;
        Numbers.longHexAppender[47] = a48;
        Numbers.longHexAppender[48] = a48;
        Numbers.longHexAppender[49] = a52 = Numbers::appendLongHex52;
        Numbers.longHexAppender[50] = a52;
        Numbers.longHexAppender[51] = a52;
        Numbers.longHexAppender[52] = a52;
        Numbers.longHexAppender[53] = a56 = Numbers::appendLongHex56;
        Numbers.longHexAppender[54] = a56;
        Numbers.longHexAppender[55] = a56;
        Numbers.longHexAppender[56] = a56;
        Numbers.longHexAppender[57] = a60 = Numbers::appendLongHex60;
        Numbers.longHexAppender[58] = a60;
        Numbers.longHexAppender[59] = a60;
        Numbers.longHexAppender[60] = a60;
        Numbers.longHexAppender[61] = a64 = Numbers::appendLongHex64;
        Numbers.longHexAppender[62] = a64;
        Numbers.longHexAppender[63] = a64;
        Numbers.longHexAppender[64] = a64;
        Numbers.longHexAppenderPad64[0] = a4 = Numbers::appendLongHex4Pad64;
        Numbers.longHexAppenderPad64[1] = a4;
        Numbers.longHexAppenderPad64[2] = a4;
        Numbers.longHexAppenderPad64[3] = a4;
        Numbers.longHexAppenderPad64[4] = a4;
        Numbers.longHexAppenderPad64[5] = a8 = Numbers::appendLongHex8Pad64;
        Numbers.longHexAppenderPad64[6] = a8;
        Numbers.longHexAppenderPad64[7] = a8;
        Numbers.longHexAppenderPad64[8] = a8;
        Numbers.longHexAppenderPad64[9] = a12 = Numbers::appendLongHex12Pad64;
        Numbers.longHexAppenderPad64[10] = a12;
        Numbers.longHexAppenderPad64[11] = a12;
        Numbers.longHexAppenderPad64[12] = a12;
        Numbers.longHexAppenderPad64[13] = a16 = Numbers::appendLongHex16Pad64;
        Numbers.longHexAppenderPad64[14] = a16;
        Numbers.longHexAppenderPad64[15] = a16;
        Numbers.longHexAppenderPad64[16] = a16;
        Numbers.longHexAppenderPad64[17] = a20 = Numbers::appendLongHex20Pad64;
        Numbers.longHexAppenderPad64[18] = a20;
        Numbers.longHexAppenderPad64[19] = a20;
        Numbers.longHexAppenderPad64[20] = a20;
        Numbers.longHexAppenderPad64[21] = a24 = Numbers::appendLongHex24Pad64;
        Numbers.longHexAppenderPad64[22] = a24;
        Numbers.longHexAppenderPad64[23] = a24;
        Numbers.longHexAppenderPad64[24] = a24;
        Numbers.longHexAppenderPad64[25] = a28 = Numbers::appendLongHex28Pad64;
        Numbers.longHexAppenderPad64[26] = a28;
        Numbers.longHexAppenderPad64[27] = a28;
        Numbers.longHexAppenderPad64[28] = a28;
        Numbers.longHexAppenderPad64[29] = a32 = Numbers::appendLongHex32Pad64;
        Numbers.longHexAppenderPad64[30] = a32;
        Numbers.longHexAppenderPad64[31] = a32;
        Numbers.longHexAppenderPad64[32] = a32;
        Numbers.longHexAppenderPad64[33] = a36 = Numbers::appendLongHex36Pad64;
        Numbers.longHexAppenderPad64[34] = a36;
        Numbers.longHexAppenderPad64[35] = a36;
        Numbers.longHexAppenderPad64[36] = a36;
        Numbers.longHexAppenderPad64[37] = a40 = Numbers::appendLongHex40Pad64;
        Numbers.longHexAppenderPad64[38] = a40;
        Numbers.longHexAppenderPad64[39] = a40;
        Numbers.longHexAppenderPad64[40] = a40;
        Numbers.longHexAppenderPad64[41] = a44 = Numbers::appendLongHex44Pad64;
        Numbers.longHexAppenderPad64[42] = a44;
        Numbers.longHexAppenderPad64[43] = a44;
        Numbers.longHexAppenderPad64[44] = a44;
        Numbers.longHexAppenderPad64[45] = a48 = Numbers::appendLongHex48Pad64;
        Numbers.longHexAppenderPad64[46] = a48;
        Numbers.longHexAppenderPad64[47] = a48;
        Numbers.longHexAppenderPad64[48] = a48;
        Numbers.longHexAppenderPad64[49] = a52 = Numbers::appendLongHex52Pad64;
        Numbers.longHexAppenderPad64[50] = a52;
        Numbers.longHexAppenderPad64[51] = a52;
        Numbers.longHexAppenderPad64[52] = a52;
        Numbers.longHexAppenderPad64[53] = a56 = Numbers::appendLongHex56Pad64;
        Numbers.longHexAppenderPad64[54] = a56;
        Numbers.longHexAppenderPad64[55] = a56;
        Numbers.longHexAppenderPad64[56] = a56;
        Numbers.longHexAppenderPad64[57] = a60 = Numbers::appendLongHex60;
        Numbers.longHexAppenderPad64[58] = a60;
        Numbers.longHexAppenderPad64[59] = a60;
        Numbers.longHexAppenderPad64[60] = a60;
        Numbers.longHexAppenderPad64[61] = a64 = Numbers::appendLongHex64;
        Numbers.longHexAppenderPad64[62] = a64;
        Numbers.longHexAppenderPad64[63] = a64;
        Numbers.longHexAppenderPad64[64] = a64;
    }

    @FunctionalInterface
    private static interface LongHexAppender {
        public void append(CharSink var1, long var2);
    }
}

