/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.log.Log;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.Os;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class FilesFacadeImpl
implements FilesFacade {
    public static final FilesFacade INSTANCE = new FilesFacadeImpl();
    public static final int _16M = 0x1000000;
    private final FsOperation copyFsOperation = this::copy;
    private final FsOperation hardLinkFsOperation = this::hardLink;
    private long mapPageSize = 0L;

    @Override
    public boolean allocate(int fd, long size) {
        return Files.allocate(fd, size);
    }

    @Override
    public boolean allowMixedIO(CharSequence root) {
        return !Os.isWindows();
    }

    @Override
    public long append(int fd, long buf, int len) {
        return Files.append(fd, buf, len);
    }

    @Override
    public boolean close(int fd) {
        return Files.close(fd) == 0;
    }

    @Override
    public boolean closeRemove(int fd, LPSZ path) {
        if (fd > -1) {
            Files.close(fd);
        }
        return this.remove(path);
    }

    @Override
    public int copy(LPSZ from, LPSZ to) {
        return Files.copy(from, to);
    }

    @Override
    public long copyData(int srcFd, int destFd, long offsetSrc, long length) {
        return Files.copyData(srcFd, destFd, offsetSrc, length);
    }

    @Override
    public long copyData(int srcFd, int destFd, long offsetSrc, long destOffset, long length) {
        return Files.copyDataToOffset(srcFd, destFd, offsetSrc, destOffset, length);
    }

    @Override
    public int copyRecursive(Path src, Path dst, int dirMode) {
        return this.runRecursive(src, dst, dirMode, this.copyFsOperation);
    }

    @Override
    public int errno() {
        return Os.errno();
    }

    @Override
    public boolean exists(LPSZ path) {
        return Files.exists(path);
    }

    @Override
    public boolean exists(int fd) {
        return Files.exists(fd);
    }

    @Override
    public void fadvise(int fd, long offset, long len, int advise) {
        if (advise > -1) {
            Files.fadvise(fd, offset, len, advise);
        }
    }

    @Override
    public long findClose(long findPtr) {
        if (findPtr != 0L) {
            Files.findClose(findPtr);
        }
        return 0L;
    }

    @Override
    public long findFirst(LPSZ path) {
        long ptr = Files.findFirst(path);
        if (ptr == -1L) {
            throw CairoException.critical(Os.errno()).put("findFirst failed on ").put(path);
        }
        return ptr;
    }

    @Override
    public long findName(long findPtr) {
        return Files.findName(findPtr);
    }

    @Override
    public int findNext(long findPtr) {
        int r = Files.findNext(findPtr);
        if (r == -1) {
            throw CairoException.critical(Os.errno()).put("findNext failed");
        }
        return r;
    }

    @Override
    public int findType(long findPtr) {
        return Files.findType(findPtr);
    }

    @Override
    public void fsync(int fd) {
        int res = Files.fsync(fd);
        if (res == 0) {
            return;
        }
        throw CairoException.critical(this.errno()).put("could not fsync [fd=").put(fd).put(']');
    }

    @Override
    public void fsyncAndClose(int fd) {
        int res = Files.fsync(fd);
        if (res == 0) {
            this.close(fd);
            return;
        }
        this.close(fd);
        throw CairoException.critical(this.errno()).put("could not fsync [fd=").put(fd).put(']');
    }

    @Override
    public long getDirSize(Path path) {
        return Files.getDirSize(path);
    }

    @Override
    public long getDiskFreeSpace(LPSZ path) {
        return Files.getDiskFreeSpace(path);
    }

    @Override
    public long getLastModified(LPSZ path) {
        return Files.getLastModified(path);
    }

    @Override
    public long getMapPageSize() {
        if (this.mapPageSize == 0L) {
            this.mapPageSize = this.computeMapPageSize();
        }
        return this.mapPageSize;
    }

    @Override
    public long getOpenFileCount() {
        return Files.getOpenFileCount();
    }

    @Override
    public long getPageSize() {
        return Files.PAGE_SIZE;
    }

    @Override
    public int hardLink(LPSZ src, LPSZ hardLink) {
        return Files.hardLink(src, hardLink);
    }

    @Override
    public int hardLinkDirRecursive(Path src, Path dst, int dirMode) {
        return this.runRecursive(src, dst, dirMode, this.hardLinkFsOperation);
    }

    @Override
    public boolean isCrossDeviceCopyError(int errno) {
        return Os.isPosix() && errno == 18;
    }

    @Override
    public boolean isDirOrSoftLinkDir(LPSZ path) {
        return Files.isDirOrSoftLinkDir(path);
    }

    @Override
    public boolean isDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type) {
        return Files.isDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type);
    }

    @Override
    public boolean isDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type, StringSink nameSink) {
        return Files.isDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type, nameSink);
    }

    @Override
    public boolean isRestrictedFileSystem() {
        return Os.isWindows();
    }

    @Override
    public boolean isSoftLink(LPSZ softLink) {
        return Files.isSoftLink(softLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateDir(LPSZ path, FindVisitor func) {
        long p = this.findFirst(path);
        if (p > 0L) {
            try {
                do {
                    func.onFind(this.findName(p), this.findType(p));
                } while (this.findNext(p) > 0);
            }
            finally {
                this.findClose(p);
            }
        }
    }

    @Override
    public long length(int fd) {
        long r = Files.length(fd);
        if (r < 0L) {
            throw CairoException.critical(Os.errno()).put("Checking file size failed");
        }
        return r;
    }

    @Override
    public long length(LPSZ name) {
        return Files.length(name);
    }

    @Override
    public int lock(int fd) {
        return Files.lock(fd);
    }

    @Override
    public void madvise(long address, long len, int advise) {
        if (advise > -1) {
            Files.madvise(address, len, advise);
        }
    }

    @Override
    public int mkdir(Path path, int mode) {
        return Files.mkdir(path, mode);
    }

    @Override
    public int mkdirs(Path path, int mode) {
        return Files.mkdirs(path, mode);
    }

    @Override
    public long mmap(int fd, long len, long offset, int flags, int memoryTag) {
        return Files.mmap(fd, len, offset, flags, memoryTag);
    }

    @Override
    public long mremap(int fd, long addr, long previousSize, long newSize, long offset, int mode, int memoryTag) {
        return Files.mremap(fd, addr, previousSize, newSize, offset, mode, memoryTag);
    }

    @Override
    public void msync(long addr, long len, boolean async) {
        int res = Files.msync(addr, len, async);
        if (res == 0) {
            return;
        }
        throw CairoException.critical(this.errno()).put("could not msync");
    }

    @Override
    public void munmap(long address, long size, int memoryTag) {
        Files.munmap(address, size, memoryTag);
    }

    @Override
    public int openAppend(LPSZ name) {
        return Files.openAppend(name);
    }

    @Override
    public int openCleanRW(LPSZ name, long size) {
        return Files.openCleanRW(name, size);
    }

    @Override
    public int openRO(LPSZ name) {
        return Files.openRO(name);
    }

    @Override
    public int openRW(LPSZ name, long opts) {
        return Files.openRW(name, opts);
    }

    @Override
    public long read(int fd, long buf, long len, long offset) {
        return Files.read(fd, buf, len, offset);
    }

    @Override
    public boolean readLink(Path softLink, Path readTo) {
        return Files.readLink(softLink, readTo);
    }

    @Override
    public byte readNonNegativeByte(int fd, long offset) {
        return Files.readNonNegativeByte(fd, offset);
    }

    @Override
    public int readNonNegativeInt(int fd, long offset) {
        return Files.readNonNegativeInt(fd, offset);
    }

    @Override
    public long readNonNegativeLong(int fd, long offset) {
        return Files.readNonNegativeLong(fd, offset);
    }

    @Override
    public boolean remove(LPSZ name) {
        return Files.remove(name);
    }

    @Override
    public int rename(LPSZ from, LPSZ to) {
        return Files.rename(from, to);
    }

    @Override
    public int rmdir(Path name) {
        return Files.rmdir(name);
    }

    @Override
    public int softLink(LPSZ src, LPSZ softLink) {
        return Files.softLink(src, softLink);
    }

    @Override
    public int sync() {
        return Files.sync();
    }

    @Override
    public boolean touch(LPSZ path) {
        return Files.touch(path);
    }

    @Override
    public boolean truncate(int fd, long size) {
        return Files.truncate(fd, size);
    }

    @Override
    public int typeDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type, @Nullable StringSink nameSink) {
        return Files.typeDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type, nameSink);
    }

    @Override
    public int unlink(LPSZ softLink) {
        return Files.unlink(softLink);
    }

    @Override
    public int unlinkOrRemove(Path path, Log LOG) {
        int checkedType = this.isSoftLink(path) ? 10 : 0;
        return this.unlinkOrRemove(path, checkedType, LOG);
    }

    @Override
    public int unlinkOrRemove(Path path, int checkedType, Log LOG) {
        int errno;
        if (checkedType == 10) {
            if (this.unlink(path) == 0) {
                LOG.info().$("removed by unlink [path=").utf8(path).I$();
                return 0;
            }
            LOG.error().$("failed to unlink, will remove [path=").utf8(path).I$();
        }
        if ((errno = this.rmdir(path)) == 0) {
            LOG.info().$("removed [path=").utf8(path).I$();
        } else {
            LOG.error().$("cannot remove [path=").utf8(path).$(", errno=").$(errno).I$();
        }
        return errno;
    }

    @Override
    public void walk(Path path, FindVisitor func) {
        Files.walk(path, func);
    }

    @Override
    public long write(int fd, long address, long len, long offset) {
        return Files.write(fd, address, len, offset);
    }

    private long computeMapPageSize() {
        long pageSize = this.getPageSize();
        long mapPageSize = pageSize * pageSize;
        if (mapPageSize < pageSize || mapPageSize > 0x1000000L) {
            if (0x1000000L % pageSize == 0L) {
                return 0x1000000L;
            }
            return pageSize;
        }
        return mapPageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runRecursive(Path src, Path dst, int dirMode, FsOperation operation) {
        int dstLen = dst.length();
        int srcLen = src.length();
        int len = src.length();
        long p = this.findFirst(src.$());
        if (!this.exists(dst.$()) && -1 == this.mkdir(dst, dirMode)) {
            return -1;
        }
        if (p > 0L) {
            try {
                do {
                    int res;
                    long name;
                    if (!Files.notDots(name = this.findName(p))) continue;
                    int type = this.findType(p);
                    src.trimTo(len);
                    src.concat(name);
                    dst.concat(name);
                    if (type == 8) {
                        res = operation.invoke(src.$(), dst.$());
                        if (res < 0) {
                            int n = res;
                            return n;
                        }
                    } else {
                        this.mkdir(dst.$(), dirMode);
                        res = this.runRecursive(src, dst, dirMode, operation);
                        if (res < 0) {
                            int n = res;
                            return n;
                        }
                    }
                    src.trimTo(srcLen);
                    dst.trimTo(dstLen);
                } while (this.findNext(p) > 0);
            }
            finally {
                this.findClose(p);
                src.trimTo(srcLen);
                dst.trimTo(dstLen);
            }
        }
        return 0;
    }

    @FunctionalInterface
    private static interface FsOperation {
        public int invoke(LPSZ var1, LPSZ var2);
    }
}

