/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.AbstractIODispatcher;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.SelectAccessor;
import io.questdb.network.SelectFacade;
import io.questdb.network.SuspendEvent;
import io.questdb.std.LongIntHashMap;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class IODispatcherWindows<C extends IOContext<C>>
extends AbstractIODispatcher<C> {
    private final LongIntHashMap fds = new LongIntHashMap();
    private final FDSet readFdSet;
    private final SelectFacade sf;
    private final FDSet writeFdSet;
    private long idSeq = 1L;
    private boolean listenerRegistered;

    public IODispatcherWindows(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        super(configuration, ioContextFactory);
        this.sf = configuration.getSelectFacade();
        this.readFdSet = new FDSet(configuration.getEventCapacity());
        this.writeFdSet = new FDSet(configuration.getEventCapacity());
        this.readFdSet.add(this.serverFd);
        this.readFdSet.setCount(1);
        this.writeFdSet.setCount(0);
        this.listenerRegistered = true;
    }

    @Override
    public void close() {
        super.close();
        this.readFdSet.close();
        this.writeFdSet.close();
        this.LOG.info().$("closed").$();
    }

    private long nextOpId() {
        return this.idSeq++;
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        while ((cursor = this.interestSubSeq.next()) > -1L) {
            IOEvent evt = (IOEvent)this.interestQueue.get(cursor);
            Object context = evt.context;
            int operation = evt.operation;
            long srcOpId = ((IOContext)context).getAndResetHeartbeatId();
            long opId = this.nextOpId();
            int fd = ((IOContext)context).getFd();
            this.interestSubSeq.done(cursor);
            if (operation == 8) {
                assert (srcOpId != -1L);
                int heartbeatRow = this.pendingHeartbeats.binarySearch(srcOpId, 4);
                if (heartbeatRow < 0) continue;
                operation = (int)this.pendingHeartbeats.get(heartbeatRow, 2);
                this.LOG.debug().$("processing heartbeat registration [fd=").$(fd).$(", op=").$(operation).$(", srcId=").$(srcOpId).$(", id=").$(opId).I$();
                int r = this.pending.addRow();
                this.pending.set(r, 0, this.pendingHeartbeats.get(heartbeatRow, 0));
                this.pending.set(r, 3, timestamp);
                this.pending.set(r, 1, fd);
                this.pending.set(r, 4, opId);
                this.pending.set(r, 2, operation);
                this.pending.set(r, context);
                this.pendingHeartbeats.deleteRow(heartbeatRow);
            } else {
                this.LOG.debug().$("processing registration [fd=").$(fd).$(", op=").$(operation).$(", id=").$(opId).I$();
                int r = this.pending.addRow();
                this.pending.set(r, 0, timestamp);
                this.pending.set(r, 3, timestamp);
                this.pending.set(r, 1, ((IOContext)context).getFd());
                this.pending.set(r, 4, opId);
                this.pending.set(r, 2, operation);
                this.pending.set(r, context);
            }
            useful = true;
        }
        return useful;
    }

    private void queryFdSets(long timestamp) {
        long fd;
        int i;
        int n = this.readFdSet.getCount();
        for (i = 0; i < n; ++i) {
            fd = this.readFdSet.get(i);
            if (fd == (long)this.serverFd) {
                this.accept(timestamp);
                continue;
            }
            this.fds.put(fd, 1);
        }
        n = this.writeFdSet.getCount();
        for (i = 0; i < n; ++i) {
            fd = this.writeFdSet.get(i);
            int index = this.fds.keyIndex(fd);
            if (this.fds.valueAt(index) == -1) {
                this.fds.putAt(index, fd, 2);
                continue;
            }
            this.fds.putAt(index, fd, 3);
        }
    }

    @Override
    protected void pendingAdded(int index) {
        this.pending.set(index, 2, this.initialBias == 1 ? 1L : 4L);
    }

    @Override
    protected void registerListenerFd() {
        this.listenerRegistered = true;
    }

    @Override
    protected boolean runSerially() {
        int count;
        long timestamp = this.clock.getTicks();
        this.processDisconnects(timestamp);
        if (this.readFdSet.getCount() > 0 || this.writeFdSet.getCount() > 0) {
            count = this.sf.select(this.readFdSet.address, this.writeFdSet.address, 0L);
            if (count < 0) {
                this.LOG.error().$("select failure [err=").$(this.nf.errno()).I$();
                return false;
            }
        } else {
            count = 0;
        }
        boolean useful = false;
        this.fds.clear();
        int watermark = this.pending.size();
        if (count > 0) {
            this.queryFdSets(timestamp);
            useful = true;
        }
        useful |= this.processRegistrations(timestamp);
        int readFdCount = 0;
        int writeFdCount = 0;
        this.readFdSet.reset();
        this.writeFdSet.reset();
        long deadline = timestamp - this.idleConnectionTimeout;
        long heartbeatTimestamp = timestamp - this.heartbeatIntervalMs;
        int i = 0;
        int n = this.pending.size();
        while (i < n) {
            IOContext context = (IOContext)this.pending.get(i);
            SuspendEvent suspendEvent = context.getSuspendEvent();
            if (suspendEvent != null && (suspendEvent.checkTriggered() || suspendEvent.isDeadlineMet(timestamp))) {
                context.clearSuspendEvent();
            }
            int fd = (int)this.pending.get(i, 1);
            int newOp = this.fds.get(fd);
            assert (fd != this.serverFd);
            if (newOp == -1) {
                if (this.pending.get(i, 0) < deadline) {
                    this.doDisconnect(context, 1);
                    this.pending.deleteRow(i);
                    --n;
                    if (i < watermark) {
                        --watermark;
                    }
                    useful = true;
                    continue;
                }
                if (i < watermark && this.pending.get(i, 3) < heartbeatTimestamp) {
                    long opId = this.pending.get(i, 4);
                    context.setHeartbeatId(opId);
                    this.publishOperation(8, context);
                    int r = this.pendingHeartbeats.addRow();
                    this.pendingHeartbeats.set(r, 0, this.pending.get(i, 0));
                    this.pendingHeartbeats.set(r, 1, fd);
                    this.pendingHeartbeats.set(r, 4, opId);
                    this.pendingHeartbeats.set(r, 2, this.pending.get(i, 2));
                    this.pendingHeartbeats.set(r, context);
                    this.pending.deleteRow(i);
                    --n;
                    --watermark;
                    useful = true;
                    continue;
                }
                int operation = (int)this.pending.get(i, 2);
                ++i;
                if (suspendEvent != null) {
                    operation = 1;
                }
                if (operation == 1) {
                    this.readFdSet.add(fd);
                    ++readFdCount;
                    continue;
                }
                this.writeFdSet.add(fd);
                ++writeFdCount;
                continue;
            }
            if (suspendEvent != null) {
                if (this.testConnection(context.getFd())) {
                    this.doDisconnect(context, 3);
                    this.pending.deleteRow(i);
                    --n;
                    --watermark;
                    continue;
                }
                ++i;
                continue;
            }
            useful = true;
            if ((newOp & 1) > 0) {
                this.publishOperation(1, context);
            }
            if ((newOp & 2) > 0) {
                this.publishOperation(4, context);
            }
            this.pending.deleteRow(i);
            --n;
            --watermark;
        }
        if (this.listenerRegistered) {
            assert (this.serverFd >= 0);
            this.readFdSet.add(this.serverFd);
            ++readFdCount;
        }
        this.readFdSet.setCount(readFdCount);
        this.writeFdSet.setCount(writeFdCount);
        return useful;
    }

    @Override
    protected void unregisterListenerFd() {
        this.listenerRegistered = false;
    }

    private static class FDSet {
        private long _wptr;
        private long address;
        private long lim;
        private int size;

        private FDSet(int size) {
            int l = SelectAccessor.ARRAY_OFFSET + 8 * size;
            this.address = Unsafe.malloc(l, 49);
            this.size = size;
            this._wptr = this.address + (long)SelectAccessor.ARRAY_OFFSET;
            this.lim = this.address + (long)l;
        }

        private void add(int fd) {
            if (this._wptr == this.lim) {
                this.resize();
            }
            long p = this._wptr;
            Unsafe.getUnsafe().putLong(p, fd);
            this._wptr = p + 8L;
        }

        private void close() {
            if (this.address != 0L) {
                this.address = Unsafe.free(this.address, this.lim - this.address, 49);
            }
        }

        private long get(int index) {
            return Unsafe.getUnsafe().getLong(this.address + (long)SelectAccessor.ARRAY_OFFSET + (long)index * 8L);
        }

        private int getCount() {
            return Unsafe.getUnsafe().getInt(this.address + (long)SelectAccessor.COUNT_OFFSET);
        }

        private void reset() {
            this._wptr = this.address + (long)SelectAccessor.ARRAY_OFFSET;
        }

        private void resize() {
            int sz = this.size * 2;
            int l = SelectAccessor.ARRAY_OFFSET + 8 * sz;
            long _addr = Unsafe.malloc(l, 49);
            Vect.memcpy(_addr, this.address, this.lim - this.address);
            Unsafe.free(this.address, this.lim - this.address, 49);
            this.lim = _addr + (long)l;
            this.size = sz;
            this._wptr = _addr + (this._wptr - this.address);
            this.address = _addr;
        }

        private void setCount(int count) {
            Unsafe.getUnsafe().putInt(this.address + (long)SelectAccessor.COUNT_OFFSET, count);
        }
    }
}

