/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SPSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.IORequestProcessor;
import io.questdb.network.Net;
import io.questdb.network.NetworkError;
import io.questdb.network.NetworkFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjLongMatrix;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractIODispatcher<C extends IOContext<C>>
extends SynchronizedJob
implements IODispatcher<C>,
EagerThreadSetup {
    protected static final int DISCONNECT_SRC_IDLE = 1;
    protected static final int DISCONNECT_SRC_PEER_DISCONNECT = 3;
    protected static final int DISCONNECT_SRC_QUEUE = 0;
    protected static final int DISCONNECT_SRC_SHUTDOWN = 2;
    protected static final int OPM_CREATE_TIMESTAMP = 0;
    protected static final int OPM_FD = 1;
    protected static final int OPM_HEARTBEAT_TIMESTAMP = 3;
    protected static final int OPM_ID = 4;
    protected static final int OPM_COLUMN_COUNT = 5;
    protected static final int OPM_OPERATION = 2;
    private static final String[] DISCONNECT_SOURCES = new String[]{"queue", "idle", "shutdown", "peer"};
    protected final Log LOG;
    protected final int activeConnectionLimit;
    protected final MillisecondClock clock;
    protected final MPSequence disconnectPubSeq;
    protected final RingQueue<IOEvent<C>> disconnectQueue;
    protected final SCSequence disconnectSubSeq;
    protected final long idleConnectionTimeout;
    protected final int initialBias;
    protected final MPSequence interestPubSeq;
    protected final RingQueue<IOEvent<C>> interestQueue;
    protected final SCSequence interestSubSeq;
    protected final IOContextFactory<C> ioContextFactory;
    protected final SPSequence ioEventPubSeq;
    protected final RingQueue<IOEvent<C>> ioEventQueue;
    protected final MCSequence ioEventSubSeq;
    protected final NetworkFacade nf;
    protected final ObjLongMatrix<C> pending = new ObjLongMatrix(5);
    protected final ObjLongMatrix<C> pendingHeartbeats = new ObjLongMatrix(5);
    private final IODispatcherConfiguration configuration;
    private final AtomicInteger connectionCount = new AtomicInteger();
    private final boolean peerNoLinger;
    private final long queuedConnectionTimeoutMs;
    private final int rcvBufSize;
    private final int sndBufSize;
    private final int testConnectionBufSize;
    protected boolean closed = false;
    protected long heartbeatIntervalMs;
    protected int serverFd;
    private long closeListenFdEpochMs;
    private volatile boolean listening;
    private int port;
    protected final QueueConsumer<IOEvent<C>> disconnectContextRef = this::disconnectContext;
    private long testConnectionBuf;

    public AbstractIODispatcher(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        this.LOG = LogFactory.getLog(configuration.getDispatcherLogName());
        this.configuration = configuration;
        this.nf = configuration.getNetworkFacade();
        this.testConnectionBufSize = configuration.getTestConnectionBufferSize();
        this.testConnectionBuf = Unsafe.malloc(this.testConnectionBufSize, 1);
        this.interestQueue = new RingQueue<IOEvent>(IOEvent::new, configuration.getInterestQueueCapacity());
        this.interestPubSeq = new MPSequence(this.interestQueue.getCycle());
        this.interestSubSeq = new SCSequence();
        this.interestPubSeq.then(this.interestSubSeq).then(this.interestPubSeq);
        this.ioEventQueue = new RingQueue<IOEvent>(IOEvent::new, configuration.getIOQueueCapacity());
        this.ioEventPubSeq = new SPSequence(configuration.getIOQueueCapacity());
        this.ioEventSubSeq = new MCSequence(configuration.getIOQueueCapacity());
        this.ioEventPubSeq.then(this.ioEventSubSeq).then(this.ioEventPubSeq);
        this.disconnectQueue = new RingQueue<IOEvent>(IOEvent::new, configuration.getIOQueueCapacity());
        this.disconnectPubSeq = new MPSequence(this.disconnectQueue.getCycle());
        this.disconnectSubSeq = new SCSequence();
        this.disconnectPubSeq.then(this.disconnectSubSeq).then(this.disconnectPubSeq);
        this.clock = configuration.getClock();
        this.activeConnectionLimit = configuration.getLimit();
        this.ioContextFactory = ioContextFactory;
        this.initialBias = configuration.getInitialBias();
        this.idleConnectionTimeout = configuration.getTimeout() > 0L ? configuration.getTimeout() : Long.MIN_VALUE;
        this.queuedConnectionTimeoutMs = configuration.getQueueTimeout() > 0L ? configuration.getQueueTimeout() : 0L;
        this.sndBufSize = configuration.getSndBufSize();
        this.rcvBufSize = configuration.getRcvBufSize();
        this.peerNoLinger = configuration.getPeerNoLinger();
        this.port = 0;
        this.heartbeatIntervalMs = configuration.getHeartbeatInterval() > 0L ? configuration.getHeartbeatInterval() : Long.MIN_VALUE;
        this.createListenFd();
        this.listening = true;
    }

    @Override
    public void close() {
        int i;
        this.closed = true;
        this.processDisconnects(Long.MAX_VALUE);
        int n = this.pending.size();
        for (i = 0; i < n; ++i) {
            this.doDisconnect((IOContext)this.pending.get(i), 2);
        }
        this.interestSubSeq.consumeAll(this.interestQueue, this.disconnectContextRef);
        this.ioEventSubSeq.consumeAll(this.ioEventQueue, this.disconnectContextRef);
        n = this.pendingHeartbeats.size();
        for (i = 0; i < n; ++i) {
            this.doDisconnect((IOContext)this.pendingHeartbeats.get(i), 2);
        }
        if (this.serverFd > 0) {
            this.nf.close(this.serverFd, this.LOG);
            this.serverFd = -1;
        }
        this.testConnectionBuf = Unsafe.free(this.testConnectionBuf, this.testConnectionBufSize, 1);
    }

    @Override
    public void disconnect(C context, int reason) {
        this.LOG.info().$("scheduling disconnect [fd=").$(((IOContext)context).getFd()).$(", reason=").$(reason).I$();
        long cursor = this.disconnectPubSeq.nextBully();
        assert (cursor > -1L);
        this.disconnectQueue.get((long)cursor).context = context;
        this.disconnectPubSeq.done(cursor);
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount.get();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    public boolean processIOQueue(IORequestProcessor<C> processor) {
        long cursor = this.ioEventSubSeq.next();
        while (cursor == -2L) {
            Os.pause();
            cursor = this.ioEventSubSeq.next();
        }
        boolean useful = false;
        if (cursor > -1L) {
            IOEvent<C> event = this.ioEventQueue.get(cursor);
            Object connectionContext = event.context;
            int operation = event.operation;
            this.ioEventSubSeq.done(cursor);
            useful = processor.onRequest(operation, connectionContext);
        }
        return useful;
    }

    @Override
    public void registerChannel(C context, int operation) {
        long cursor = this.interestPubSeq.nextBully();
        IOEvent<C> evt = this.interestQueue.get(cursor);
        evt.context = context;
        evt.operation = operation;
        this.LOG.debug().$("queuing [fd=").$(((IOContext)context).getFd()).$(", op=").$(operation).I$();
        this.interestPubSeq.done(cursor);
    }

    @Override
    public void setup() {
        if (this.ioContextFactory instanceof EagerThreadSetup) {
            ((EagerThreadSetup)((Object)this.ioContextFactory)).setup();
        }
    }

    private void addPending(int fd, long timestamp) {
        int r = this.pending.addRow();
        this.LOG.debug().$("pending [row=").$(r).$(", fd=").$(fd).$(']').$();
        this.pending.set(r, 0, timestamp);
        this.pending.set(r, 3, timestamp);
        this.pending.set(r, 1, fd);
        this.pending.set(r, 2, -1L);
        this.pending.set(r, this.ioContextFactory.newInstance(fd, this));
        this.pendingAdded(r);
    }

    private void createListenFd() throws NetworkError {
        this.serverFd = this.nf.socketTcp(false);
        int backlog = this.configuration.getListenBacklog();
        if (this.port == 0) {
            this.port = this.configuration.getBindPort();
        }
        if (this.nf.bindTcp(this.serverFd, this.configuration.getBindIPv4Address(), this.port)) {
            if (this.port == 0) {
                this.port = this.nf.resolvePort(this.serverFd);
            }
        } else {
            throw NetworkError.instance(this.nf.errno()).couldNotBindSocket(this.configuration.getDispatcherLogName(), this.configuration.getBindIPv4Address(), this.port);
        }
        this.nf.listen(this.serverFd, backlog);
        this.LOG.advisory().$("listening on ").$ip(this.configuration.getBindIPv4Address()).$(':').$(this.configuration.getBindPort()).$(" [fd=").$(this.serverFd).$(" backlog=").$(backlog).I$();
    }

    private void disconnectContext(IOEvent<C> event) {
        long heartbeatOpId;
        Object context = event.context;
        if (context != null && !((IOContext)context).invalid() && (heartbeatOpId = ((IOContext)context).getAndResetHeartbeatId()) != -1L) {
            int r = this.pendingHeartbeats.binarySearch(heartbeatOpId, 4);
            if (r < 0) {
                this.LOG.critical().$("internal error: heartbeat not found [opId=").$(heartbeatOpId).I$();
            } else {
                this.pendingHeartbeats.deleteRow(r);
            }
        }
        this.doDisconnect(context, 0);
    }

    protected void accept(long timestamp) {
        int tlConCount = this.connectionCount.get();
        while (tlConCount < this.activeConnectionLimit) {
            int fd = this.nf.accept(this.serverFd);
            if (fd < 0) {
                if (this.nf.errno() == Net.EWOULDBLOCK) break;
                this.LOG.error().$("could not accept [ret=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
                break;
            }
            if (this.nf.configureNonBlocking(fd) < 0) {
                this.LOG.error().$("could not configure non-blocking [fd=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
                this.nf.close(fd, this.LOG);
                break;
            }
            if (this.nf.setTcpNoDelay(fd, true) < 0) {
                this.LOG.info().$("could not turn off Nagle's algorithm [fd=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
            }
            if (this.peerNoLinger) {
                this.nf.configureNoLinger(fd);
            }
            if (this.sndBufSize > 0) {
                this.nf.setSndBuf(fd, this.sndBufSize);
            }
            if (this.rcvBufSize > 0) {
                this.nf.setRcvBuf(fd, this.rcvBufSize);
            }
            this.LOG.info().$("connected [ip=").$ip(this.nf.getPeerIP(fd)).$(", fd=").$(fd).$(']').$();
            tlConCount = this.connectionCount.incrementAndGet();
            this.addPending(fd, timestamp);
        }
        if (tlConCount >= this.activeConnectionLimit && this.connectionCount.get() >= this.activeConnectionLimit) {
            this.unregisterListenerFd();
            this.listening = false;
            this.closeListenFdEpochMs = timestamp + this.queuedConnectionTimeoutMs;
            this.LOG.info().$("max connection limit reached, unregistered listener [serverFd=").$(this.serverFd).I$();
        }
    }

    protected void doDisconnect(C context, int src) {
        if (context == null || ((IOContext)context).invalid()) {
            return;
        }
        int fd = ((IOContext)context).getFd();
        this.LOG.info().$("disconnected [ip=").$ip(this.nf.getPeerIP(fd)).$(", fd=").$(fd).$(", src=").$(DISCONNECT_SOURCES[src]).I$();
        this.nf.close(fd, this.LOG);
        if (this.closed) {
            Misc.free(context);
        } else {
            this.ioContextFactory.done(context);
        }
        if (this.connectionCount.getAndDecrement() >= this.activeConnectionLimit && this.connectionCount.get() < this.activeConnectionLimit) {
            if (this.serverFd < 0) {
                this.createListenFd();
            }
            this.registerListenerFd();
            this.listening = true;
            this.LOG.info().$("below maximum connection limit, registered listener [serverFd=").$(this.serverFd).I$();
        }
    }

    protected abstract void pendingAdded(int var1);

    protected void processDisconnects(long epochMs) {
        this.disconnectSubSeq.consumeAll(this.disconnectQueue, this.disconnectContextRef);
        if (!this.listening && this.serverFd >= 0 && epochMs >= this.closeListenFdEpochMs) {
            this.LOG.error().$("been unable to accept connections for ").$(this.queuedConnectionTimeoutMs).$("ms, closing listener [serverFd=").$(this.serverFd).I$();
            this.nf.close(this.serverFd);
            this.serverFd = -1;
        }
    }

    protected void publishOperation(int operation, C context) {
        long cursor = this.ioEventPubSeq.nextBully();
        IOEvent<C> evt = this.ioEventQueue.get(cursor);
        evt.context = context;
        evt.operation = operation;
        this.ioEventPubSeq.done(cursor);
        this.LOG.debug().$("fired [fd=").$(((IOContext)context).getFd()).$(", op=").$(operation).$(", pos=").$(cursor).I$();
    }

    protected abstract void registerListenerFd();

    protected boolean testConnection(int fd) {
        return this.nf.testConnection(fd, this.testConnectionBuf, this.testConnectionBufSize);
    }

    protected abstract void unregisterListenerFd();
}

