/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.log.Log;
import io.questdb.metrics.HealthMetrics;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.mp.Job;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.WorkerCleaner;
import io.questdb.std.ObjHashSet;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import java.util.concurrent.atomic.AtomicInteger;

public class Worker
extends Thread {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final int affinity;
    private final WorkerCleaner cleaner;
    private final String criticalErrorLine;
    private final SOCountDownLatch haltLatch;
    private final boolean haltOnError;
    private final ObjHashSet<? extends Job> jobs;
    private final Log log;
    private final HealthMetrics metrics;
    private final AtomicInteger running = new AtomicInteger();
    private final Job.RunStatus runStatus = () -> this.running.get() == 2;
    private final long sleepMs;
    private final long sleepThreshold;
    private final int workerId;
    private final long yieldThreshold;

    public Worker(ObjHashSet<? extends Job> jobs, SOCountDownLatch haltLatch, int affinity, Log log, WorkerCleaner cleaner, boolean haltOnError, int workerId, String poolName, long yieldThreshold, long sleepThreshold, long sleepMs, HealthMetrics metrics) {
        this.log = log;
        this.jobs = jobs;
        this.haltLatch = haltLatch;
        this.setName("questdb-" + poolName + "-" + COUNTER.incrementAndGet());
        this.affinity = affinity;
        this.cleaner = cleaner;
        this.haltOnError = haltOnError;
        this.workerId = workerId;
        this.yieldThreshold = yieldThreshold;
        this.sleepThreshold = sleepThreshold;
        this.sleepMs = sleepMs;
        this.metrics = metrics;
        this.criticalErrorLine = "0000-00-00T00:00:00.000000Z C Unhandled exception in worker " + this.getName();
    }

    public int getWorkerId() {
        return this.workerId;
    }

    public void halt() {
        this.running.set(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable ex = null;
        try {
            if (this.running.compareAndSet(0, 1)) {
                if (this.affinity > -1) {
                    if (Os.setCurrentThreadAffinity(this.affinity) == 0) {
                        if (this.log != null) {
                            this.log.info().$("affinity set [cpu=").$(this.affinity).$(", name=").$(this.getName()).I$();
                        }
                    } else if (this.log != null) {
                        this.log.error().$("could not set affinity [cpu=").$(this.affinity).$(", name=").$(this.getName()).I$();
                    }
                } else if (this.log != null) {
                    this.log.info().$("os scheduled worker started [name=").$(this.getName()).I$();
                }
                this.setupJobs();
                int n = this.jobs.size();
                long uselessCounter = 0L;
                while (this.running.get() == 1) {
                    boolean useful = false;
                    for (int i = 0; i < n; ++i) {
                        Unsafe.getUnsafe().loadFence();
                        try {
                            try {
                                useful |= this.jobs.get(i).run(this.workerId, this.runStatus);
                            }
                            catch (Throwable e) {
                                this.onError(i, e);
                            }
                            continue;
                        }
                        finally {
                            Unsafe.getUnsafe().storeFence();
                        }
                    }
                    if (useful) {
                        uselessCounter = 0L;
                        continue;
                    }
                    if (++uselessCounter < 0L) {
                        uselessCounter = this.sleepThreshold + 1L;
                    }
                    if (uselessCounter > this.sleepThreshold) {
                        Os.sleep(this.sleepMs);
                        continue;
                    }
                    if (uselessCounter <= this.yieldThreshold) continue;
                    Os.pause();
                }
            }
        }
        catch (Throwable e) {
            ex = e;
            this.stdErrCritical(e);
        }
        finally {
            if (this.cleaner != null) {
                this.cleaner.run(ex);
            }
            this.haltLatch.countDown();
            if (this.log != null) {
                this.log.info().$("os scheduled worker stopped [name=").$(this.getName()).I$();
            }
        }
    }

    private void onError(int i, Throwable e) throws Throwable {
        try {
            this.metrics.incrementUnhandledErrors();
        }
        catch (Throwable t) {
            this.stdErrCritical(e);
        }
        if (this.log != null) {
            this.log.critical().$("unhandled error [job=").$(this.jobs.get(i).toString()).$(", ex=").$(e).I$();
        } else {
            this.stdErrCritical(e);
        }
        if (this.haltOnError) {
            throw e;
        }
    }

    private void setupJobs() {
        if (this.running.get() == 1) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                Unsafe.getUnsafe().loadFence();
                try {
                    Job job = this.jobs.get(i);
                    if (!(job instanceof EagerThreadSetup)) continue;
                    ((EagerThreadSetup)((Object)job)).setup();
                    continue;
                }
                finally {
                    Unsafe.getUnsafe().storeFence();
                }
            }
        }
    }

    private void stdErrCritical(Throwable e) {
        System.err.println(this.criticalErrorLine);
        e.printStackTrace();
    }
}

