/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.Job;
import io.questdb.std.Unsafe;
import org.jetbrains.annotations.NotNull;

public abstract class SynchronizedJob
implements Job {
    private static final long LOCKED_OFFSET = Unsafe.getFieldOffset(SynchronizedJob.class, "locked");
    private volatile int locked = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(int workerId, @NotNull Job.RunStatus runStatus) {
        if (Unsafe.getUnsafe().compareAndSwapInt(this, LOCKED_OFFSET, 0, 1)) {
            try {
                boolean bl = this.runSerially();
                return bl;
            }
            finally {
                this.locked = 0;
            }
        }
        return false;
    }

    @Override
    public boolean run(int workerId) {
        return this.run(workerId, Job.RUNNING_STATUS);
    }

    protected abstract boolean runSerially();
}

