/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.Counter;
import io.questdb.metrics.CounterImpl;
import io.questdb.metrics.CounterWithOneLabel;
import io.questdb.metrics.CounterWithOneLabelImpl;
import io.questdb.metrics.CounterWithTwoLabels;
import io.questdb.metrics.CounterWithTwoLabelsImpl;
import io.questdb.metrics.DoubleGauge;
import io.questdb.metrics.DoubleGaugeImpl;
import io.questdb.metrics.LongGauge;
import io.questdb.metrics.LongGaugeImpl;
import io.questdb.metrics.MemoryTagLongGauge;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.metrics.Scrapable;
import io.questdb.metrics.VirtualLongGauge;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class MetricsRegistryImpl
implements MetricsRegistry {
    private final ObjList<Scrapable> metrics = new ObjList();

    @Override
    public void addScrapable(Scrapable scrapable) {
        this.metrics.add(scrapable);
    }

    @Override
    public Counter newCounter(CharSequence name) {
        CounterImpl counter = new CounterImpl(name);
        this.metrics.add(counter);
        return counter;
    }

    @Override
    public CounterWithOneLabel newCounter(CharSequence name, CharSequence labelName0, CharSequence[] labelValues0) {
        CounterWithOneLabelImpl counter = new CounterWithOneLabelImpl(name, labelName0, labelValues0);
        this.metrics.add(counter);
        return counter;
    }

    @Override
    public CounterWithTwoLabels newCounter(CharSequence name, CharSequence labelName0, CharSequence[] labelValues0, CharSequence labelName1, CharSequence[] labelValues1) {
        CounterWithTwoLabelsImpl counter = new CounterWithTwoLabelsImpl(name, labelName0, labelValues0, labelName1, labelValues1);
        this.metrics.add(counter);
        return counter;
    }

    @Override
    public DoubleGauge newDoubleGauge(CharSequence name) {
        DoubleGaugeImpl gauge = new DoubleGaugeImpl(name);
        this.metrics.add(gauge);
        return gauge;
    }

    @Override
    public LongGauge newLongGauge(CharSequence name) {
        LongGaugeImpl gauge = new LongGaugeImpl(name);
        this.metrics.add(gauge);
        return gauge;
    }

    @Override
    public LongGauge newLongGauge(int memoryTag) {
        MemoryTagLongGauge gauge = new MemoryTagLongGauge(memoryTag);
        this.metrics.add(gauge);
        return gauge;
    }

    @Override
    public LongGauge newVirtualGauge(CharSequence _name, VirtualLongGauge.StatProvider provider) {
        VirtualLongGauge gauge = new VirtualLongGauge(_name, provider);
        this.metrics.add(gauge);
        return gauge;
    }

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        int n = this.metrics.size();
        for (int i = 0; i < n; ++i) {
            Scrapable metric = this.metrics.getQuick(i);
            metric.scrapeIntoPrometheus(sink);
        }
    }
}

