/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.std.Chars;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;

public class LogRecordSink
extends AbstractCharSink
implements Sinkable {
    public static final int EOL_LENGTH = "\r\n".length();
    public static final int UTF8_BYTE_CLASS_BAD = -1;
    public static final int UTF8_BYTE_CLASS_CONTINUATION = 0;
    protected final long address;
    protected final long lim;
    protected long _wptr;
    private boolean done = false;
    private int level;

    public LogRecordSink(long address, long addressSize) {
        this.address = this._wptr = address;
        this.lim = address + addressSize;
    }

    public void clear() {
        this._wptr = this.address;
        this.done = false;
    }

    public long getAddress() {
        return this.address;
    }

    public int getLevel() {
        return this.level;
    }

    public int length() {
        return (int)(this._wptr - this.address);
    }

    @Override
    public CharSink put(CharSequence cs) {
        int rem = (int)(this.lim - this._wptr - (long)EOL_LENGTH);
        int len = cs.length();
        int n = Math.min(rem, len);
        Chars.asciiStrCpy(cs, n, this._wptr);
        this._wptr += (long)n;
        return this;
    }

    @Override
    public CharSink put(CharSequence cs, int lo, int hi) {
        int rem = (int)(this.lim - this._wptr - (long)EOL_LENGTH);
        int len = hi - lo;
        int n = Math.min(rem, len);
        Chars.asciiStrCpy(cs, lo, n, this._wptr);
        this._wptr += (long)n;
        return this;
    }

    @Override
    public CharSink put(char c) {
        long left = this.lim - this._wptr - (long)EOL_LENGTH;
        byte b = (byte)c;
        if (left >= 4L) {
            Unsafe.getUnsafe().putByte(this._wptr++, b);
            return this;
        }
        if (this.done) {
            return this;
        }
        long needed = this.utf8charNeeded(b);
        if (needed == -1L) {
            b = 63;
            needed = 1L;
        }
        if (left >= needed) {
            Unsafe.getUnsafe().putByte(this._wptr++, b);
        } else {
            this.done = true;
        }
        return this;
    }

    @Override
    public CharSink putEOL() {
        int rem = (int)(this.lim - this._wptr);
        int len = "\r\n".length();
        int n = Math.min(rem, len);
        Chars.asciiStrCpy("\r\n", n, this._wptr);
        this._wptr += (long)n;
        return this;
    }

    @Override
    public CharSink putUtf8(long lo, long hi) {
        long rem = this.lim - this._wptr - (long)EOL_LENGTH;
        long len = hi - lo;
        if (rem >= len) {
            Unsafe.getUnsafe().copyMemory(lo, this._wptr, len);
            this._wptr += len;
            return this;
        }
        long safeLen = rem - 4L;
        if (safeLen > 0L) {
            Unsafe.getUnsafe().copyMemory(lo, this._wptr, safeLen);
            this._wptr += safeLen;
        }
        for (long i = safeLen = Math.max(0L, safeLen); i < rem; ++i) {
            this.put((char)Unsafe.getUnsafe().getByte(lo + i));
        }
        return this;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void toSink(CharSink sink) {
        Chars.utf8toUtf16(this.address, this._wptr, sink);
    }

    private static int utf8byteClass(byte b) {
        if (b >= 0) {
            return 1;
        }
        if ((b & 0xC0) == 128) {
            return 0;
        }
        if ((b & 0xE0) == 192) {
            return 2;
        }
        if ((b & 0xF0) == 224) {
            return 3;
        }
        if ((b & 0xF8) == 240) {
            return 4;
        }
        return -1;
    }

    private int utf8charNeeded(byte b) {
        int byteClass = LogRecordSink.utf8byteClass(b);
        switch (byteClass) {
            case -1: {
                return -1;
            }
            case 0: {
                long ptr;
                int multibyteLength = -1;
                long boundary = Math.max(this.address, this._wptr - 4L);
                block8: for (ptr = this._wptr - 1L; ptr >= boundary; --ptr) {
                    byte prev = Unsafe.getUnsafe().getByte(ptr);
                    multibyteLength = LogRecordSink.utf8byteClass(prev);
                    switch (multibyteLength) {
                        case -1: {
                            return -1;
                        }
                        case 0: {
                            continue block8;
                        }
                    }
                }
                if ((multibyteLength -= (int)(this._wptr - ptr)) < 1) {
                    multibyteLength = -1;
                }
                return multibyteLength;
            }
        }
        return byteClass;
    }
}

