/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.ObjList;

public class SequentialRowCursorFactory
implements RowCursorFactory {
    private final SequentialRowCursor cursor;
    private final ObjList<? extends RowCursorFactory> cursorFactories;
    private final int[] cursorFactoriesIdx;
    private final ObjList<RowCursor> cursors;

    public SequentialRowCursorFactory(ObjList<? extends RowCursorFactory> cursorFactories, int[] cursorFactoriesIdx) {
        this.cursorFactories = cursorFactories;
        this.cursors = new ObjList();
        this.cursor = new SequentialRowCursor();
        this.cursorFactoriesIdx = cursorFactoriesIdx;
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        int n = this.cursorFactoriesIdx[0];
        for (int i = 0; i < n; ++i) {
            this.cursors.extendAndSet(i, this.cursorFactories.getQuick(i).getCursor(dataFrame));
        }
        this.cursor.init();
        return this.cursor;
    }

    @Override
    public void init(TableReader tableReader, SqlExecutionContext sqlExecutionContext) throws SqlException {
        RowCursorFactory.init(this.cursorFactories, tableReader, sqlExecutionContext);
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public void prepareCursor(TableReader tableReader) {
        RowCursorFactory.prepareCursor(this.cursorFactories, tableReader);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Cursor-order scan");
        int n = this.cursorFactories.size();
        for (int i = 0; i < n; ++i) {
            sink.child(this.cursorFactories.getQuick(i));
        }
    }

    private class SequentialRowCursor
    implements RowCursor {
        private RowCursor currentCursor;
        private int cursorIndex = 0;

        private SequentialRowCursor() {
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.currentCursor.hasNext();
            if (hasNext) {
                return true;
            }
            while (this.cursorIndex < SequentialRowCursorFactory.this.cursorFactoriesIdx[0] - 1) {
                this.currentCursor = SequentialRowCursorFactory.this.cursors.getQuick(++this.cursorIndex);
                if (!this.currentCursor.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public long next() {
            return this.currentCursor.next();
        }

        private void init() {
            this.cursorIndex = 0;
            if (this.cursorIndex < SequentialRowCursorFactory.this.cursorFactoriesIdx[0]) {
                this.currentCursor = SequentialRowCursorFactory.this.cursors.getQuick(this.cursorIndex);
            }
        }
    }
}

