/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;

class LatestByValueRecordCursor
extends AbstractDataFrameRecordCursor {
    private final int columnIndex;
    private final int symbolKey;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private boolean hasNext;
    private boolean isFindPending;
    private boolean isRecordFound;

    public LatestByValueRecordCursor(int columnIndex, int symbolKey, @NotNull IntList columnIndexes) {
        super(columnIndexes);
        this.columnIndex = columnIndex;
        this.symbolKey = symbolKey;
    }

    @Override
    public boolean hasNext() {
        if (!this.isFindPending) {
            this.findRecord();
            this.toTop();
            this.isFindPending = true;
        }
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.isRecordFound = false;
        this.isFindPending = false;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Row backward scan");
        sink.attr("symbolFilter").putColumnName(this.columnIndex).val('=').val(this.symbolKey);
    }

    @Override
    public void toTop() {
        this.hasNext = this.isRecordFound;
    }

    private void findRecord() {
        DataFrame frame;
        block0: while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(frame.getPartitionIndex(), rowHi);
            for (long row = rowHi; row >= rowLo; --row) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (key != this.symbolKey) continue;
                this.isRecordFound = true;
                break block0;
            }
        }
    }
}

