/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesRecordCursor;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestBySubQueryRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    private final int columnIndex;
    private final Function filter;
    private final Record.CharSequenceFunction func;
    private final RecordCursorFactory recordCursorFactory;
    private final IntHashSet symbolKeys = new IntHashSet();

    public LatestBySubQueryRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, @NotNull RecordCursorFactory recordCursorFactory, @Nullable Function filter, boolean indexed, @NotNull Record.CharSequenceFunction func, @NotNull IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory, configuration);
        AbstractDataFrameRecordCursor cursor = indexed ? (filter != null ? new LatestByValuesIndexedFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, null, filter, columnIndexes) : new LatestByValuesIndexedRecordCursor(columnIndex, this.symbolKeys, null, this.rows, columnIndexes)) : (filter != null ? new LatestByValuesFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, null, filter, columnIndexes) : new LatestByValuesRecordCursor(columnIndex, this.rows, this.symbolKeys, null, columnIndexes));
        this.cursor = new DataFrameRecordCursorWrapper(cursor);
        this.recordCursorFactory = recordCursorFactory;
        this.filter = filter;
        this.columnIndex = columnIndex;
        this.func = func;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestBySubQuery");
        sink.child("Subquery", this.recordCursorFactory);
        sink.child(this.cursor);
        sink.child(this.dataFrameCursorFactory);
    }

    @Override
    protected void _close() {
        super._close();
        this.recordCursorFactory.close();
        Misc.free(this.filter);
    }

    private class DataFrameRecordCursorWrapper
    implements DataFrameRecordCursor {
        private final DataFrameRecordCursor delegate;
        private RecordCursor baseCursor;

        private DataFrameRecordCursorWrapper(DataFrameRecordCursor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
            this.delegate.close();
        }

        @Override
        public IntList getColumnIndexes() {
            return this.delegate.getColumnIndexes();
        }

        @Override
        public DataFrameCursor getDataFrameCursor() {
            return this.delegate.getDataFrameCursor();
        }

        @Override
        public Record getRecord() {
            return this.delegate.getRecord();
        }

        @Override
        public Record getRecordB() {
            return this.delegate.getRecordB();
        }

        @Override
        public StaticSymbolTable getSymbolTable(int columnIndex) {
            return this.delegate.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (this.baseCursor != null) {
                this.buildSymbolKeys();
                this.baseCursor = Misc.free(this.baseCursor);
            }
            return this.delegate.hasNext();
        }

        @Override
        public boolean isUsingIndex() {
            return this.delegate.isUsingIndex();
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.delegate.newSymbolTable(columnIndex);
        }

        @Override
        public void of(DataFrameCursor cursor, SqlExecutionContext executionContext) throws SqlException {
            if (this.baseCursor != null) {
                this.baseCursor = Misc.free(this.baseCursor);
            }
            this.baseCursor = LatestBySubQueryRecordCursorFactory.this.recordCursorFactory.getCursor(executionContext);
            LatestBySubQueryRecordCursorFactory.this.symbolKeys.clear();
            this.delegate.of(cursor, executionContext);
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.delegate.recordAt(record, atRowId);
        }

        @Override
        public long size() {
            return this.delegate.size();
        }

        @Override
        public boolean skipTo(long rowCount) {
            return this.delegate.skipTo(rowCount);
        }

        @Override
        public void toPlan(PlanSink sink) {
            this.delegate.toPlan(sink);
        }

        @Override
        public void toTop() {
            this.delegate.toTop();
        }

        private void buildSymbolKeys() {
            StaticSymbolTable symbolTable = this.getDataFrameCursor().getSymbolTable(LatestBySubQueryRecordCursorFactory.this.columnIndex);
            Record record = this.baseCursor.getRecord();
            while (this.baseCursor.hasNext()) {
                int symbolKey = symbolTable.keyOf(LatestBySubQueryRecordCursorFactory.this.func.get(record, 0));
                if (symbolKey == -2) continue;
                LatestBySubQueryRecordCursorFactory.this.symbolKeys.add(TableUtils.toIndexKey(symbolKey));
            }
        }
    }
}

