/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllIndexedRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import org.jetbrains.annotations.NotNull;

public class LatestByAllIndexedRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    protected final DirectLongList prefixes;

    public LatestByAllIndexedRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull CairoConfiguration configuration, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, @NotNull IntList columnIndexes, @NotNull LongList prefixes) {
        super(metadata, dataFrameCursorFactory, configuration);
        this.prefixes = new DirectLongList(Math.max(2, prefixes.size()), 19);
        for (int i = 0; i < prefixes.size(); ++i) {
            this.prefixes.add(prefixes.get(i));
        }
        this.cursor = new LatestByAllIndexedRecordCursor(columnIndex, this.rows, columnIndexes, this.prefixes);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestByAllIndexed");
        sink.child(this.cursor);
        sink.child(this.dataFrameCursorFactory);
    }

    @Override
    protected void _close() {
        super._close();
        this.prefixes.close();
    }
}

