/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.cutlass.text.AtomicBooleanCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.geohash.GeoHashNative;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.LatestByArguments;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Os;
import io.questdb.std.Rows;
import io.questdb.std.Vect;
import io.questdb.tasks.LatestByTask;
import org.jetbrains.annotations.NotNull;

class LatestByAllIndexedRecordCursor
extends AbstractDataFrameRecordCursor {
    protected final long indexShift = 0L;
    protected final DirectLongList prefixes;
    protected final DirectLongList rows;
    private final int columnIndex;
    private final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final AtomicBooleanCircuitBreaker sharedCircuitBreaker = new AtomicBooleanCircuitBreaker();
    protected long aIndex;
    protected long aLimit;
    protected SqlExecutionCircuitBreaker circuitBreaker;
    private long argumentsAddress;
    private MessageBus bus;
    private boolean isTreeMapBuilt;
    private int keyCount;
    private int workerCount;

    public LatestByAllIndexedRecordCursor(int columnIndex, @NotNull DirectLongList rows, @NotNull IntList columnIndexes, @NotNull DirectLongList prefixes) {
        super(columnIndexes);
        this.rows = rows;
        this.columnIndex = columnIndex;
        this.prefixes = prefixes;
    }

    @Override
    public boolean hasNext() {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.isTreeMapBuilt = true;
        }
        if (this.aIndex < this.aLimit) {
            long row = this.rows.get(this.aIndex++) - 1L;
            this.recordA.jumpTo(Rows.toPartitionIndex(row), Rows.toLocalRowID(row));
            return true;
        }
        return false;
    }

    @Override
    public void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.bus = executionContext.getMessageBus();
        this.workerCount = executionContext.getSharedWorkerCount();
        this.rows.clear();
        this.keyCount = -1;
        this.argumentsAddress = 0L;
        this.isTreeMapBuilt = false;
    }

    @Override
    public long size() {
        return this.isTreeMapBuilt ? this.aLimit - 0L : -1L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index backward scan").meta("on").putColumnName(this.columnIndex);
        sink.meta("parallel").val(true);
        if (this.prefixes.size() > 2L) {
            int hashColumnIndex = (int)this.prefixes.get(0L);
            int hashColumnType = (int)this.prefixes.get(1L);
            int geoHashBits = ColumnType.getGeoHashBits(hashColumnType);
            if (hashColumnIndex > -1 && ColumnType.isGeoHash(hashColumnType)) {
                sink.attr("filter").putColumnName(hashColumnIndex).val(" within(");
                long n = this.prefixes.size();
                for (long i = 2L; i < n; i += 2L) {
                    if (i > 2L) {
                        sink.val(',');
                    }
                    sink.val(this.prefixes.get(i), geoHashBits);
                }
                sink.val(')');
            }
        }
    }

    @Override
    public void toTop() {
        this.aIndex = 0L;
    }

    private static long getChunkSize(int keyCount, int workerCount) {
        return (keyCount + workerCount - 1) / workerCount;
    }

    private static int getPow2SizeOfGeoHashType(int type) {
        return 1 << ColumnType.pow2SizeOfBits(ColumnType.getGeoHashBits(type));
    }

    private static int getTaskCount(int keyCount, long chunkSize) {
        return (int)(((long)keyCount + chunkSize - 1L) / chunkSize);
    }

    private void buildTreeMap() {
        int taskCount;
        long chunkSize;
        if (this.keyCount < 0) {
            this.keyCount = this.getSymbolTable(this.columnIndex).getSymbolCount() + 1;
            chunkSize = LatestByAllIndexedRecordCursor.getChunkSize(this.keyCount, this.workerCount);
            taskCount = LatestByAllIndexedRecordCursor.getTaskCount(this.keyCount, chunkSize);
            this.rows.setCapacity(this.keyCount);
            GeoHashNative.iota(this.rows.getAddress(), this.rows.getCapacity(), 0L);
            this.argumentsAddress = LatestByArguments.allocateMemoryArray(taskCount);
            for (long i = 0L; i < (long)taskCount; ++i) {
                long klo = i * chunkSize;
                long khi = Long.min(klo + chunkSize, this.keyCount);
                long argsAddress = this.argumentsAddress + i * 56L;
                LatestByArguments.setRowsAddress(argsAddress, this.rows.getAddress());
                LatestByArguments.setRowsCapacity(argsAddress, this.rows.getCapacity());
                LatestByArguments.setKeyLo(argsAddress, klo);
                LatestByArguments.setKeyHi(argsAddress, khi);
                LatestByArguments.setRowsSize(argsAddress, 0L);
            }
            this.sharedCircuitBreaker.reset();
        } else {
            chunkSize = LatestByAllIndexedRecordCursor.getChunkSize(this.keyCount, this.workerCount);
            taskCount = LatestByAllIndexedRecordCursor.getTaskCount(this.keyCount, chunkSize);
        }
        int hashColumnIndex = -1;
        int hashColumnType = 0;
        long prefixesAddress = 0L;
        long prefixesCount = 0L;
        if (this.prefixes.size() > 2L) {
            hashColumnIndex = (int)this.prefixes.get(0L);
            hashColumnType = (int)this.prefixes.get(1L);
            prefixesAddress = this.prefixes.getAddress() + 16L;
            prefixesCount = this.prefixes.size() - 2L;
        }
        int frameColumnIndex = this.columnIndexes.getQuick(this.columnIndex);
        RingQueue<LatestByTask> queue = this.bus.getLatestByQueue();
        Sequence pubSeq = this.bus.getLatestByPubSeq();
        Sequence subSeq = this.bus.getLatestBySubSeq();
        TableReader reader = this.dataFrameCursor.getTableReader();
        long foundRowCount = 0L;
        int queuedCount = 0;
        try {
            DataFrame frame;
            while ((frame = this.dataFrameCursor.next()) != null && foundRowCount < (long)this.keyCount) {
                this.doneLatch.reset();
                BitmapIndexReader indexReader = frame.getBitmapIndexReader(frameColumnIndex, 2);
                long rowLo = frame.getRowLo();
                long rowHi = frame.getRowHi() - 1L;
                long keyBaseAddress = indexReader.getKeyBaseAddress();
                long keysMemorySize = indexReader.getKeyMemorySize();
                long valueBaseAddress = indexReader.getValueBaseAddress();
                long valuesMemorySize = indexReader.getValueMemorySize();
                int valueBlockCapacity = indexReader.getValueBlockCapacity();
                long unIndexedNullCount = indexReader.getUnIndexedNullCount();
                int partitionIndex = frame.getPartitionIndex();
                long hashColumnAddress = 0L;
                if (hashColumnIndex > -1) {
                    int columnBase = reader.getColumnBase(partitionIndex);
                    int primaryColumnIndex = TableReader.getPrimaryColumnIndex(columnBase, hashColumnIndex);
                    MemoryR column = reader.getColumn(primaryColumnIndex);
                    hashColumnAddress = column.getPageAddress(0);
                }
                int hashesColumnSize = ColumnType.isGeoHash(hashColumnType) ? LatestByAllIndexedRecordCursor.getPow2SizeOfGeoHashType(hashColumnType) : -1;
                queuedCount = 0;
                for (long i = 0L; i < (long)taskCount; ++i) {
                    long keyLo;
                    long keyHi;
                    long argsAddress = this.argumentsAddress + i * 56L;
                    long found = LatestByArguments.getRowsSize(argsAddress);
                    if (found >= (keyHi = LatestByArguments.getKeyHi(argsAddress)) - (keyLo = LatestByArguments.getKeyLo(argsAddress))) continue;
                    LatestByArguments.setHashesAddress(argsAddress, hashColumnAddress);
                    long seq = pubSeq.next();
                    if (seq < 0L) {
                        this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                        GeoHashNative.latestByAndFilterPrefix(keyBaseAddress, keysMemorySize, valueBaseAddress, valuesMemorySize, argsAddress, unIndexedNullCount, rowHi, rowLo, partitionIndex, valueBlockCapacity, hashColumnAddress, hashesColumnSize, prefixesAddress, prefixesCount);
                        continue;
                    }
                    queue.get(seq).of(keyBaseAddress, keysMemorySize, valueBaseAddress, valuesMemorySize, argsAddress, unIndexedNullCount, rowHi, rowLo, partitionIndex, valueBlockCapacity, hashColumnAddress, hashesColumnSize, prefixesAddress, prefixesCount, this.doneLatch, this.sharedCircuitBreaker);
                    pubSeq.done(seq);
                    ++queuedCount;
                }
                while (!this.doneLatch.done(queuedCount)) {
                    this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                    long seq = subSeq.next();
                    if (seq > -1L) {
                        queue.get(seq).run();
                        subSeq.done(seq);
                        continue;
                    }
                    Os.pause();
                }
                foundRowCount = 0L;
                for (int i = 0; i < taskCount; ++i) {
                    long address = this.argumentsAddress + (long)i * 56L;
                    foundRowCount += LatestByArguments.getRowsSize(address);
                }
            }
        }
        catch (DataUnavailableException e) {
            throw e;
        }
        catch (Throwable t) {
            this.sharedCircuitBreaker.cancel();
            throw t;
        }
        finally {
            this.processTasks(queuedCount);
            if (this.sharedCircuitBreaker.isCanceled()) {
                LatestByArguments.releaseMemoryArray(this.argumentsAddress, taskCount);
                this.argumentsAddress = 0L;
            }
        }
        long rowCount = 0L;
        if (this.argumentsAddress > 0L) {
            rowCount = GeoHashNative.slideFoundBlocks(this.argumentsAddress, taskCount);
            LatestByArguments.releaseMemoryArray(this.argumentsAddress, taskCount);
            this.argumentsAddress = 0L;
        }
        this.aLimit = rowCount;
        this.aIndex = 0L;
        this.postProcessRows();
    }

    private void postProcessRows() {
        Vect.sortULongAscInPlace(this.rows.getAddress(), this.aLimit);
    }

    private void processTasks(int queuedCount) {
        RingQueue<LatestByTask> queue = this.bus.getLatestByQueue();
        Sequence subSeq = this.bus.getLatestBySubSeq();
        while (!this.doneLatch.done(queuedCount)) {
            long seq = subSeq.next();
            if (seq > -1L) {
                if (this.circuitBreaker.checkIfTripped()) {
                    this.sharedCircuitBreaker.cancel();
                }
                queue.get(seq).run();
                subSeq.done(seq);
                continue;
            }
            Os.pause();
        }
    }
}

