/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.NoMoreFramesException;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DataFrameRecordCursorImpl
extends AbstractDataFrameRecordCursor {
    private final boolean entityCursor;
    private final Function filter;
    private final RowCursorFactory rowCursorFactory;
    private boolean areCursorsPrepared;
    private RowCursor rowCursor;

    public DataFrameRecordCursorImpl(RowCursorFactory rowCursorFactory, boolean entityCursor, @Nullable Function filter, @NotNull IntList columnIndexes) {
        super(columnIndexes);
        this.rowCursorFactory = rowCursorFactory;
        this.entityCursor = entityCursor;
        this.filter = filter;
    }

    public RowCursorFactory getRowCursorFactory() {
        return this.rowCursorFactory;
    }

    @Override
    public boolean hasNext() {
        if (!this.areCursorsPrepared) {
            this.rowCursorFactory.prepareCursor(this.dataFrameCursor.getTableReader());
            this.areCursorsPrepared = true;
        }
        try {
            DataFrame dataFrame;
            if (this.rowCursor != null && this.rowCursor.hasNext()) {
                this.recordA.setRecordIndex(this.rowCursor.next());
                return true;
            }
            while ((dataFrame = this.dataFrameCursor.next()) != null) {
                this.rowCursor = this.rowCursorFactory.getCursor(dataFrame);
                if (!this.rowCursor.hasNext()) continue;
                this.recordA.jumpTo(dataFrame.getPartitionIndex(), this.rowCursor.next());
                return true;
            }
        }
        catch (NoMoreFramesException ignore) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return this.rowCursorFactory.isUsingIndex();
    }

    @Override
    public void of(DataFrameCursor dataFrameCursor, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (this.dataFrameCursor != dataFrameCursor) {
            this.close();
            this.dataFrameCursor = dataFrameCursor;
        }
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.rowCursorFactory.init(dataFrameCursor.getTableReader(), sqlExecutionContext);
        this.rowCursor = null;
        this.areCursorsPrepared = false;
    }

    @Override
    public long size() {
        return this.entityCursor ? this.dataFrameCursor.size() : -1L;
    }

    @Override
    public boolean skipTo(long rowCount) {
        if (!this.dataFrameCursor.supportsRandomAccess() || this.filter != null || this.rowCursorFactory.isUsingIndex()) {
            return false;
        }
        DataFrame dataFrame = this.dataFrameCursor.skipTo(rowCount);
        if (dataFrame != null) {
            this.rowCursor = this.rowCursorFactory.getCursor(dataFrame);
            this.recordA.jumpTo(dataFrame.getPartitionIndex(), dataFrame.getRowLo());
            return true;
        }
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Data frame scan");
    }

    @Override
    public void toTop() {
        if (this.filter != null) {
            this.filter.toTop();
        }
        this.dataFrameCursor.toTop();
        this.rowCursor = null;
    }
}

