/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageAddressCache;
import io.questdb.cairo.sql.PageAddressCacheRecord;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameReducer;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.bind.CompiledFilterSymbolBindVariable;
import io.questdb.griffin.engine.table.AsyncFilterAtom;
import io.questdb.griffin.engine.table.AsyncFilteredNegativeLimitRecordCursor;
import io.questdb.griffin.engine.table.AsyncFilteredRecordCursor;
import io.questdb.griffin.engine.table.FilteredRecordCursorFactory;
import io.questdb.jit.CompiledFilter;
import io.questdb.mp.SCSequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.WeakClosableObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncJitFilteredRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final PageFrameReducer REDUCER = AsyncJitFilteredRecordCursorFactory::filter;
    private final RecordCursorFactory base;
    private final SCSequence collectSubSeq = new SCSequence();
    private final AsyncFilteredRecordCursor cursor;
    private final AsyncJitFilterAtom filterAtom;
    private final PageFrameSequence<AsyncJitFilterAtom> frameSequence;
    private final Function limitLoFunction;
    private final int limitLoPos;
    private final int maxNegativeLimit;
    private final AsyncFilteredNegativeLimitRecordCursor negativeLimitCursor;
    private final int workerCount;
    private DirectLongList negativeLimitRows;

    public AsyncJitFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull MessageBus messageBus, @NotNull RecordCursorFactory base, @NotNull ObjList<Function> bindVarFunctions, @NotNull Function filter, @Nullable ObjList<Function> perWorkerFilters, @NotNull CompiledFilter compiledFilter, @NotNull WeakClosableObjectPool<PageFrameReduceTask> localTaskPool, @Nullable Function limitLoFunction, int limitLoPos, boolean preTouchColumns, int workerCount) {
        super(base.getMetadata());
        assert (!(base instanceof FilteredRecordCursorFactory));
        assert (!(base instanceof AsyncJitFilteredRecordCursorFactory));
        this.base = base;
        this.cursor = new AsyncFilteredRecordCursor(filter, base.getScanDirection());
        this.negativeLimitCursor = new AsyncFilteredNegativeLimitRecordCursor(base.getScanDirection());
        MemoryCARW bindVarMemory = Vm.getCARWInstance(configuration.getSqlJitBindVarsMemoryPageSize(), configuration.getSqlJitBindVarsMemoryMaxPages(), 22);
        IntList preTouchColumnTypes = null;
        if (preTouchColumns) {
            preTouchColumnTypes = new IntList();
            int n = base.getMetadata().getColumnCount();
            for (int i = 0; i < n; ++i) {
                int columnType = base.getMetadata().getColumnType(i);
                preTouchColumnTypes.add(columnType);
            }
        }
        this.filterAtom = new AsyncJitFilterAtom(configuration, filter, perWorkerFilters, compiledFilter, bindVarMemory, bindVarFunctions, preTouchColumnTypes);
        this.frameSequence = new PageFrameSequence(configuration, messageBus, REDUCER, localTaskPool);
        this.limitLoFunction = limitLoFunction;
        this.limitLoPos = limitLoPos;
        this.maxNegativeLimit = configuration.getSqlMaxNegativeLimit();
        this.workerCount = workerCount;
    }

    public PageFrameSequence<AsyncJitFilterAtom> execute(SqlExecutionContext executionContext, SCSequence collectSubSeq, int order) throws SqlException {
        return this.frameSequence.of(this.base, executionContext, collectSubSeq, this.filterAtom, order);
    }

    @Override
    public boolean followedLimitAdvice() {
        return this.limitLoFunction != null;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int order;
        long rowsRemaining;
        int baseOrder;
        int n = baseOrder = this.base.getScanDirection() == 2 ? 1 : 0;
        if (this.limitLoFunction != null) {
            this.limitLoFunction.init(this.frameSequence.getSymbolTableSource(), executionContext);
            rowsRemaining = this.limitLoFunction.getLong(null);
            if (rowsRemaining > -1L) {
                order = baseOrder;
            } else {
                order = DataFrameCursorFactory.reverse(baseOrder);
                rowsRemaining = -rowsRemaining;
            }
        } else {
            rowsRemaining = Long.MAX_VALUE;
            order = baseOrder;
        }
        if (order != baseOrder && rowsRemaining != Long.MAX_VALUE) {
            if (rowsRemaining > (long)this.maxNegativeLimit) {
                throw SqlException.position(this.limitLoPos).put("absolute LIMIT value is too large, maximum allowed value: ").put(this.maxNegativeLimit);
            }
            if (this.negativeLimitRows == null) {
                this.negativeLimitRows = new DirectLongList(this.maxNegativeLimit, 23);
            }
            this.negativeLimitCursor.of(this.execute(executionContext, this.collectSubSeq, order), rowsRemaining, this.negativeLimitRows);
            return this.negativeLimitCursor;
        }
        this.cursor.of(this.execute(executionContext, this.collectSubSeq, order), rowsRemaining);
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.base.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        int order;
        long rowsRemaining;
        int baseOrder;
        sink.type("Async JIT Filter");
        int n = baseOrder = this.base.getScanDirection() == 2 ? 1 : 0;
        if (this.limitLoFunction != null) {
            try {
                this.limitLoFunction.init(this.frameSequence.getSymbolTableSource(), sink.getExecutionContext());
                rowsRemaining = this.limitLoFunction.getLong(null);
            }
            catch (Exception e) {
                rowsRemaining = Long.MAX_VALUE;
            }
            if (rowsRemaining > -1L) {
                order = baseOrder;
            } else {
                order = DataFrameCursorFactory.reverse(baseOrder);
                rowsRemaining = -rowsRemaining;
            }
        } else {
            rowsRemaining = Long.MAX_VALUE;
            order = baseOrder;
        }
        if (rowsRemaining != Long.MAX_VALUE) {
            sink.attr("limit").val(rowsRemaining);
        }
        sink.attr("filter").val(this.filterAtom);
        sink.attr("workers").val(this.workerCount);
        sink.child(this.base, order);
    }

    @Override
    public boolean usesCompiledFilter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filter(int workerId, @NotNull PageAddressCacheRecord record, @NotNull PageFrameReduceTask task, @NotNull SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        DirectLongList rows = task.getRows();
        DirectLongList columns = task.getColumns();
        long frameRowCount = task.getFrameRowCount();
        AsyncJitFilterAtom atom = task.getFrameSequence(AsyncJitFilterAtom.class).getAtom();
        PageAddressCache pageAddressCache = task.getPageAddressCache();
        rows.clear();
        if (pageAddressCache.hasColumnTops(task.getFrameIndex())) {
            boolean owner = stealingFrameSequence != null && stealingFrameSequence == task.getFrameSequence();
            int filterId = atom.acquireFilter(workerId, owner, circuitBreaker);
            Function filter = atom.getFilter(filterId);
            try {
                for (long r = 0L; r < frameRowCount; ++r) {
                    record.setRowIndex(r);
                    if (!filter.getBool(record)) continue;
                    rows.add(r);
                }
                return;
            }
            finally {
                atom.releaseFilter(filterId);
            }
        }
        long columnCount = pageAddressCache.getColumnCount();
        if (columns.getCapacity() < columnCount) {
            columns.setCapacity(columnCount);
        }
        columns.clear();
        int columnIndex = 0;
        while ((long)columnIndex < columnCount) {
            columns.add(pageAddressCache.getPageAddress(task.getFrameIndex(), columnIndex));
            ++columnIndex;
        }
        long rowCount = task.getFrameRowCount();
        if (rows.getCapacity() < rowCount) {
            rows.setCapacity(rowCount);
        }
        long hi = atom.compiledFilter.call(columns.getAddress(), columns.size(), atom.bindVarMemory.getAddress(), atom.bindVarFunctions.size(), rows.getAddress(), rowCount, 0L);
        rows.setPos(hi);
        atom.preTouchColumns(record, rows);
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.filterAtom);
        Misc.free(this.frameSequence);
        Misc.free(this.negativeLimitRows);
        this.cursor.freeRecords();
        this.negativeLimitCursor.freeRecords();
    }

    private static class AsyncJitFilterAtom
    extends AsyncFilterAtom {
        final ObjList<Function> bindVarFunctions;
        final MemoryCARW bindVarMemory;
        final CompiledFilter compiledFilter;

        public AsyncJitFilterAtom(CairoConfiguration configuration, Function filter, ObjList<Function> perWorkerFilters, CompiledFilter compiledFilter, MemoryCARW bindVarMemory, ObjList<Function> bindVarFunctions, @Nullable IntList preTouchColumnTypes) {
            super(configuration, filter, perWorkerFilters, preTouchColumnTypes);
            this.compiledFilter = compiledFilter;
            this.bindVarMemory = bindVarMemory;
            this.bindVarFunctions = bindVarFunctions;
        }

        @Override
        public void close() {
            super.close();
            Misc.free(this.compiledFilter);
            Misc.free(this.bindVarMemory);
            Misc.freeObjList(this.bindVarFunctions);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            Function.init(this.bindVarFunctions, symbolTableSource, executionContext);
            this.prepareBindVarMemory(symbolTableSource, executionContext);
        }

        private void prepareBindVarMemory(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            if (this.bindVarFunctions.size() > 0) {
                this.bindVarMemory.truncate();
                int n = this.bindVarFunctions.size();
                for (int i = 0; i < n; ++i) {
                    Function function = this.bindVarFunctions.getQuick(i);
                    this.writeBindVarFunction(function, symbolTableSource, executionContext);
                }
            }
        }

        private void writeBindVarFunction(Function function, SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            int columnType = function.getType();
            short columnTypeTag = ColumnType.tagOf(columnType);
            switch (columnTypeTag) {
                case 1: {
                    this.bindVarMemory.putLong(function.getBool(null) ? 1L : 0L);
                    return;
                }
                case 2: {
                    this.bindVarMemory.putLong(function.getByte(null));
                    return;
                }
                case 14: {
                    this.bindVarMemory.putLong(function.getGeoByte(null));
                    return;
                }
                case 3: {
                    this.bindVarMemory.putLong(function.getShort(null));
                    return;
                }
                case 15: {
                    this.bindVarMemory.putLong(function.getGeoShort(null));
                    return;
                }
                case 4: {
                    this.bindVarMemory.putLong(function.getChar(null));
                    return;
                }
                case 5: {
                    this.bindVarMemory.putLong(function.getInt(null));
                    return;
                }
                case 16: {
                    this.bindVarMemory.putLong(function.getGeoInt(null));
                    return;
                }
                case 12: {
                    assert (function instanceof CompiledFilterSymbolBindVariable);
                    function.init(symbolTableSource, executionContext);
                    this.bindVarMemory.putLong(function.getInt(null));
                    return;
                }
                case 9: {
                    this.bindVarMemory.putFloat(function.getFloat(null));
                    this.bindVarMemory.putFloat(Float.NaN);
                    return;
                }
                case 6: {
                    this.bindVarMemory.putLong(function.getLong(null));
                    return;
                }
                case 17: {
                    this.bindVarMemory.putLong(function.getGeoLong(null));
                    return;
                }
                case 7: {
                    this.bindVarMemory.putLong(function.getDate(null));
                    return;
                }
                case 8: {
                    this.bindVarMemory.putLong(function.getTimestamp(null));
                    return;
                }
                case 10: {
                    this.bindVarMemory.putDouble(function.getDouble(null));
                    return;
                }
            }
            throw SqlException.position(0).put("unsupported bind variable type: ").put(ColumnType.nameOf(columnTypeTag));
        }
    }
}

