/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

abstract class AbstractDescendingRecordListCursor
extends AbstractDataFrameRecordCursor {
    protected final DirectLongList rows;
    protected SqlExecutionCircuitBreaker circuitBreaker;
    protected boolean isOpen;
    private long index;
    private boolean isTreeMapBuilt;

    public AbstractDescendingRecordListCursor(DirectLongList rows, @NotNull IntList columnIndexes) {
        super(columnIndexes);
        this.rows = rows;
        this.isOpen = true;
    }

    @Override
    public void close() {
        this.isOpen = false;
        super.close();
    }

    @Override
    public boolean hasNext() {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.index = this.rows.size() - 1L;
            this.isTreeMapBuilt = true;
        }
        if (this.index > -1L) {
            long row = this.rows.get(this.index--);
            this.recordA.jumpTo(Rows.toPartitionIndex(row), Rows.toLocalRowID(row));
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.rows.clear();
        this.isTreeMapBuilt = false;
        this.isOpen = true;
    }

    @Override
    public long size() {
        return this.rows.size();
    }

    @Override
    public void toTop() {
        this.index = this.rows.size() - 1L;
    }

    protected abstract void buildTreeMap();
}

