/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableReaderSelectedColumnRecord;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataFrameRecordCursor
implements DataFrameRecordCursor {
    protected final IntList columnIndexes;
    protected final TableReaderSelectedColumnRecord recordA;
    protected final TableReaderSelectedColumnRecord recordB;
    protected DataFrameCursor dataFrameCursor;

    public AbstractDataFrameRecordCursor(@NotNull IntList columnIndexes) {
        this.columnIndexes = columnIndexes;
        this.recordA = new TableReaderSelectedColumnRecord(columnIndexes);
        this.recordB = new TableReaderSelectedColumnRecord(columnIndexes);
    }

    @Override
    public void close() {
        this.dataFrameCursor = Misc.free(this.dataFrameCursor);
    }

    @Override
    public IntList getColumnIndexes() {
        return this.columnIndexes;
    }

    @Override
    public DataFrameCursor getDataFrameCursor() {
        return this.dataFrameCursor;
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return this.dataFrameCursor.getSymbolTable(this.columnIndexes.getQuick(columnIndex));
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.dataFrameCursor.newSymbolTable(this.columnIndexes.getQuick(columnIndex));
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((TableReaderSelectedColumnRecord)record).jumpTo(Rows.toPartitionIndex(atRowId), Rows.toLocalRowID(atRowId));
    }
}

