/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.std.Misc;

class SortedLightRecordCursor
implements DelegatingRecordCursor {
    private final LongTreeChain chain;
    private final LongTreeChain.TreeCursor chainCursor;
    private final RecordComparator comparator;
    private RecordCursor base;
    private Record baseRecord;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private boolean isChainBuilt;
    private boolean isOpen;

    public SortedLightRecordCursor(LongTreeChain chain, RecordComparator comparator) {
        this.chain = chain;
        this.comparator = comparator;
        this.chainCursor = chain.getCursor();
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            Misc.free(this.chain);
            this.base = Misc.free(this.base);
            this.baseRecord = null;
        }
    }

    @Override
    public Record getRecord() {
        return this.baseRecord;
    }

    @Override
    public Record getRecordB() {
        return this.base.getRecordB();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.base.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (!this.isChainBuilt) {
            this.buildChain();
            this.isChainBuilt = true;
        }
        if (this.chainCursor.hasNext()) {
            this.base.recordAt(this.baseRecord, this.chainCursor.next());
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.base.newSymbolTable(columnIndex);
    }

    @Override
    public void of(RecordCursor base, SqlExecutionContext executionContext) {
        if (!this.isOpen) {
            this.chain.reopen();
            this.isOpen = true;
        }
        this.base = base;
        this.baseRecord = base.getRecord();
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.isChainBuilt = false;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.base.recordAt(record, atRowId);
    }

    @Override
    public long size() {
        return this.base.size();
    }

    @Override
    public void toTop() {
        this.chainCursor.toTop();
    }

    private void buildChain() {
        Record placeHolderRecord = this.base.getRecordB();
        while (this.base.hasNext()) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            this.chain.put(this.baseRecord, this.base, placeHolderRecord, this.comparator);
        }
        this.toTop();
    }
}

