/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LimitedSizeLongTreeChain;
import io.questdb.std.Misc;

public class LimitedSizeSortedLightRecordCursor
implements DelegatingRecordCursor {
    private final LimitedSizeLongTreeChain chain;
    private final LimitedSizeLongTreeChain.TreeCursor chainCursor;
    private final RecordComparator comparator;
    private final long limit;
    private final long skipFirst;
    private final long skipLast;
    private RecordCursor base;
    private Record baseRecord;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private boolean isChainBuilt;
    private boolean isOpen;
    private long rowsLeft;

    public LimitedSizeSortedLightRecordCursor(LimitedSizeLongTreeChain chain, RecordComparator comparator, long limit, long skipFirst, long skipLast) {
        this.chain = chain;
        this.comparator = comparator;
        this.chainCursor = chain.getCursor();
        this.limit = limit;
        this.skipFirst = skipFirst;
        this.skipLast = skipLast;
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            Misc.free(this.chain);
            Misc.free(this.base);
            this.isOpen = false;
        }
    }

    @Override
    public Record getRecord() {
        return this.baseRecord;
    }

    @Override
    public Record getRecordB() {
        return this.base.getRecordB();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.base.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (!this.isChainBuilt) {
            this.buildChain();
            this.isChainBuilt = true;
        }
        if (this.rowsLeft-- > 0L && this.chainCursor.hasNext()) {
            this.base.recordAt(this.baseRecord, this.chainCursor.next());
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.base.newSymbolTable(columnIndex);
    }

    @Override
    public void of(RecordCursor base, SqlExecutionContext executionContext) {
        if (!this.isOpen) {
            this.chain.reopen();
            this.isOpen = true;
        }
        this.base = base;
        this.baseRecord = base.getRecord();
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.isChainBuilt = false;
        this.chain.clear();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.base.recordAt(record, atRowId);
    }

    @Override
    public long size() {
        return this.isChainBuilt ? Math.max(this.chain.size() - this.skipFirst - this.skipLast, 0L) : -1L;
    }

    @Override
    public void toTop() {
        this.chainCursor.toTop();
        long skipLeft = this.skipFirst;
        while (skipLeft-- > 0L && this.chainCursor.hasNext()) {
            this.chainCursor.next();
        }
        this.rowsLeft = Math.max(this.chain.size() - this.skipFirst - this.skipLast, 0L);
    }

    private void buildChain() {
        Record placeHolderRecord = this.base.getRecordB();
        if (this.limit != 0L) {
            while (this.base.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                this.chain.put(this.baseRecord, this.base, placeHolderRecord, this.comparator);
            }
        }
        this.toTop();
    }
}

