/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.griffin.engine.ops.OperationFutureImpl;
import io.questdb.mp.SCSequence;
import io.questdb.std.WeakSelfReturningObjectPool;
import org.jetbrains.annotations.Nullable;

public abstract class OperationDispatcher<T extends AbstractOperation> {
    private final DoneOperationFuture doneFuture = new DoneOperationFuture();
    private final CairoEngine engine;
    private final WeakSelfReturningObjectPool<OperationFutureImpl> futurePool;
    private final String lockReason;

    public OperationDispatcher(CairoEngine engine, String lockReason) {
        this.engine = engine;
        this.futurePool = new WeakSelfReturningObjectPool<OperationFutureImpl>(pool -> new OperationFutureImpl(engine, pool), 2);
        this.lockReason = lockReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationFuture execute(T operation, SqlExecutionContext sqlExecutionContext, @Nullable SCSequence eventSubSeq, boolean closeOnDone) {
        ((AbstractOperation)operation).withContext(sqlExecutionContext);
        boolean isDone = false;
        TableToken tableToken = ((AbstractOperation)operation).getTableToken();
        assert (tableToken != null);
        try {
            TableWriterAPI writer = this.engine.getTableWriterAPI(tableToken, this.lockReason);
            try {
                long result = this.apply(operation, writer);
                isDone = true;
                OperationFuture operationFuture = this.doneFuture.of(result);
                if (writer != null) {
                    writer.close();
                }
                return operationFuture;
            }
            catch (Throwable result) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            result.addSuppressed(throwable);
                        }
                    }
                    throw result;
                }
                catch (EntryUnavailableException busyException) {
                    if (eventSubSeq == null) {
                        throw busyException;
                    }
                    OperationFutureImpl future = (OperationFutureImpl)this.futurePool.pop();
                    future.of((AsyncWriterCommand)operation, sqlExecutionContext, eventSubSeq, ((AbstractOperation)operation).getTableNamePosition(), closeOnDone);
                    OperationFutureImpl operationFutureImpl = future;
                    return operationFutureImpl;
                }
            }
        }
        finally {
            if (closeOnDone && isDone) {
                ((AbstractOperation)operation).close();
            }
        }
    }

    protected abstract long apply(T var1, TableWriterAPI var2);
}

