/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.sql.InsertMethod;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.WriterOutOfDateException;
import io.questdb.griffin.InsertRowImpl;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class InsertOperationImpl
implements InsertOperation {
    private final InsertOperationFuture doneFuture = new InsertOperationFuture();
    private final CairoEngine engine;
    private final InsertMethodImpl insertMethod = new InsertMethodImpl();
    private final ObjList<InsertRowImpl> insertRows = new ObjList();
    private final long metadataVersion;
    private final TableToken tableToken;

    public InsertOperationImpl(CairoEngine engine, TableToken tableToken, long metadataVersion) {
        this.engine = engine;
        this.tableToken = tableToken;
        this.metadataVersion = metadataVersion;
    }

    @Override
    public void addInsertRow(InsertRowImpl row) {
        this.insertRows.add(row);
    }

    @Override
    public InsertMethod createMethod(SqlExecutionContext executionContext, WriterSource writerSource) throws SqlException {
        this.initContext(executionContext);
        if (this.insertMethod.writer == null) {
            TableWriterAPI writer = writerSource.getTableWriterAPI(this.tableToken, "insert");
            if (writer.getMetadataVersion() != this.metadataVersion || !Chars.equals(this.tableToken.getTableName(), writer.getTableToken().getTableName())) {
                writer.close();
                throw WriterOutOfDateException.INSTANCE;
            }
            this.insertMethod.writer = writer;
        }
        return this.insertMethod;
    }

    @Override
    public InsertMethod createMethod(SqlExecutionContext executionContext) throws SqlException {
        return this.createMethod(executionContext, this.engine);
    }

    @Override
    public OperationFuture execute(SqlExecutionContext sqlExecutionContext) throws SqlException {
        try (InsertMethod insertMethod = this.createMethod(sqlExecutionContext);){
            insertMethod.execute();
            insertMethod.commit();
            InsertOperationFuture insertOperationFuture = this.doneFuture;
            return insertOperationFuture;
        }
    }

    private void initContext(SqlExecutionContext executionContext) throws SqlException {
        int n = this.insertRows.size();
        for (int i = 0; i < n; ++i) {
            InsertRowImpl row = this.insertRows.get(i);
            row.initContext(executionContext);
        }
    }

    private class InsertOperationFuture
    extends DoneOperationFuture {
        private InsertOperationFuture() {
        }

        @Override
        public long getAffectedRowsCount() {
            return InsertOperationImpl.this.insertRows.size();
        }

        @Override
        public long getInstanceId() {
            return -3L;
        }
    }

    private class InsertMethodImpl
    implements InsertMethod {
        private TableWriterAPI writer = null;

        private InsertMethodImpl() {
        }

        @Override
        public void close() {
            this.writer = Misc.free(this.writer);
        }

        @Override
        public void commit() {
            this.writer.commit();
        }

        @Override
        public long execute() {
            int n = InsertOperationImpl.this.insertRows.size();
            for (int i = 0; i < n; ++i) {
                InsertRowImpl row = InsertOperationImpl.this.insertRows.get(i);
                row.append(this.writer);
            }
            return InsertOperationImpl.this.insertRows.size();
        }

        @Override
        public TableWriterAPI popWriter() {
            TableWriterAPI w = this.writer;
            this.writer = null;
            return w;
        }
    }
}

