/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.TableToken;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.std.LongList;
import io.questdb.std.ObjList;

public class AlterOperationBuilder {
    private final LongList extraInfo = new LongList();
    private final ObjList<CharSequence> extraStrInfo = new ObjList();
    private final AlterOperation op = new AlterOperation(this.extraInfo, this.extraStrInfo);
    private short command;
    private int tableId = -1;
    private int tableNamePosition = -1;
    private TableToken tableToken;

    public void addColumnToList(CharSequence columnName, int columnNamePosition, int type, int symbolCapacity, boolean cache, boolean indexed, int indexValueBlockCapacity) {
        assert (columnName != null && columnName.length() > 0);
        this.extraStrInfo.add(columnName);
        this.extraInfo.add(type);
        this.extraInfo.add(symbolCapacity);
        this.extraInfo.add(cache ? 1L : -1L);
        this.extraInfo.add(indexed ? 1L : -1L);
        this.extraInfo.add(indexValueBlockCapacity);
        this.extraInfo.add(columnNamePosition);
    }

    public void addPartitionToList(long timestamp, int timestampPosition) {
        this.extraInfo.add(timestamp);
        this.extraInfo.add(timestampPosition);
    }

    public AlterOperation build() {
        return this.op.of(this.command, this.tableToken, this.tableId, this.tableNamePosition);
    }

    public void clear() {
        this.op.clear();
        this.extraStrInfo.clear();
        this.extraInfo.clear();
        this.command = 0;
        this.tableToken = null;
        this.tableId = -1;
        this.tableNamePosition = -1;
    }

    public AlterOperationBuilder ofAddColumn(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = 1;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public void ofAddColumn(CharSequence columnName, int columnNamePosition, int type, int symbolCapacity, boolean cache, boolean indexed, int indexValueBlockCapacity) {
        assert (columnName != null && columnName.length() > 0);
        this.extraStrInfo.add(columnName);
        this.extraInfo.add(type);
        this.extraInfo.add(symbolCapacity);
        this.extraInfo.add(cache ? 1L : -1L);
        this.extraInfo.add(indexed ? 1L : -1L);
        this.extraInfo.add(indexValueBlockCapacity);
        this.extraInfo.add(columnNamePosition);
    }

    public AlterOperationBuilder ofAddIndex(int tableNamePosition, TableToken tableToken, int tableId, CharSequence columnName, int indexValueBlockSize) {
        this.command = (short)4;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.extraStrInfo.add(columnName);
        this.extraInfo.add(indexValueBlockSize);
        return this;
    }

    public AlterOperationBuilder ofAttachPartition(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)3;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofCacheSymbol(int tableNamePosition, TableToken tableToken, int tableId, CharSequence columnName) {
        this.command = (short)6;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.extraStrInfo.add(columnName);
        return this;
    }

    public AlterOperationBuilder ofDetachPartition(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)12;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofDropColumn(CharSequence columnName) {
        assert (columnName != null && columnName.length() > 0);
        this.extraStrInfo.add(columnName);
        return this;
    }

    public AlterOperationBuilder ofDropColumn(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)8;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofDropIndex(int tableNamePosition, TableToken tableToken, int tableId, CharSequence columnName, int columnNamePosition) {
        this.command = (short)5;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.extraStrInfo.add(columnName);
        this.extraInfo.add(columnNamePosition);
        return this;
    }

    public AlterOperationBuilder ofDropPartition(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)2;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofRemoveCacheSymbol(int tableNamePosition, TableToken tableToken, int tableId, CharSequence columnName) {
        assert (columnName != null && columnName.length() > 0);
        this.command = (short)7;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        this.extraStrInfo.add(columnName);
        return this;
    }

    public AlterOperationBuilder ofRenameColumn(int tableNamePosition, TableToken tableToken, int tableId) {
        this.command = (short)9;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableId;
        return this;
    }

    public void ofRenameColumn(CharSequence columnName, CharSequence newName) {
        this.extraStrInfo.add(columnName);
        this.extraStrInfo.add(newName);
    }

    public AlterOperationBuilder ofSetO3MaxLag(int tableNamePosition, TableToken tableToken, int tableId, long o3MaxLag) {
        this.command = (short)11;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.extraInfo.add(o3MaxLag);
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofSetParamUncommittedRows(int tableNamePosition, TableToken tableToken, int tableId, int maxUncommittedRows) {
        this.command = (short)10;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.extraInfo.add(maxUncommittedRows);
        this.tableId = tableId;
        return this;
    }

    public ObjList<CharSequence> getExtraStrInfo() {
        return this.extraStrInfo;
    }

    public AlterOperationBuilder ofSquashPartitions(int tableNamePosition, TableToken tableToken) {
        this.command = (short)13;
        this.tableNamePosition = tableNamePosition;
        this.tableToken = tableToken;
        this.tableId = tableToken.getTableId();
        return this;
    }
}

