/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.RecordValueSink;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractSymbolWrapOverCursor;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.SymbolWrapOverJoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.IntList;
import io.questdb.std.Misc;

public class LtJoinRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final LtJoinRecordCursor cursor;
    private final JoinContext joinContext;
    private final RecordCursorFactory masterFactory;
    private final RecordSink masterKeySink;
    private final IntList slaveColumnIndex;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink slaveKeySink;

    public LtJoinRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex, JoinContext joinContext, ColumnFilter masterTableKeyColumns) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        Map joinKeyMap = MapFactory.createMap(configuration, mapKeyTypes, mapValueTypes);
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        int slaveWrappedOverMaster = slaveColumnTypes.getColumnCount() - masterTableKeyColumns.getColumnCount();
        this.cursor = new LtJoinRecordCursor(columnSplit, joinKeyMap, NullRecordFactory.getInstance(slaveColumnTypes), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex(), slaveValueSink, masterTableKeyColumns, slaveWrappedOverMaster, columnIndex);
        this.slaveColumnIndex = columnIndex;
        this.joinContext = joinContext;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Lt Join");
        sink.attr("condition").val(this.joinContext);
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
        this.cursor.close();
    }

    private class LtJoinRecordCursor
    extends AbstractSymbolWrapOverCursor {
        private final Map joinKeyMap;
        private final int masterTimestampIndex;
        private final SymbolWrapOverJoinRecord record;
        private final int slaveTimestampIndex;
        private final RecordValueSink valueSink;
        private boolean danglingSlaveRecord;
        private boolean isMasterHasNextPending;
        private boolean isOpen;
        private boolean masterHasNext;
        private Record masterRecord;
        private Record slaveRecord;
        private long slaveTimestamp;

        public LtJoinRecordCursor(int columnSplit, Map joinKeyMap, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex, RecordValueSink valueSink, ColumnFilter masterTableKeyColumns, int slaveWrappedOverMaster, IntList slaveColumnIndex) {
            super(columnSplit, slaveWrappedOverMaster, masterTableKeyColumns, slaveColumnIndex);
            this.danglingSlaveRecord = false;
            this.slaveTimestamp = Long.MIN_VALUE;
            this.record = new SymbolWrapOverJoinRecord(columnSplit, nullRecord, slaveWrappedOverMaster, masterTableKeyColumns);
            this.joinKeyMap = joinKeyMap;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
            this.valueSink = valueSink;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.isMasterHasNextPending) {
                this.masterHasNext = this.masterCursor.hasNext();
                this.isMasterHasNextPending = false;
            }
            if (this.masterHasNext) {
                MapValue value;
                MapKey key;
                long slaveTimestamp = this.slaveTimestamp;
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                if (slaveTimestamp < masterTimestamp) {
                    if (this.danglingSlaveRecord) {
                        key = this.joinKeyMap.withKey();
                        key.put(this.slaveRecord, LtJoinRecordCursorFactory.this.slaveKeySink);
                        value = key.createValue();
                        this.valueSink.copy(this.slaveRecord, value);
                        this.danglingSlaveRecord = false;
                    }
                    while (this.slaveCursor.hasNext()) {
                        slaveTimestamp = this.slaveRecord.getTimestamp(this.slaveTimestampIndex);
                        if (slaveTimestamp < masterTimestamp) {
                            key = this.joinKeyMap.withKey();
                            key.put(this.slaveRecord, LtJoinRecordCursorFactory.this.slaveKeySink);
                            value = key.createValue();
                            this.valueSink.copy(this.slaveRecord, value);
                            continue;
                        }
                        this.danglingSlaveRecord = true;
                        break;
                    }
                    this.slaveTimestamp = slaveTimestamp;
                }
                key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, LtJoinRecordCursorFactory.this.masterKeySink);
                value = key.findValue();
                if (value != null) {
                    value.setMapRecordHere();
                    this.record.hasSlave(true);
                } else {
                    this.record.hasSlave(false);
                }
                this.isMasterHasNextPending = true;
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        @Override
        public void toTop() {
            this.joinKeyMap.clear();
            this.slaveTimestamp = Long.MIN_VALUE;
            this.danglingSlaveRecord = false;
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
            this.isMasterHasNextPending = true;
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
            }
            this.slaveTimestamp = Long.MIN_VALUE;
            this.danglingSlaveRecord = false;
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecord();
            MapRecord mapRecord = this.joinKeyMap.getRecord();
            mapRecord.setSymbolTableResolver(slaveCursor, LtJoinRecordCursorFactory.this.slaveColumnIndex);
            this.record.of(this.masterRecord, mapRecord);
            this.isMasterHasNextPending = true;
        }
    }
}

