/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.Misc;

public class AsOfJoinNoKeyRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final AsOfLightJoinRecordCursor cursor;
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;

    public AsOfJoinNoKeyRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.cursor = new AsOfLightJoinRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex());
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("AsOf Join");
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    private static class AsOfLightJoinRecordCursor
    extends AbstractJoinCursor {
        private final int masterTimestampIndex;
        private final OuterJoinRecord record;
        private final int slaveTimestampIndex;
        private boolean isMasterHasNextPending;
        private long latestSlaveRowID = Long.MIN_VALUE;
        private boolean masterHasNext;
        private Record masterRecord;
        private Record slaveRecA;
        private Record slaveRecB;
        private long slaveTimestamp = Long.MIN_VALUE;

        public AsOfLightJoinRecordCursor(int columnSplit, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex) {
            super(columnSplit);
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.isMasterHasNextPending) {
                this.masterHasNext = this.masterCursor.hasNext();
                this.isMasterHasNextPending = false;
            }
            if (this.masterHasNext) {
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                if (masterTimestamp < this.slaveTimestamp) {
                    this.isMasterHasNextPending = true;
                    return true;
                }
                this.nextSlave(masterTimestamp);
                this.isMasterHasNextPending = true;
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        @Override
        public void toTop() {
            this.slaveTimestamp = Long.MIN_VALUE;
            this.latestSlaveRowID = Long.MIN_VALUE;
            this.record.hasSlave(false);
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
            this.isMasterHasNextPending = true;
        }

        private void nextSlave(long masterTimestamp) {
            block3: {
                block2: {
                    do {
                        boolean slaveHasNext = this.slaveCursor.hasNext();
                        if (this.latestSlaveRowID != Long.MIN_VALUE) {
                            this.record.hasSlave(true);
                            this.slaveCursor.recordAt(this.slaveRecB, this.latestSlaveRowID);
                        }
                        if (!slaveHasNext) break block2;
                        this.slaveTimestamp = this.slaveRecA.getTimestamp(this.slaveTimestampIndex);
                        this.latestSlaveRowID = this.slaveRecA.getRowId();
                    } while (this.slaveTimestamp <= masterTimestamp);
                    break block3;
                }
                this.slaveTimestamp = Long.MAX_VALUE;
            }
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.slaveTimestamp = Long.MIN_VALUE;
            this.latestSlaveRowID = Long.MIN_VALUE;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecA = slaveCursor.getRecord();
            this.slaveRecB = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecB);
            this.record.hasSlave(false);
            this.isMasterHasNextPending = true;
        }
    }
}

