/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cutlass.text.AtomicBooleanCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.griffin.engine.groupby.vect.GroupByNotKeyedVectorRecordCursorFactory;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateEntry;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.mp.Worker;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Rosti;
import io.questdb.std.RostiAllocFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.tasks.VectorAggregateTask;
import java.util.concurrent.atomic.AtomicInteger;

public class GroupByRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final Log LOG = LogFactory.getLog(GroupByRecordCursorFactory.class);
    private static final int ROSTI_MINIMIZED_SIZE = 16;
    private final RecordCursorFactory base;
    private final RostiRecordCursor cursor;
    private final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final ObjectPool<VectorAggregateEntry> entryPool;
    private final int keyColumnIndex;
    private final AtomicInteger oomCounter = new AtomicInteger();
    private final long[] pRosti;
    private final PerWorkerLocks perWorkerLocks;
    private final RostiAllocFacade raf;
    private final AtomicBooleanCircuitBreaker sharedCircuitBreaker;
    private final ObjList<VectorAggregateFunction> vafList;
    private final int workerCount;

    public GroupByRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata metadata, ColumnTypes columnTypes, int workerCount, ObjList<VectorAggregateFunction> vafList, int keyColumnIndexInBase, int keyColumnIndexInThisCursor, IntList symbolTableSkewIndex) {
        super(metadata);
        this.workerCount = workerCount;
        this.entryPool = new ObjectPool<VectorAggregateEntry>(VectorAggregateEntry::new, configuration.getGroupByPoolCapacity());
        this.perWorkerLocks = new PerWorkerLocks(configuration, workerCount);
        this.sharedCircuitBreaker = new AtomicBooleanCircuitBreaker();
        this.base = base;
        this.pRosti = new long[workerCount];
        int vafCount = vafList.size();
        this.vafList = new ObjList(vafCount);
        this.raf = configuration.getRostiAllocFacade();
        for (int i = 0; i < workerCount; ++i) {
            long ptr = this.raf.alloc(columnTypes, configuration.getGroupByMapCapacity());
            if (ptr == 0L) {
                for (int k = i - 1; k > -1; --k) {
                    this.raf.free(this.pRosti[k]);
                }
                throw new OutOfMemoryError();
            }
            this.pRosti[i] = ptr;
            switch (ColumnType.tagOf(columnTypes.getColumnType(0))) {
                case 5: {
                    Unsafe.getUnsafe().putInt(Rosti.getInitialValueSlot(this.pRosti[i], 0), Integer.MIN_VALUE);
                    break;
                }
                case 12: {
                    Unsafe.getUnsafe().putInt(Rosti.getInitialValueSlot(this.pRosti[i], 0), Integer.MIN_VALUE);
                    break;
                }
            }
            for (int j = 0; j < vafCount; ++j) {
                vafList.getQuick(j).initRosti(this.pRosti[i]);
            }
        }
        long pRosti = this.pRosti[0];
        long columnOffsets = Rosti.getValueOffsets(pRosti);
        IntList columnSkewIndex = new IntList();
        GroupByRecordCursorFactory.addOffsets(columnSkewIndex, vafList, 0, keyColumnIndexInThisCursor, columnOffsets);
        columnSkewIndex.add(0);
        GroupByRecordCursorFactory.addOffsets(columnSkewIndex, vafList, keyColumnIndexInThisCursor, vafCount, columnOffsets);
        this.vafList.addAll(vafList);
        this.keyColumnIndex = keyColumnIndexInBase;
        if (symbolTableSkewIndex.size() > 0) {
            IntList symbolSkew = new IntList(symbolTableSkewIndex.size());
            symbolSkew.addAll(symbolTableSkewIndex);
            this.cursor = new RostiRecordCursor(pRosti, columnSkewIndex, symbolSkew);
        } else {
            this.cursor = new RostiRecordCursor(pRosti, columnSkewIndex, null);
        }
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int i;
        this.oomCounter.set(0);
        int n = this.pRosti.length;
        for (i = 0; i < n; ++i) {
            this.raf.clear(this.pRosti[i]);
        }
        n = this.vafList.size();
        for (i = 0; i < n; ++i) {
            this.vafList.getQuick(i).clear();
        }
        PageFrameCursor pageFrameCursor = this.base.getPageFrameCursor(executionContext, 0);
        return this.cursor.of(pageFrameCursor, executionContext.getMessageBus(), executionContext.getCircuitBreaker());
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupBy");
        sink.meta("vectorized").val(true);
        sink.attr("keys").val("[").putBaseColumnNameNoRemap(this.keyColumnIndex).val("]");
        sink.optAttr("values", this.vafList, true);
        sink.attr("workers").val(this.workerCount);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    private static void addOffsets(IntList columnSkewIndex, ObjList<VectorAggregateFunction> vafList, int start, int end, long columnOffsets) {
        for (int i = start; i < end; ++i) {
            columnSkewIndex.add(Unsafe.getUnsafe().getInt(columnOffsets + (long)vafList.getQuick(i).getValueOffset() * 4L));
        }
    }

    private void resetRostiMemorySize() {
        int n = this.pRosti.length;
        for (int i = 0; i < n; ++i) {
            if (this.raf.reset(this.pRosti[i], 16)) continue;
            LOG.debug().$("Couldn't minimize rosti memory [i=").$(i).$(",current_size=").$(Rosti.getSize(this.pRosti[i])).I$();
        }
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.freeObjList(this.vafList);
        int n = this.pRosti.length;
        for (int i = 0; i < n; ++i) {
            this.raf.free(this.pRosti[i]);
        }
    }

    private class RostiRecordCursor
    implements RecordCursor {
        private final IntList columnSkewIndex;
        private final RostiRecord record;
        private final IntList symbolTableSkewIndex;
        private MessageBus bus;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private long count;
        private long ctrl;
        private long ctrlStart;
        private boolean isRostiBuilt;
        private long pRostiBig;
        private PageFrameCursor pageFrameCursor;
        private RostiRecord recordB;
        private long shift;
        private long size;
        private long slots;

        public RostiRecordCursor(long pRosti, IntList columnSkewIndex, IntList symbolTableSkewIndex) {
            this.pRostiBig = pRosti;
            this.record = new RostiRecord();
            this.symbolTableSkewIndex = symbolTableSkewIndex;
            this.columnSkewIndex = columnSkewIndex;
        }

        @Override
        public void close() {
            Misc.free(this.pageFrameCursor);
            GroupByRecordCursorFactory.this.raf.reset(this.pRostiBig, 16);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public Record getRecordB() {
            if (this.recordB != null) {
                return this.recordB;
            }
            this.recordB = new RostiRecord();
            return this.recordB;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.pageFrameCursor.getSymbolTable(this.symbolTableSkewIndex.getQuick(columnIndex));
        }

        @Override
        public boolean hasNext() {
            if (!this.isRostiBuilt) {
                this.buildRosti();
                this.isRostiBuilt = true;
            }
            while (this.count < this.size) {
                byte b = Unsafe.getUnsafe().getByte(this.ctrl);
                if ((b & 0x80) != 0) {
                    ++this.ctrl;
                    continue;
                }
                ++this.count;
                this.record.of(this.slots + (this.ctrl - this.ctrlStart << (int)this.shift));
                ++this.ctrl;
                return true;
            }
            return false;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.pageFrameCursor.newSymbolTable(this.symbolTableSkewIndex.getQuick(columnIndex));
        }

        public RostiRecordCursor of(PageFrameCursor pageFrameCursor, MessageBus bus, SqlExecutionCircuitBreaker circuitBreaker) {
            this.pageFrameCursor = pageFrameCursor;
            this.bus = bus;
            this.circuitBreaker = circuitBreaker;
            this.isRostiBuilt = false;
            return this;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            ((RostiRecord)record).of(atRowId);
        }

        @Override
        public long size() {
            return this.isRostiBuilt ? this.size : -1L;
        }

        @Override
        public void toTop() {
            this.ctrl = this.ctrlStart = Rosti.getCtrl(this.pRostiBig);
            this.slots = Rosti.getSlots(this.pRostiBig);
            this.size = GroupByRecordCursorFactory.this.raf.getSize(this.pRostiBig);
            this.shift = Rosti.getSlotShift(this.pRostiBig);
            this.count = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildRosti() {
            int vafCount = GroupByRecordCursorFactory.this.vafList.size();
            RingQueue<VectorAggregateTask> queue = this.bus.getVectorAggregateQueue();
            Sequence pubSeq = this.bus.getVectorAggregatePubSeq();
            GroupByRecordCursorFactory.this.sharedCircuitBreaker.reset();
            GroupByRecordCursorFactory.this.entryPool.clear();
            int queuedCount = 0;
            int ownCount = 0;
            int reclaimed = 0;
            int total = 0;
            GroupByRecordCursorFactory.this.doneLatch.reset();
            Thread thread = Thread.currentThread();
            int workerId = thread instanceof Worker ? ((Worker)thread).getWorkerId() % GroupByRecordCursorFactory.this.workerCount : -1;
            try {
                PageFrame frame;
                while ((frame = this.pageFrameCursor.next()) != null) {
                    long keyAddress = frame.getPageAddress(GroupByRecordCursorFactory.this.keyColumnIndex);
                    for (int i = 0; i < vafCount; ++i) {
                        VectorAggregateFunction vaf = GroupByRecordCursorFactory.this.vafList.getQuick(i);
                        int columnIndex = vaf.getColumnIndex();
                        long valueAddress = columnIndex > -1 ? frame.getPageAddress(columnIndex) : 0L;
                        int pageColIndex = columnIndex > -1 ? columnIndex : 0;
                        int columnSizeShr = frame.getColumnShiftBits(pageColIndex);
                        long valueAddressSize = frame.getPageSize(pageColIndex);
                        long seq = pubSeq.next();
                        if (seq < 0L) {
                            this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                            int slot = GroupByRecordCursorFactory.this.perWorkerLocks.acquireSlot(workerId, this.circuitBreaker);
                            try {
                                if (keyAddress == 0L) {
                                    vaf.aggregate(valueAddress, valueAddressSize, columnSizeShr, slot);
                                } else {
                                    long oldSize = Rosti.getAllocMemory(GroupByRecordCursorFactory.this.pRosti[slot]);
                                    if (!vaf.aggregate(GroupByRecordCursorFactory.this.pRosti[slot], keyAddress, valueAddress, valueAddressSize, columnSizeShr, slot)) {
                                        GroupByRecordCursorFactory.this.oomCounter.incrementAndGet();
                                    }
                                    GroupByRecordCursorFactory.this.raf.updateMemoryUsage(GroupByRecordCursorFactory.this.pRosti[slot], oldSize);
                                }
                                ++ownCount;
                            }
                            finally {
                                GroupByRecordCursorFactory.this.perWorkerLocks.releaseSlot(slot);
                            }
                        } else {
                            VectorAggregateEntry entry = GroupByRecordCursorFactory.this.entryPool.next();
                            ++queuedCount;
                            if (keyAddress == 0L) {
                                entry.of(vaf, null, 0L, valueAddress, valueAddressSize, columnSizeShr, GroupByRecordCursorFactory.this.doneLatch, GroupByRecordCursorFactory.this.oomCounter, null, GroupByRecordCursorFactory.this.perWorkerLocks, GroupByRecordCursorFactory.this.sharedCircuitBreaker);
                            } else {
                                entry.of(vaf, GroupByRecordCursorFactory.this.pRosti, keyAddress, valueAddress, valueAddressSize, columnSizeShr, GroupByRecordCursorFactory.this.doneLatch, GroupByRecordCursorFactory.this.oomCounter, GroupByRecordCursorFactory.this.raf, GroupByRecordCursorFactory.this.perWorkerLocks, GroupByRecordCursorFactory.this.sharedCircuitBreaker);
                            }
                            queue.get((long)seq).entry = entry;
                            pubSeq.done(seq);
                        }
                        ++total;
                    }
                }
            }
            catch (DataUnavailableException e) {
                throw e;
            }
            catch (Throwable e) {
                GroupByRecordCursorFactory.this.sharedCircuitBreaker.cancel();
                throw e;
            }
            finally {
                reclaimed = GroupByNotKeyedVectorRecordCursorFactory.getRunWhatsLeft(this.bus.getVectorAggregateSubSeq(), queue, queuedCount, reclaimed, workerId, GroupByRecordCursorFactory.this.doneLatch, LOG, this.circuitBreaker, GroupByRecordCursorFactory.this.sharedCircuitBreaker);
                if (GroupByRecordCursorFactory.this.sharedCircuitBreaker.isCanceled()) {
                    GroupByRecordCursorFactory.this.resetRostiMemorySize();
                }
            }
            if (GroupByRecordCursorFactory.this.oomCounter.get() > 0) {
                GroupByRecordCursorFactory.this.resetRostiMemorySize();
                throw new OutOfMemoryError();
            }
            this.pRostiBig = GroupByRecordCursorFactory.this.pRosti[0];
            try {
                if (GroupByRecordCursorFactory.this.pRosti.length > 1) {
                    int i;
                    LOG.debug().$("merging").$();
                    long size = GroupByRecordCursorFactory.this.raf.getSize(this.pRostiBig);
                    int n = GroupByRecordCursorFactory.this.pRosti.length;
                    for (i = 1; i < n; ++i) {
                        long curSize = GroupByRecordCursorFactory.this.raf.getSize(GroupByRecordCursorFactory.this.pRosti[i]);
                        if (curSize <= size) continue;
                        size = curSize;
                        this.pRostiBig = GroupByRecordCursorFactory.this.pRosti[i];
                    }
                    for (int j = 0; j < vafCount; ++j) {
                        VectorAggregateFunction vaf = GroupByRecordCursorFactory.this.vafList.getQuick(j);
                        int n2 = GroupByRecordCursorFactory.this.pRosti.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            if (this.pRostiBig == GroupByRecordCursorFactory.this.pRosti[i2] || GroupByRecordCursorFactory.this.raf.getSize(GroupByRecordCursorFactory.this.pRosti[i2]) < 1L) continue;
                            this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                            long oldSize = Rosti.getAllocMemory(this.pRostiBig);
                            if (!vaf.merge(this.pRostiBig, GroupByRecordCursorFactory.this.pRosti[i2])) {
                                GroupByRecordCursorFactory.this.resetRostiMemorySize();
                                throw new OutOfMemoryError();
                            }
                            GroupByRecordCursorFactory.this.raf.updateMemoryUsage(this.pRostiBig, oldSize);
                        }
                        this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                        long oldSize = Rosti.getAllocMemory(this.pRostiBig);
                        if (!vaf.wrapUp(this.pRostiBig)) {
                            GroupByRecordCursorFactory.this.resetRostiMemorySize();
                            throw new OutOfMemoryError();
                        }
                        GroupByRecordCursorFactory.this.raf.updateMemoryUsage(this.pRostiBig, oldSize);
                    }
                    this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                    n = GroupByRecordCursorFactory.this.pRosti.length;
                    for (i = 0; i < n; ++i) {
                        if (this.pRostiBig == GroupByRecordCursorFactory.this.pRosti[i] || GroupByRecordCursorFactory.this.raf.reset(GroupByRecordCursorFactory.this.pRosti[i], 16)) continue;
                        LOG.debug().$("couldn't minimize rosti memory [i=").$(i).$(",currentSize=").$(Rosti.getSize(GroupByRecordCursorFactory.this.pRosti[i])).I$();
                    }
                } else {
                    this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                    for (int j = 0; j < vafCount; ++j) {
                        if (GroupByRecordCursorFactory.this.vafList.getQuick(j).wrapUp(this.pRostiBig)) continue;
                        GroupByRecordCursorFactory.this.resetRostiMemorySize();
                        throw new OutOfMemoryError();
                    }
                }
            }
            catch (Throwable t) {
                GroupByRecordCursorFactory.this.resetRostiMemorySize();
                throw t;
            }
            this.toTop();
            LOG.info().$("done [total=").$(total).$(", ownCount=").$(ownCount).$(", reclaimed=").$(reclaimed).$(", queuedCount=").$(queuedCount).I$();
        }

        private class RostiRecord
        implements Record {
            private final Long256Impl long256A = new Long256Impl();
            private final Long256Impl long256B = new Long256Impl();
            private long pRow;

            private RostiRecord() {
            }

            @Override
            public BinarySequence getBin(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getBinLen(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean getBool(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte getByte(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public char getChar(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getDate(int col) {
                return this.getLong(col);
            }

            @Override
            public double getDouble(int col) {
                return Unsafe.getUnsafe().getDouble(this.getValueOffset(col));
            }

            @Override
            public float getFloat(int col) {
                return 0.0f;
            }

            @Override
            public byte getGeoByte(int col) {
                return this.getByte(col);
            }

            @Override
            public int getGeoInt(int col) {
                return this.getInt(col);
            }

            @Override
            public long getGeoLong(int col) {
                return this.getLong(col);
            }

            @Override
            public short getGeoShort(int col) {
                return this.getShort(col);
            }

            @Override
            public int getInt(int col) {
                return Unsafe.getUnsafe().getInt(this.getValueOffset(col));
            }

            @Override
            public long getLong(int col) {
                return Unsafe.getUnsafe().getLong(this.getValueOffset(col));
            }

            @Override
            public void getLong256(int col, CharSink sink) {
                Long256Impl v = (Long256Impl)this.getLong256A(col);
                v.toSink(sink);
            }

            @Override
            public Long256 getLong256A(int col) {
                return this.getLong256Value(this.long256A, col);
            }

            @Override
            public Long256 getLong256B(int col) {
                return this.getLong256Value(this.long256B, col);
            }

            public Long256 getLong256Value(Long256 dst, int col) {
                long offset = this.getValueOffset(col);
                long l0 = Unsafe.getUnsafe().getLong(offset);
                long l1 = Unsafe.getUnsafe().getLong(offset + 8L);
                long l2 = Unsafe.getUnsafe().getLong(offset + 16L);
                long l3 = Unsafe.getUnsafe().getLong(offset + 3L + 8L);
                dst.setAll(l0, l1, l2, l3);
                return dst;
            }

            @Override
            public long getRowId() {
                return this.pRow;
            }

            @Override
            public short getShort(int col) {
                return 0;
            }

            @Override
            public CharSequence getStr(int col) {
                return null;
            }

            @Override
            public void getStr(int col, CharSink sink) {
            }

            @Override
            public CharSequence getStrB(int col) {
                return null;
            }

            @Override
            public int getStrLen(int col) {
                return 0;
            }

            @Override
            public CharSequence getSym(int col) {
                return RostiRecordCursor.this.pageFrameCursor.getSymbolTable(RostiRecordCursor.this.symbolTableSkewIndex.getQuick(col)).valueOf(this.getInt(col));
            }

            @Override
            public CharSequence getSymB(int col) {
                return RostiRecordCursor.this.pageFrameCursor.getSymbolTable(RostiRecordCursor.this.symbolTableSkewIndex.getQuick(col)).valueBOf(this.getInt(col));
            }

            @Override
            public long getTimestamp(int col) {
                return this.getLong(col);
            }

            public void of(long pRow) {
                this.pRow = pRow;
            }

            private long getValueOffset(int column) {
                return this.pRow + (long)RostiRecordCursor.this.columnSkewIndex.getQuick(column);
            }
        }
    }
}

