/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractSplitVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

class SampleByFillValueRecordCursor
extends AbstractSplitVirtualRecordSampleByCursor
implements Reopenable {
    private final RecordSink keyMapSink;
    private final Map map;
    private final RecordCursor mapCursor;
    private final Record mapRecord;
    private boolean isHasNextPending;
    private boolean isMapBuildPending;
    private boolean isMapInitialized;
    private boolean isOpen;

    public SampleByFillValueRecordCursor(Map map, RecordSink keyMapSink, ObjList<GroupByFunction> groupByFunctions, GroupByFunctionsUpdater groupByFunctionsUpdater, ObjList<Function> recordFunctions, ObjList<Function> placeholderFunctions, int timestampIndex, TimestampSampler timestampSampler, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) {
        super(recordFunctions, timestampIndex, timestampSampler, groupByFunctions, groupByFunctionsUpdater, placeholderFunctions, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
        this.map = map;
        this.keyMapSink = keyMapSink;
        this.record.of(map.getRecord());
        this.mapCursor = map.getCursor();
        this.mapRecord = map.getRecord();
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.map.close();
            super.close();
            this.isOpen = false;
        }
    }

    @Override
    public boolean hasNext() {
        this.initMap();
        this.initTimestamps();
        if (this.mapCursor.hasNext()) {
            return this.refreshRecord();
        }
        if (this.baseRecord == null) {
            return false;
        }
        this.buildMap();
        return this.refreshMapCursor();
    }

    @Override
    public void of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
        super.of(baseCursor, executionContext);
        this.isHasNextPending = false;
        this.isMapBuildPending = true;
        this.isMapInitialized = false;
    }

    @Override
    public void reopen() {
        if (!this.isOpen) {
            this.map.reopen();
            this.isOpen = true;
        }
    }

    @Override
    public void toTop() {
        super.toTop();
        this.map.clear();
        this.isHasNextPending = false;
        this.isMapBuildPending = true;
        this.isMapInitialized = false;
    }

    private void buildMap() {
        block8: {
            long timestamp;
            if (this.isMapBuildPending) {
                long expectedLocalEpoch = this.timestampSampler.nextTimestamp(this.nextSampleLocalEpoch);
                if (expectedLocalEpoch < this.localEpoch) {
                    this.sampleLocalEpoch = expectedLocalEpoch;
                    this.nextSampleLocalEpoch = expectedLocalEpoch;
                    this.isMapBuildPending = true;
                    return;
                }
                this.sampleLocalEpoch = this.localEpoch;
                this.nextSampleLocalEpoch = this.localEpoch;
                this.isMapBuildPending = false;
            }
            long next = this.timestampSampler.nextTimestamp(this.localEpoch);
            while ((timestamp = this.getBaseRecordTimestamp()) < next) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                if (!this.isHasNextPending) {
                    this.adjustDstInFlight(timestamp - this.tzOffset);
                    MapKey key = this.map.withKey();
                    this.keyMapSink.copy(this.baseRecord, key);
                    MapValue value = key.findValue();
                    assert (value != null);
                    if (value.getLong(0) != this.localEpoch) {
                        value.putLong(0, this.localEpoch);
                        this.groupByFunctionsUpdater.updateNew(value, this.baseRecord);
                    } else {
                        this.groupByFunctionsUpdater.updateExisting(value, this.baseRecord);
                    }
                }
                this.isHasNextPending = true;
                boolean baseHasNext = this.baseCursor.hasNext();
                this.isHasNextPending = false;
                if (baseHasNext) continue;
                this.baseRecord = null;
                break block8;
            }
            if ((timestamp = this.adjustDst(timestamp, null, next)) != Long.MIN_VALUE) {
                this.nextSamplePeriod(timestamp);
            }
        }
        this.isMapBuildPending = true;
    }

    private void initMap() {
        if (this.isMapInitialized) {
            return;
        }
        int n = this.groupByFunctions.size();
        while (this.baseCursor.hasNext()) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            MapKey key = this.map.withKey();
            this.keyMapSink.copy(this.baseRecord, key);
            MapValue value = key.createValue();
            if (!value.isNew()) continue;
            value.putLong(0, Long.MIN_VALUE);
            for (int i = 0; i < n; ++i) {
                ((GroupByFunction)this.groupByFunctions.getQuick(i)).setNull(value);
            }
        }
        this.baseCursor.toTop();
        this.isMapInitialized = true;
    }

    private boolean refreshMapCursor() {
        this.map.getCursor().hasNext();
        return this.refreshRecord();
    }

    private boolean refreshRecord() {
        if (this.mapRecord.getTimestamp(0) == this.sampleLocalEpoch) {
            this.record.setActiveA();
        } else {
            this.record.setActiveB();
        }
        return true;
    }

    @Override
    protected void updateValueWhenClockMovesBack(MapValue value) {
        MapKey key = this.map.withKey();
        this.keyMapSink.copy(this.baseRecord, key);
        super.updateValueWhenClockMovesBack(key.createValue());
    }
}

