/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.regex.RegexUtils;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class RegexpReplaceStrFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "regexp_replace(SSS)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        Function pattern = args.getQuick(1);
        int patternPos = argPositions.getQuick(1);
        if (!pattern.isConstant() && !pattern.isRuntimeConstant()) {
            throw SqlException.$(patternPos, "not implemented: dynamic pattern would be very slow to execute");
        }
        Function replacement = args.getQuick(2);
        int replacementPos = argPositions.getQuick(2);
        if (!replacement.isConstant() && !replacement.isRuntimeConstant()) {
            throw SqlException.$(patternPos, "not implemented: dynamic replacement would be slow to execute");
        }
        int maxLength = configuration.getStrFunctionMaxBufferLength();
        return new Func(value, pattern, patternPos, replacement, replacementPos, maxLength, position);
    }

    private static class StringBufferSink
    implements CharSequence {
        private final StringBuffer buffer = new StringBuffer();

        private StringBufferSink() {
        }

        @Override
        public char charAt(int index) {
            return this.buffer.charAt(index);
        }

        public void clear() {
            this.buffer.setLength(0);
        }

        public boolean equals(Object obj) {
            return obj instanceof CharSequence && Chars.equals((CharSequence)this.buffer, (CharSequence)obj);
        }

        public int hashCode() {
            return Chars.hashCode(this.buffer);
        }

        @Override
        public int length() {
            return this.buffer.length();
        }

        @Override
        @NotNull
        public CharSequence subSequence(int lo, int hi) {
            return this.buffer.subSequence(lo, hi);
        }

        @Override
        @NotNull
        public String toString() {
            return this.buffer.toString();
        }
    }

    private static class Func
    extends StrFunction
    implements UnaryFunction {
        private final int functionPos;
        private final int maxLength;
        private final Function pattern;
        private final int patternPos;
        private final Function replacement;
        private final int replacementPos;
        private final StringBufferSink sink = new StringBufferSink();
        private final StringBufferSink sinkB = new StringBufferSink();
        private final Function value;
        private Matcher matcher;
        private String replacementStr;

        public Func(Function value, Function pattern, int patternPos, Function replacement, int replacementPos, int maxLength, int functionPos) {
            this.value = value;
            this.pattern = pattern;
            this.patternPos = patternPos;
            this.replacement = replacement;
            this.replacementPos = replacementPos;
            this.maxLength = maxLength;
            this.functionPos = functionPos;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.getStr(rec, this.sink);
        }

        public CharSequence getStr(Record rec, StringBufferSink sink) {
            CharSequence cs = this.value.getStr(rec);
            if (cs == null) {
                return null;
            }
            this.matcher.reset(cs);
            sink.clear();
            boolean result = this.find();
            if (!result) {
                sink.buffer.append(cs);
            } else {
                do {
                    if (sink.length() > this.maxLength) {
                        throw CairoException.nonCritical().put("breached memory limit set for ").put(RegexpReplaceStrFunctionFactory.SIGNATURE).put(" [maxLength=").put(this.maxLength).put(']');
                    }
                    this.matcher.appendReplacement(sink.buffer, this.replacementStr);
                } while (result = this.find());
                this.matcher.appendTail(sink.buffer);
            }
            return sink;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr(rec, this.sinkB);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            this.pattern.init(symbolTableSource, executionContext);
            this.matcher = RegexUtils.createMatcher(this.pattern, this.patternPos);
            this.replacement.init(symbolTableSource, executionContext);
            CharSequence cs = this.replacement.getStr(null);
            if (cs == null) {
                throw SqlException.$(this.replacementPos, "NULL replacement");
            }
            this.replacementStr = cs.toString();
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public boolean isRuntimeConstant() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("regexp_replace(").val(this.value).val(',').val(this.pattern).val(',').val(this.replacement).val(')');
        }

        private boolean find() {
            try {
                return this.matcher.find();
            }
            catch (StackOverflowError err) {
                throw CairoException.nonCritical().put("stack overflow error [position=").put(this.functionPos).put(']');
            }
        }
    }
}

