/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class PgDatabaseFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;
    private static final String SIGNATURE = "pg_database()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isCursor() {
        return true;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new PgDatabaseRecordCursorFactory());
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("oid", 5));
        metadata.add(new TableColumnMetadata("datname", 11));
        metadata.add(new TableColumnMetadata("datdba", 5));
        metadata.add(new TableColumnMetadata("encoding", 5));
        metadata.add(new TableColumnMetadata("datcollate", 11));
        metadata.add(new TableColumnMetadata("datctype", 11));
        metadata.add(new TableColumnMetadata("datistemplate", 1));
        metadata.add(new TableColumnMetadata("datallowconn", 1));
        metadata.add(new TableColumnMetadata("datconnlimit", 5));
        metadata.add(new TableColumnMetadata("datlastsysoid", 5));
        metadata.add(new TableColumnMetadata("datfrozenxid", 6));
        metadata.add(new TableColumnMetadata("datminmxid", 6));
        metadata.add(new TableColumnMetadata("dattablespace", 5));
        metadata.add(new TableColumnMetadata("datacl", 11));
        METADATA = metadata;
    }

    private static class PgDatabaseRecordCursorFactory
    extends AbstractRecordCursorFactory {
        private final PgDatabaseRecordCursor cursor = new PgDatabaseRecordCursor();

        public PgDatabaseRecordCursorFactory() {
            super(METADATA);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type(PgDatabaseFunctionFactory.SIGNATURE);
        }
    }

    private static class PgDatabaseRecordCursor
    implements RecordCursor {
        private static final PgDatabaseRecord RECORD = new PgDatabaseRecord();
        private boolean hasNext = true;

        private PgDatabaseRecordCursor() {
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return RECORD;
        }

        @Override
        public Record getRecordB() {
            return RECORD;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                this.hasNext = false;
                return true;
            }
            return false;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.hasNext = true;
        }
    }

    private static class PgDatabaseRecord
    implements Record {
        private PgDatabaseRecord() {
        }

        @Override
        public boolean getBool(int col) {
            return col != 6;
        }

        @Override
        public int getInt(int col) {
            switch (col) {
                case 0: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 0;
                }
                case 8: {
                    return -1;
                }
                case 9: {
                    return 1;
                }
            }
            return 3;
        }

        @Override
        public long getLong(int col) {
            if (col == 10) {
                return -1L;
            }
            return 0L;
        }

        @Override
        public long getRowId() {
            return 0L;
        }

        @Override
        public CharSequence getStr(int col) {
            switch (col) {
                case 1: {
                    return "questdb";
                }
                case 13: {
                    return "";
                }
            }
            return "en_US.UTF-8";
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStr(col);
        }

        @Override
        public int getStrLen(int col) {
            return this.getStr(col).length();
        }
    }
}

