/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.catalogue.Constants;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class KeywordsFunctionFactory
implements FunctionFactory {
    private static final int KEYWORD_COLUMN = 0;
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "keywords()";
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new KeywordListCursorFactory()){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("keyword", 11));
        METADATA = metadata;
    }

    private static class KeywordListCursorFactory
    extends AbstractRecordCursorFactory {
        private final KeywordsRecordCursor cursor = new KeywordsRecordCursor();

        public KeywordListCursorFactory() {
            super(METADATA);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("keywords()");
        }

        private static class KeywordsRecordCursor
        implements RecordCursor {
            private final KeywordRecord record = new KeywordRecord();
            private int index = -1;

            private KeywordsRecordCursor() {
            }

            @Override
            public void close() {
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public Record getRecordB() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return ++this.index < Constants.KEYWORDS.length;
            }

            @Override
            public void recordAt(Record record, long atRowId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size() {
                return Constants.KEYWORDS.length;
            }

            @Override
            public void toTop() {
                this.index = -1;
            }

            public class KeywordRecord
            implements Record {
                @Override
                public CharSequence getStr(int col) {
                    if (col == KEYWORD_COLUMN) {
                        return Constants.KEYWORDS[KeywordsRecordCursor.this.index];
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStr(col);
                }

                @Override
                public int getStrLen(int col) {
                    return this.getStr(col).length();
                }
            }
        }
    }
}

