/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionFactoryDescriptor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class FunctionListFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;
    private static final int NAME_COLUMN;
    private static final int RT_CONSTANT_COLUMN;
    private static final int SIGNATURE_COLUMN;
    private static final int SIGNATURE_TRANSLATED_COLUMN;
    private static final int TYPE_COLUMN;
    private static final ObjHashSet<CharSequence> excludeSet;

    public static boolean isExcluded(CharSequence funcName) {
        return excludeSet.contains(funcName) || Chars.startsWith(funcName, "test_");
    }

    @Override
    public String getSignature() {
        return "functions()";
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        FunctionFactoryCache ffCache = sqlExecutionContext.getCairoEngine().getFunctionFactoryCache();
        return new CursorFunction(new FunctionsCursorFactory(ffCache.getFactories())){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        excludeSet = new ObjHashSet();
        NAME_COLUMN = 0;
        SIGNATURE_COLUMN = 1;
        SIGNATURE_TRANSLATED_COLUMN = 2;
        RT_CONSTANT_COLUMN = 3;
        TYPE_COLUMN = 4;
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("name", 11));
        metadata.add(new TableColumnMetadata("signature", 11));
        metadata.add(new TableColumnMetadata("signature_translated", 11));
        metadata.add(new TableColumnMetadata("runtime_constant", 1));
        metadata.add(new TableColumnMetadata("type", 11));
        METADATA = metadata;
        excludeSet.add("&");
        excludeSet.add("|");
        excludeSet.add("^");
        excludeSet.add("~");
        excludeSet.add("[]");
        excludeSet.add("!=");
        excludeSet.add("!~");
        excludeSet.add("%");
        excludeSet.add("*");
        excludeSet.add("+");
        excludeSet.add("-");
        excludeSet.add(".");
        excludeSet.add("/");
        excludeSet.add("<");
        excludeSet.add("<=");
        excludeSet.add("<>");
        excludeSet.add("<>all");
        excludeSet.add("=");
        excludeSet.add(">");
        excludeSet.add(">=");
        excludeSet.add("VARCHAR");
    }

    private static class FunctionsCursorFactory
    extends AbstractRecordCursorFactory {
        private final FunctionsRecordCursor cursor = new FunctionsRecordCursor();
        private final LowerCaseCharSequenceObjHashMap<ObjList<FunctionFactoryDescriptor>> factories;
        private final ObjList<CharSequence> funcNames;

        public FunctionsCursorFactory(LowerCaseCharSequenceObjHashMap<ObjList<FunctionFactoryDescriptor>> factories) {
            super(METADATA);
            this.factories = factories;
            this.funcNames = factories.keys();
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("functions()");
        }

        private class FunctionsRecordCursor
        implements RecordCursor {
            private final FunctionRecord record = new FunctionRecord();
            ObjList<FunctionFactoryDescriptor> funcDescriptors;
            private int descriptorIndex = -1;
            private int funcNameIndex = -1;

            private FunctionsRecordCursor() {
            }

            @Override
            public void close() {
                this.funcNameIndex = -1;
                this.descriptorIndex = -1;
                this.funcDescriptors = null;
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public Record getRecordB() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (this.funcNameIndex < FunctionsCursorFactory.this.funcNames.size() - 1) {
                    if (this.funcDescriptors == null) {
                        ++this.funcNameIndex;
                        CharSequence funcName = FunctionsCursorFactory.this.funcNames.get(this.funcNameIndex);
                        if (FunctionListFunctionFactory.isExcluded(funcName)) {
                            return this.hasNext();
                        }
                        this.funcDescriptors = FunctionsCursorFactory.this.factories.get(funcName);
                        ++this.descriptorIndex;
                        this.record.init(funcName, this.funcDescriptors.get(this.descriptorIndex).getFactory());
                        return true;
                    }
                    ++this.descriptorIndex;
                    if (this.descriptorIndex < this.funcDescriptors.size()) {
                        this.record.init(FunctionsCursorFactory.this.funcNames.get(this.funcNameIndex), this.funcDescriptors.get(this.descriptorIndex).getFactory());
                        return true;
                    }
                    this.descriptorIndex = -1;
                    this.funcDescriptors = null;
                    return this.hasNext();
                }
                return false;
            }

            @Override
            public void recordAt(Record record, long atRowId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public void toTop() {
                this.close();
            }

            private class FunctionRecord
            implements Record {
                private final StringSink sink = new StringSink();
                private FunctionFactory funcFactory;
                private CharSequence funcName;

                private FunctionRecord() {
                }

                @Override
                public boolean getBool(int col) {
                    if (col == RT_CONSTANT_COLUMN) {
                        return this.funcFactory.isRuntimeConstant();
                    }
                    throw new IllegalArgumentException("offending: " + col);
                }

                @Override
                public CharSequence getStr(int col) {
                    if (col == NAME_COLUMN) {
                        return this.funcName;
                    }
                    if (col == SIGNATURE_COLUMN) {
                        return this.funcFactory.getSignature();
                    }
                    if (col == SIGNATURE_TRANSLATED_COLUMN) {
                        this.sink.clear();
                        return FunctionFactoryDescriptor.translateSignature(this.funcName, this.funcFactory.getSignature(), this.sink);
                    }
                    if (col == TYPE_COLUMN) {
                        return FunctionFactoryType.getType(this.funcFactory).name();
                    }
                    throw new IndexOutOfBoundsException("offending: " + col);
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStr(col);
                }

                @Override
                public int getStrLen(int col) {
                    return this.getStr(col).length();
                }

                private void init(CharSequence funcName, FunctionFactory factory) {
                    this.funcName = funcName;
                    this.funcFactory = factory;
                    this.sink.clear();
                }
            }
        }
    }

    public static enum FunctionFactoryType {
        PREDICATE,
        CURSOR,
        GROUP_BY,
        WINDOW,
        STANDARD;


        public static FunctionFactoryType getType(FunctionFactory factory) {
            if (factory.isBoolean()) {
                return PREDICATE;
            }
            if (factory.isCursor()) {
                return CURSOR;
            }
            if (factory.isGroupBy()) {
                return GROUP_BY;
            }
            if (factory.isWindow()) {
                return WINDOW;
            }
            return STANDARD;
        }
    }
}

