/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class InLongFunctionFactory
implements FunctionFactory {
    public static long tryParseLong(CharSequence seq, int position) throws SqlException {
        try {
            return Numbers.parseLong(seq, 0, seq.length());
        }
        catch (NumericException e) {
            throw SqlException.position(position).put("invalid LONG value");
        }
    }

    @Override
    public String getSignature() {
        return "in(LV)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        boolean allConst = true;
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 11: 
                case 12: 
                case 29: {
                    break;
                }
                default: {
                    throw SqlException.position(0).put("cannot compare LONG with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) continue;
            allConst = false;
            break;
        }
        if (allConst) {
            return new InLongConstFunction(args.getQuick(0), this.parseToLong(args, argPositions));
        }
        return new InLongVarFunction(new ObjList<Function>(args));
    }

    private LongList parseToLong(ObjList<Function> args, IntList argPositions) throws SqlException {
        LongList res = new LongList(args.size() - 1);
        res.extendAndSet(args.size() - 2, 0L);
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            long val = Long.MIN_VALUE;
            switch (ColumnType.tagOf(func.getType())) {
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    val = func.getLong(null);
                    break;
                }
                case 11: 
                case 12: {
                    CharSequence tsValue = func.getStr(null);
                    val = tsValue != null ? InLongFunctionFactory.tryParseLong(tsValue, argPositions.getQuick(i)) : Long.MIN_VALUE;
                }
            }
            res.setQuick(i - 1, val);
        }
        res.sort();
        return res;
    }

    private static class InLongVarFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;

        public InLongVarFunction(ObjList<Function> args) {
            this.args = args;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.args.getQuick(0).getLong(rec);
            int n = this.args.size();
            for (int i = 1; i < n; ++i) {
                Function func = this.args.getQuick(i);
                long val = Long.MIN_VALUE;
                switch (ColumnType.tagOf(func.getType())) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: {
                        val = func.getLong(rec);
                        break;
                    }
                    case 11: 
                    case 12: {
                        CharSequence str = func.getStr(rec);
                        val = Numbers.parseLongQuiet(str);
                    }
                }
                if (val != ts) continue;
                return !this.negated;
            }
            return this.negated;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0));
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ");
            sink.val(this.args, 1);
        }
    }

    private static class InLongConstFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final LongList inList;
        private final Function tsFunc;

        public InLongConstFunction(Function tsFunc, LongList longList) {
            this.tsFunc = tsFunc;
            this.inList = longList;
        }

        @Override
        public Function getArg() {
            return this.tsFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            long ts = this.tsFunc.getTimestamp(rec);
            return this.negated != this.inList.binarySearch(ts, -1) >= 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.tsFunc);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.inList);
        }
    }
}

