/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class StrBindVariable
extends StrFunction
implements ScalarFunction,
Mutable {
    private final int floatScale;
    private final StringSink sink = new StringSink();
    private boolean isNull = true;

    public StrBindVariable(int floatScale) {
        this.floatScale = floatScale;
    }

    @Override
    public void clear() {
        this.isNull = true;
        this.sink.clear();
    }

    @Override
    public void getStr(Record rec, CharSink sink) {
        if (this.isNull) {
            sink.put((CharSequence)null);
        } else {
            sink.put(this.sink);
        }
    }

    @Override
    public CharSequence getStr(Record rec) {
        return this.isNull ? null : this.sink;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.isNull ? null : this.sink;
    }

    @Override
    public int getStrLen(Record rec) {
        if (this.isNull) {
            return -1;
        }
        return this.sink.length();
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    public void setTimestamp(long value) {
        boolean bl = this.isNull = value == Long.MIN_VALUE;
        if (!this.isNull) {
            this.sink.clear();
            TimestampFormatUtils.appendDateTimeUSec(this.sink, value);
        }
    }

    public void setUuidValue(long lo, long hi) {
        this.sink.clear();
        if (SqlUtil.implicitCastUuidAsStr(lo, hi, this.sink)) {
            this.isNull = false;
        }
    }

    public void setValue(char value) {
        this.sink.clear();
        this.isNull = false;
        this.sink.put(value);
    }

    public void setValue(long l0, long l1, long l2, long l3) {
        this.sink.clear();
        this.isNull = false;
        Numbers.appendLong256(l0, l1, l2, l3, this.sink);
    }

    public void setValue(short value) {
        this.sink.clear();
        this.isNull = false;
        this.sink.put(value);
    }

    public void setValue(byte value) {
        this.sink.clear();
        this.isNull = false;
        this.sink.put(value);
    }

    public void setValue(long value) {
        boolean bl = this.isNull = value == Long.MIN_VALUE;
        if (!this.isNull) {
            this.sink.clear();
            this.sink.put(value);
        }
    }

    public void setValue(int value) {
        boolean bl = this.isNull = value == Integer.MIN_VALUE;
        if (!this.isNull) {
            this.sink.clear();
            this.sink.put(value);
        }
    }

    public void setValue(double value) {
        boolean bl = this.isNull = value == -9.223372036854776E18;
        if (!this.isNull) {
            this.sink.clear();
            this.sink.put(value);
        }
    }

    public void setValue(float value) {
        boolean bl = this.isNull = value == -9.223372E18f;
        if (!this.isNull) {
            this.sink.clear();
            this.sink.put(value, this.floatScale);
        }
    }

    public void setValue(CharSequence value) {
        if (value == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            this.sink.clear();
            this.sink.put(value);
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("?::string");
    }
}

