/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.jetbrains.annotations.NotNull;

public class PerWorkerLocks {
    private final AtomicIntegerArray locks;
    private final Rnd rnd;
    private final int workerCount;

    public PerWorkerLocks(@NotNull CairoConfiguration configuration, int workerCount) {
        this.rnd = new Rnd(configuration.getNanosecondClock().getTicks(), configuration.getMicrosecondClock().getTicks());
        this.workerCount = workerCount;
        this.locks = new AtomicIntegerArray(workerCount);
    }

    public int acquireSlot(int workerId, SqlExecutionCircuitBreaker sqlCircuitBreaker) {
        workerId = workerId == -1 ? this.rnd.nextInt(this.workerCount) : workerId;
        while (true) {
            for (int i = 0; i < this.workerCount; ++i) {
                int id = (i + workerId) % this.workerCount;
                if (!this.locks.compareAndSet(id, 0, 1)) continue;
                return id;
            }
            sqlCircuitBreaker.statefulThrowExceptionIfTripped();
            Os.pause();
        }
    }

    public int acquireSlot(int workerId, ExecutionCircuitBreaker circuitBreaker) {
        int n = workerId = workerId == -1 ? this.rnd.nextInt(this.workerCount) : workerId;
        while (!circuitBreaker.checkIfTripped()) {
            for (int i = 0; i < this.workerCount; ++i) {
                int id = (i + workerId) % this.workerCount;
                if (!this.locks.compareAndSet(id, 0, 1)) continue;
                return id;
            }
            Os.pause();
        }
        return -1;
    }

    public void releaseSlot(int slot) {
        if (slot == -1) {
            return;
        }
        this.locks.set(slot, 0);
    }
}

