/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import org.jetbrains.annotations.Nullable;

public class LimitRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final LimitRecordCursor cursor;

    public LimitRecordCursorFactory(RecordCursorFactory base, Function loFunction, @Nullable Function hiFunction) {
        super(base.getMetadata());
        this.base = base;
        this.cursor = new LimitRecordCursor(loFunction, hiFunction);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        boolean preTouchEnabled = executionContext.isColumnPreTouchEnabled();
        executionContext.setColumnPreTouchEnabled(preTouchEnabled && this.cursor.hiFunction == null);
        try {
            this.cursor.of(this.base.getCursor(executionContext), executionContext);
        }
        finally {
            executionContext.setColumnPreTouchEnabled(preTouchEnabled);
        }
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean implementsLimit() {
        return true;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Limit");
        if (this.cursor.loFunction != null) {
            sink.meta("lo").val(this.cursor.loFunction);
        }
        if (this.cursor.hiFunction != null) {
            sink.meta("hi").val(this.cursor.hiFunction);
        }
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    protected void _close() {
        this.base.close();
    }

    private static class LimitRecordCursor
    implements RecordCursor {
        private final Function hiFunction;
        private final Function loFunction;
        private boolean areRowsCounted;
        private RecordCursor base;
        private long hi;
        private boolean isLimitCounted;
        private long limit;
        private long lo;
        private long rowCount;
        private long size;
        private long skipToRows;

        public LimitRecordCursor(Function loFunction, Function hiFunction) {
            this.loFunction = loFunction;
            this.hiFunction = hiFunction;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public Record getRecord() {
            return this.base.getRecord();
        }

        @Override
        public Record getRecordB() {
            return this.base.getRecordB();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.base.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (!this.isLimitCounted) {
                this.countLimit();
                this.isLimitCounted = true;
            }
            if (this.limit <= 0L) {
                return false;
            }
            if (this.base.hasNext()) {
                --this.limit;
                return true;
            }
            return false;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.base.newSymbolTable(columnIndex);
        }

        public void of(RecordCursor base, SqlExecutionContext executionContext) throws SqlException {
            this.base = base;
            this.loFunction.init(base, executionContext);
            if (this.hiFunction != null) {
                this.hiFunction.init(base, executionContext);
            }
            this.toTop();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.base.recordAt(record, atRowId);
        }

        @Override
        public long size() {
            return this.size > -1L ? this.size : -1L;
        }

        @Override
        public void toTop() {
            this.base.toTop();
            this.rowCount = -1L;
            this.size = -1L;
            this.skipToRows = -1L;
            this.lo = this.loFunction.getLong(null);
            this.hi = this.hiFunction != null ? this.hiFunction.getLong(null) : -1L;
            this.isLimitCounted = false;
            this.areRowsCounted = false;
        }

        private void countLimit() {
            if (this.lo < 0L && this.hiFunction == null) {
                this.countRows();
                if (this.rowCount > -this.lo) {
                    this.skipRows(this.rowCount + this.lo);
                } else {
                    this.base.toTop();
                }
                this.size = this.limit = Math.min(this.rowCount, -this.lo);
            } else if (this.lo > -1L && this.hiFunction == null) {
                long baseRowCount = this.base.size();
                this.limit = baseRowCount > -1L ? Math.min(baseRowCount, this.lo) : this.lo;
                this.size = this.limit;
            } else if (this.lo < 0L) {
                if (this.lo < this.hi) {
                    this.countRows();
                    if (this.rowCount >= -this.hi) {
                        if (this.rowCount < -this.lo) {
                            this.base.toTop();
                            this.limit = this.rowCount + this.hi;
                        } else {
                            this.skipRows(this.rowCount + this.lo);
                            this.limit = Math.min(this.rowCount, -this.lo + this.hi);
                        }
                        this.size = this.limit;
                    }
                } else {
                    this.limit = 0L;
                    this.size = 0L;
                }
            } else if (this.hi < 0L) {
                this.countRows();
                this.size = this.limit = Math.max(this.rowCount - this.lo + this.hi, 0L);
                if (this.lo > 0L && this.limit > 0L) {
                    this.skipRows(this.lo);
                } else {
                    this.base.toTop();
                }
            } else {
                long baseRowCount = this.base.size();
                this.limit = baseRowCount > -1L ? Math.max(0L, Math.min(baseRowCount, this.hi) - this.lo) : Math.max(0L, this.hi - this.lo);
                this.size = this.limit;
                if (this.lo > 0L && this.limit > 0L) {
                    this.skipRows(this.lo);
                }
            }
        }

        private void countRows() {
            if (this.rowCount == -1L) {
                this.rowCount = this.base.size();
                if (this.rowCount > -1L) {
                    this.areRowsCounted = true;
                    return;
                }
                this.rowCount = 0L;
            }
            if (!this.areRowsCounted) {
                while (this.base.hasNext()) {
                    ++this.rowCount;
                }
                this.areRowsCounted = true;
            }
        }

        private void skipRows(long rowCount) {
            if (this.skipToRows == -1L) {
                this.skipToRows = Math.max(0L, rowCount);
                this.base.toTop();
            }
            if (this.skipToRows > 0L) {
                if (this.base.skipTo(rowCount)) {
                    this.skipToRows = 0L;
                }
                while (this.skipToRows > 0L && this.base.hasNext()) {
                    --this.skipToRows;
                }
            }
        }
    }
}

