/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public abstract class AbstractVirtualFunctionRecordCursor
implements RecordCursor {
    protected final VirtualRecord recordA;
    private final ObjList<Function> functions;
    private final VirtualRecord recordB;
    private final boolean supportsRandomAccess;
    protected RecordCursor baseCursor;

    public AbstractVirtualFunctionRecordCursor(ObjList<Function> functions, boolean supportsRandomAccess) {
        this.functions = functions;
        if (supportsRandomAccess) {
            this.recordA = new VirtualRecord(functions);
            this.recordB = new VirtualRecord(functions);
        } else {
            this.recordA = new VirtualRecord(functions);
            this.recordB = null;
        }
        this.supportsRandomAccess = supportsRandomAccess;
    }

    @Override
    public void close() {
        this.baseCursor = Misc.free(this.baseCursor);
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        if (this.supportsRandomAccess) {
            return this.recordB;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return (SymbolTable)((Object)this.functions.getQuick(columnIndex));
    }

    @Override
    public boolean hasNext() {
        return this.baseCursor.hasNext();
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return ((SymbolFunction)this.functions.getQuick(columnIndex)).newSymbolTable();
    }

    public void of(RecordCursor cursor) {
        this.baseCursor = cursor;
        this.recordA.of(this.baseCursor.getRecord());
        if (this.recordB != null) {
            this.recordB.of(this.baseCursor.getRecordB());
        }
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        if (this.supportsRandomAccess) {
            if (this.baseCursor != null) {
                this.baseCursor.recordAt(((VirtualRecord)record).getBaseRecord(), atRowId);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public long size() {
        return this.baseCursor != null ? this.baseCursor.size() : -1L;
    }

    @Override
    public void toTop() {
        if (this.baseCursor != null) {
            this.baseCursor.toTop();
            GroupByUtils.toTop(this.functions);
        }
    }
}

