/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.log.Log;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Os;
import io.questdb.std.str.Path;
import io.questdb.tasks.ColumnPurgeTask;

public final class PurgingOperator {
    public static final long TABLE_ROOT_PARTITION = -9223372036854775807L;
    private final LongList cleanupColumnVersions = new LongList();
    private final LongList cleanupColumnVersionsAsync = new LongList();
    private final FilesFacade ff;
    private final Log log;
    private final MessageBus messageBus;
    private final IntList updateColumnIndexes = new IntList();

    public PurgingOperator(Log log, CairoConfiguration configuration, MessageBus messageBus) {
        this.log = log;
        this.messageBus = messageBus;
        this.ff = configuration.getFilesFacade();
    }

    public void add(int columnIndex, long columnVersion, long partitionTimestamp, long partitionNameTxn) {
        if (!this.updateColumnIndexes.contains(columnIndex)) {
            this.updateColumnIndexes.add(columnIndex);
        }
        this.cleanupColumnVersions.add(columnIndex, columnVersion, partitionTimestamp, partitionNameTxn);
    }

    public void clear() {
        this.updateColumnIndexes.clear();
        this.cleanupColumnVersions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(Path path, TableToken tableToken, int partitionBy, boolean asyncOnly, TableRecordMetadata tableMetadata, long truncateVersion, long txn) {
        int rootLen = path.length();
        try {
            int nn = this.updateColumnIndexes.size();
            for (int updatedCol = 0; updatedCol < nn; ++updatedCol) {
                int processColumnIndex = this.updateColumnIndexes.getQuick(updatedCol);
                String columnName = tableMetadata.getColumnName(processColumnIndex);
                int rawType = tableMetadata.getColumnType(processColumnIndex);
                int columnType = Math.abs(rawType);
                this.cleanupColumnVersionsAsync.clear();
                int n = this.cleanupColumnVersions.size();
                for (int i = 0; i < n; i += 4) {
                    boolean columnPurged;
                    int columnIndex = (int)this.cleanupColumnVersions.getQuick(i);
                    long columnVersion = this.cleanupColumnVersions.getQuick(i + 1);
                    long partitionTimestamp = this.cleanupColumnVersions.getQuick(i + 2);
                    long partitionNameTxn = this.cleanupColumnVersions.getQuick(i + 3);
                    if (columnIndex != processColumnIndex) continue;
                    boolean bl = columnPurged = !asyncOnly;
                    if (!asyncOnly) {
                        if (partitionTimestamp != -9223372036854775807L) {
                            path.trimTo(rootLen);
                            TableUtils.setPathForPartition(path, partitionBy, partitionTimestamp, partitionNameTxn);
                            int pathPartitionLen = path.length();
                            TableUtils.dFile(path, columnName, columnVersion);
                            boolean bl2 = columnPurged = this.ff.remove(path.$()) || !this.ff.exists(path);
                            if (ColumnType.isVariableLength(columnType)) {
                                TableUtils.iFile(path.trimTo(pathPartitionLen), columnName, columnVersion);
                                columnPurged &= this.ff.remove(path.$()) || !this.ff.exists(path);
                            }
                            if (tableMetadata.isColumnIndexed(columnIndex)) {
                                BitmapIndexUtils.valueFileName(path.trimTo(pathPartitionLen), columnName, columnVersion);
                                columnPurged &= this.ff.remove(path.$()) || !this.ff.exists(path);
                                BitmapIndexUtils.keyFileName(path.trimTo(pathPartitionLen), columnName, columnVersion);
                                columnPurged &= this.ff.remove(path.$()) || !this.ff.exists(path);
                            }
                        } else {
                            TableUtils.charFileName(path.trimTo(rootLen), columnName, columnVersion);
                            columnPurged = this.ff.remove(path.$()) || !this.ff.exists(path);
                            TableUtils.offsetFileName(path.trimTo(rootLen), columnName, columnVersion);
                            columnPurged &= this.ff.remove(path.$()) || !this.ff.exists(path);
                            BitmapIndexUtils.keyFileName(path.trimTo(rootLen), columnName, columnVersion);
                            columnPurged &= this.ff.remove(path.$()) || !this.ff.exists(path);
                            BitmapIndexUtils.valueFileName(path.trimTo(rootLen), columnName, columnVersion);
                            columnPurged &= this.ff.remove(path.$()) || !this.ff.exists(path);
                        }
                    }
                    if (columnPurged) continue;
                    this.cleanupColumnVersionsAsync.add(columnVersion, partitionTimestamp, partitionNameTxn, 0L);
                }
                if (this.cleanupColumnVersionsAsync.size() > 0) {
                    this.purgeColumnVersionAsync(tableToken, columnName, tableMetadata.getTableId(), (int)truncateVersion, rawType, partitionBy, txn, this.cleanupColumnVersionsAsync);
                    this.log.info().$("column purge scheduled [table=").utf8(tableToken.getTableName()).$(", column=").utf8(columnName).$(", updateTxn=").$(txn).I$();
                    continue;
                }
                this.log.info().$("column complete [table=").utf8(tableToken.getTableName()).$(", column=").utf8(columnName).$(", newColumnVersion=").$(txn - 1L).I$();
            }
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    private void purgeColumnVersionAsync(TableToken tableName, CharSequence columnName, int tableId, int tableTruncateVersion, int columnType, int partitionBy, long updateTxn, LongList columnVersions) {
        Sequence pubSeq = this.messageBus.getColumnPurgePubSeq();
        while (true) {
            long cursor;
            if ((cursor = pubSeq.next()) > -1L) {
                ColumnPurgeTask task = this.messageBus.getColumnPurgeQueue().get(cursor);
                task.of(tableName, columnName, tableId, tableTruncateVersion, columnType, partitionBy, updateTxn, columnVersions);
                pubSeq.done(cursor);
                return;
            }
            if (cursor == -1L) {
                this.log.error().$("cannot schedule column purge, purge queue is full. Please run 'VACUUM TABLE \"").utf8(tableName.getTableName()).$("\"' [columnName=").utf8(columnName).$(", updateTxn=").$(updateTxn).I$();
                return;
            }
            Os.pause();
        }
    }
}

