/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.wal.WalWriterMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.TableListRecordCursorFactory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SimpleWaitingLock;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class DatabaseSnapshotAgent
implements Closeable {
    private static final Log LOG = LogFactory.getLog(DatabaseSnapshotAgent.class);
    private final AtomicBoolean activePrepareFlag = new AtomicBoolean();
    private final CairoConfiguration configuration;
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final ReentrantLock lock = new ReentrantLock();
    private final WalWriterMetadata metadata;
    private final Path path = new Path();
    private final ObjList<TableReader> snapshotReaders = new ObjList();
    private SimpleWaitingLock walPurgeJobRunLock = null;

    public DatabaseSnapshotAgent(CairoEngine engine) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
        this.ff = this.configuration.getFilesFacade();
        this.metadata = new WalWriterMetadata(this.ff);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void recoverSnapshot(CairoEngine engine) {
        CairoConfiguration configuration = engine.getConfiguration();
        if (!configuration.isSnapshotRecoveryEnabled()) {
            return;
        }
        FilesFacade ff = configuration.getFilesFacade();
        String root = configuration.getRoot();
        CharSequence snapshotRoot = configuration.getSnapshotRoot();
        try (Path srcPath = new Path();
             Path dstPath = new Path();
             MemoryCMARW memFile = Vm.getCMARWInstance();){
            srcPath.of(snapshotRoot).concat(configuration.getDbDirectory());
            int snapshotRootLen = srcPath.length();
            dstPath.of(root);
            int rootLen = dstPath.length();
            if (!ff.exists(srcPath.slash$())) {
                return;
            }
            srcPath.trimTo(snapshotRootLen).concat("_snapshot").$();
            if (!ff.exists(srcPath)) {
                return;
            }
            memFile.smallFile(ff, srcPath, 0);
            CharSequence currentInstanceId = configuration.getSnapshotInstanceId();
            CharSequence snapshotInstanceId = memFile.getStr(0L);
            if (Chars.empty(currentInstanceId)) return;
            if (Chars.empty(snapshotInstanceId)) return;
            if (Chars.equals(currentInstanceId, snapshotInstanceId)) {
                return;
            }
            LOG.info().$("starting snapshot recovery [currentId=`").$(currentInstanceId).$("`, previousId=`").$(snapshotInstanceId).$("`]").$();
            AtomicInteger recoveredMetaFiles = new AtomicInteger();
            AtomicInteger recoveredTxnFiles = new AtomicInteger();
            AtomicInteger recoveredCVFiles = new AtomicInteger();
            AtomicInteger recoveredWalFiles = new AtomicInteger();
            srcPath.trimTo(snapshotRootLen).$();
            int snapshotDbLen = srcPath.length();
            ff.iterateDir(srcPath, (pUtf8NameZ, type) -> {
                if (ff.isDirOrSoftLinkDirNoDots(srcPath, snapshotDbLen, pUtf8NameZ, type)) {
                    dstPath.trimTo(rootLen).concat(pUtf8NameZ);
                    int srcPathLen = srcPath.length();
                    int dstPathLen = dstPath.length();
                    srcPath.concat("_meta").$();
                    dstPath.concat("_meta").$();
                    if (ff.exists(srcPath) && ff.exists(dstPath)) {
                        if (ff.copy(srcPath, dstPath) < 0) {
                            LOG.error().$("could not copy _meta file [src=").utf8(srcPath).$(", dst=").utf8(dstPath).$(", errno=").$(ff.errno()).$(']').$();
                        } else {
                            recoveredMetaFiles.incrementAndGet();
                            LOG.info().$("recovered _meta file [src=").utf8(srcPath).$(", dst=").utf8(dstPath).$(']').$();
                        }
                    }
                    srcPath.trimTo(srcPathLen).concat("_txn").$();
                    dstPath.trimTo(dstPathLen).concat("_txn").$();
                    if (ff.exists(srcPath) && ff.exists(dstPath)) {
                        if (ff.copy(srcPath, dstPath) < 0) {
                            LOG.error().$("could not copy _txn file [src=").utf8(srcPath).$(", dst=").utf8(dstPath).$(", errno=").$(ff.errno()).$(']').$();
                        } else {
                            recoveredTxnFiles.incrementAndGet();
                            LOG.info().$("recovered _txn file [src=").utf8(srcPath).$(", dst=").utf8(dstPath).$(']').$();
                        }
                    }
                    srcPath.trimTo(srcPathLen).concat("_cv").$();
                    dstPath.trimTo(dstPathLen).concat("_cv").$();
                    if (ff.exists(srcPath) && ff.exists(dstPath)) {
                        if (ff.copy(srcPath, dstPath) < 0) {
                            LOG.error().$("could not copy _cv file [src=").utf8(srcPath).$(", dst=").utf8(dstPath).$(", errno=").$(ff.errno()).$(']').$();
                        } else {
                            recoveredCVFiles.incrementAndGet();
                            LOG.info().$("recovered _cv file [src=").utf8(srcPath).$(", dst=").utf8(dstPath).$(']').$();
                        }
                    }
                    srcPath.trimTo(srcPathLen).concat("txn_seq");
                    srcPathLen = srcPath.length();
                    srcPath.concat("_meta").$();
                    dstPath.trimTo(dstPathLen).concat("txn_seq");
                    dstPathLen = dstPath.length();
                    dstPath.concat("_meta").$();
                    if (ff.exists(srcPath) && ff.exists(dstPath)) {
                        if (ff.copy(srcPath, dstPath) < 0) {
                            LOG.critical().$("could not copy ").$("_meta").$(" file [src=").utf8(srcPath).utf8(", dst=").utf8(dstPath).$(", errno=").$(ff.errno()).$(']').$();
                        } else {
                            try {
                                srcPath.trimTo(srcPathLen);
                                TableUtils.openSmallFile(ff, srcPath, srcPathLen, memFile, "_txn", 53);
                                long newMaxTxn = memFile.getLong(0L);
                                memFile.smallFile(ff, dstPath, 38);
                                dstPath.trimTo(dstPathLen);
                                TableUtils.openSmallFile(ff, dstPath, dstPathLen, memFile, "_txnlog.meta.i", 53);
                                if (newMaxTxn >= 0L) {
                                    dstPath.trimTo(dstPathLen);
                                    TableUtils.openSmallFile(ff, dstPath, dstPathLen, memFile, "_txnlog", 53);
                                    long oldMaxTxn = memFile.getLong(4L);
                                    if (newMaxTxn < oldMaxTxn) {
                                        memFile.putLong(4L, newMaxTxn);
                                        LOG.info().$("updated ").$("_txnlog").$(" file [path=").utf8(dstPath).$(", oldMaxTxn=").$(oldMaxTxn).$(", newMaxTxn=").$(newMaxTxn).$(']').$();
                                    }
                                }
                            }
                            catch (CairoException ex) {
                                LOG.critical().$("could not update file [src=").utf8(dstPath).$("`, ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ff.errno()).$(']').$();
                            }
                            recoveredWalFiles.incrementAndGet();
                            LOG.info().$("recovered ").$("_meta").$(" file [src=").utf8(srcPath).$(", dst=").utf8(dstPath).$(']').$();
                        }
                    }
                }
            });
            LOG.info().$("snapshot recovery finished [metaFilesCount=").$(recoveredMetaFiles.get()).$(", txnFilesCount=").$(recoveredTxnFiles.get()).$(", cvFilesCount=").$(recoveredCVFiles.get()).$(", walFilesCount=").$(recoveredWalFiles.get()).$(']').$();
            srcPath.trimTo(snapshotRootLen).$();
            memFile.close();
            if (ff.rmdir(srcPath) == 0) return;
            throw CairoException.critical(ff.errno()).put("could not remove snapshot dir [dir=").put(srcPath).put(", errno=").put(ff.errno()).put(']');
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.unsafeReleaseReaders();
            this.metadata.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            Misc.free(this.path);
            this.unsafeReleaseReaders();
            this.metadata.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void completeSnapshot() throws SqlException {
        if (!this.lock.tryLock()) {
            throw SqlException.position(0).put("Another snapshot command in progress");
        }
        try {
            this.activePrepareFlag.set(false);
            if (this.snapshotReaders.size() == 0) {
                LOG.info().$("Snapshot has no tables, SNAPSHOT COMPLETE is ignored.").$();
            }
            this.path.of(this.configuration.getSnapshotRoot()).concat(this.configuration.getDbDirectory()).$();
            this.ff.rmdir(this.path);
            this.unsafeReleaseReaders();
            if (this.walPurgeJobRunLock != null) {
                try {
                    this.walPurgeJobRunLock.unlock();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareSnapshot(SqlExecutionContext executionContext) throws SqlException {
        if (Os.isWindows()) {
            throw SqlException.position(0).put("Snapshots are not supported on Windows");
        }
        if (!this.lock.tryLock()) {
            throw SqlException.position(0).put("Another snapshot command in progress");
        }
        try {
            if (this.activePrepareFlag.get()) {
                throw SqlException.position(0).put("Waiting for SNAPSHOT COMPLETE to be called");
            }
            this.path.of(this.configuration.getSnapshotRoot()).concat(this.configuration.getDbDirectory());
            int snapshotLen = this.path.length();
            if (this.ff.exists(this.path.slash$())) {
                this.path.trimTo(snapshotLen).$();
                if (this.ff.rmdir(this.path) != 0) {
                    throw CairoException.critical(this.ff.errno()).put("Could not remove snapshot dir [dir=").put(this.path).put(']');
                }
            }
            this.path.trimTo(snapshotLen).slash$();
            if (this.ff.mkdirs(this.path, this.configuration.getMkDirMode()) != 0) {
                throw CairoException.critical(this.ff.errno()).put("Could not create [dir=").put(this.path).put(']');
            }
            try (TableListRecordCursorFactory factory = new TableListRecordCursorFactory();){
                int tableNameIndex = factory.getMetadata().getColumnIndex("table");
                try (RecordCursor cursor = factory.getCursor(executionContext);){
                    Record record = cursor.getRecord();
                    if (this.walPurgeJobRunLock != null) {
                        long timeout = this.configuration.getCircuitBreakerConfiguration().getTimeout();
                        while (!this.walPurgeJobRunLock.tryLock(timeout, TimeUnit.MICROSECONDS)) {
                            executionContext.getCircuitBreaker().statefulThrowExceptionIfTrippedNoThrottle();
                        }
                    }
                    try (MemoryCMARW mem = Vm.getCMARWInstance();){
                        while (cursor.hasNext()) {
                            CharSequence tableName = record.getStr(tableNameIndex);
                            this.path.of(this.configuration.getRoot());
                            TableToken tableToken = this.engine.verifyTableName(tableName);
                            if (TableUtils.isValidTableName(tableName, tableName.length()) && this.ff.exists(this.path.concat(tableToken).concat("_meta").$())) {
                                boolean isWalTable = this.engine.isWalTable(tableToken);
                                this.path.of(this.configuration.getSnapshotRoot()).concat(this.configuration.getDbDirectory());
                                LOG.info().$("preparing for snapshot [table=").$(tableName).I$();
                                TableReader reader = this.engine.getReaderWithRepair(tableToken);
                                this.snapshotReaders.add(reader);
                                this.path.trimTo(snapshotLen).concat(tableToken);
                                int rootLen = this.path.length();
                                if (isWalTable) {
                                    this.path.concat("txn_seq");
                                }
                                if (this.ff.mkdirs(this.path.slash$(), this.configuration.getMkDirMode()) != 0) {
                                    throw CairoException.critical(this.ff.errno()).put("Could not create [dir=").put(this.path).put(']');
                                }
                                this.path.trimTo(rootLen).concat("_meta").$();
                                mem.smallFile(this.ff, this.path, 0);
                                reader.getMetadata().dumpTo(mem);
                                mem.close(false);
                                this.path.trimTo(rootLen).concat("_txn").$();
                                mem.smallFile(this.ff, this.path, 0);
                                reader.getTxFile().dumpTo(mem);
                                mem.close(false);
                                this.path.trimTo(rootLen).concat("_cv").$();
                                mem.smallFile(this.ff, this.path, 0);
                                reader.getColumnVersionReader().dumpTo(mem);
                                mem.close(false);
                                if (!isWalTable) continue;
                                this.metadata.clear();
                                long lastTxn = this.engine.getTableSequencerAPI().getTableMetadata(tableToken, this.metadata);
                                this.path.trimTo(rootLen).concat("txn_seq");
                                this.metadata.switchTo(this.path, this.path.length());
                                this.metadata.close((byte)1);
                                mem.smallFile(this.ff, this.path.concat("_txn").$(), 0);
                                mem.putLong(lastTxn);
                                mem.close(true, (byte)1);
                                continue;
                            }
                            LOG.error().$("skipping, invalid table name or missing metadata [table=").$(tableName).I$();
                        }
                        this.path.of(this.configuration.getSnapshotRoot()).concat(this.configuration.getDbDirectory()).concat("_snapshot").$();
                        mem.smallFile(this.ff, this.path, 0);
                        mem.putStr(this.configuration.getSnapshotInstanceId());
                        mem.close();
                        if (this.ff.sync() != 0) {
                            throw CairoException.critical(this.ff.errno()).put("Could not sync");
                        }
                        this.activePrepareFlag.set(true);
                        LOG.info().$("snapshot copying finished").$();
                    }
                    catch (Throwable e) {
                        if (this.walPurgeJobRunLock != null) {
                            this.walPurgeJobRunLock.unlock();
                        }
                        this.unsafeReleaseReaders();
                        LOG.error().$("snapshot error [e=").$(e).I$();
                        throw e;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setWalPurgeJobRunLock(@Nullable SimpleWaitingLock walPurgeJobRunLock) {
        this.walPurgeJobRunLock = walPurgeJobRunLock;
    }

    private void unsafeReleaseReaders() {
        Misc.freeObjListAndClear(this.snapshotReaders);
    }
}

