/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.types.BooleanAdapter;
import io.questdb.cutlass.text.types.ByteAdapter;
import io.questdb.cutlass.text.types.CharAdapter;
import io.questdb.cutlass.text.types.DateAdapter;
import io.questdb.cutlass.text.types.DateUtf8Adapter;
import io.questdb.cutlass.text.types.DoubleAdapter;
import io.questdb.cutlass.text.types.FloatAdapter;
import io.questdb.cutlass.text.types.GeoHashAdapter;
import io.questdb.cutlass.text.types.InputFormatConfiguration;
import io.questdb.cutlass.text.types.IntAdapter;
import io.questdb.cutlass.text.types.Long256Adapter;
import io.questdb.cutlass.text.types.LongAdapter;
import io.questdb.cutlass.text.types.ShortAdapter;
import io.questdb.cutlass.text.types.StringAdapter;
import io.questdb.cutlass.text.types.SymbolAdapter;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TimestampUtf8Adapter;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.UuidAdapter;
import io.questdb.std.IntList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.str.DirectCharSink;

public class TypeManager
implements Mutable {
    private final ObjectPool<DateUtf8Adapter> dateAdapterPool;
    private final SymbolAdapter indexedSymbolAdapter;
    private final InputFormatConfiguration inputFormatConfiguration;
    private final SymbolAdapter notIndexedSymbolAdapter;
    private final int probeCount;
    private final ObjList<TypeAdapter> probes = new ObjList();
    private final StringAdapter stringAdapter;
    private final ObjectPool<TimestampAdapter> timestampAdapterPool;
    private final ObjectPool<TimestampUtf8Adapter> timestampUtf8AdapterPool;

    public TypeManager(TextConfiguration configuration, DirectCharSink utf8Sink) {
        this.dateAdapterPool = new ObjectPool<DateUtf8Adapter>(() -> new DateUtf8Adapter(utf8Sink), configuration.getDateAdapterPoolCapacity());
        this.timestampUtf8AdapterPool = new ObjectPool<TimestampUtf8Adapter>(() -> new TimestampUtf8Adapter(utf8Sink), configuration.getTimestampAdapterPoolCapacity());
        this.timestampAdapterPool = new ObjectPool<TimestampAdapter>(TimestampAdapter::new, configuration.getTimestampAdapterPoolCapacity());
        this.inputFormatConfiguration = configuration.getInputFormatConfiguration();
        this.stringAdapter = new StringAdapter(utf8Sink);
        this.indexedSymbolAdapter = new SymbolAdapter(utf8Sink, true);
        this.notIndexedSymbolAdapter = new SymbolAdapter(utf8Sink, false);
        this.addDefaultProbes();
        ObjList<DateFormat> dateFormats = this.inputFormatConfiguration.getDateFormats();
        ObjList<DateLocale> dateLocales = this.inputFormatConfiguration.getDateLocales();
        IntList dateUtf8Flags = this.inputFormatConfiguration.getDateUtf8Flags();
        int n = dateFormats.size();
        for (int i = 0; i < n; ++i) {
            if (dateUtf8Flags.getQuick(i) == 1) {
                this.probes.add(new DateUtf8Adapter(utf8Sink).of(dateFormats.getQuick(i), dateLocales.getQuick(i)));
                continue;
            }
            this.probes.add(new DateAdapter().of(dateFormats.getQuick(i), dateLocales.getQuick(i)));
        }
        ObjList<DateFormat> timestampFormats = this.inputFormatConfiguration.getTimestampFormats();
        ObjList<DateLocale> timestampLocales = this.inputFormatConfiguration.getTimestampLocales();
        IntList timestampUtf8Flags = this.inputFormatConfiguration.getTimestampUtf8Flags();
        int n2 = timestampFormats.size();
        for (int i = 0; i < n2; ++i) {
            if (timestampUtf8Flags.getQuick(i) == 1) {
                this.probes.add(new TimestampUtf8Adapter(utf8Sink).of(timestampFormats.getQuick(i), timestampLocales.getQuick(i)));
                continue;
            }
            this.probes.add(new TimestampAdapter().of(timestampFormats.getQuick(i), timestampLocales.getQuick(i)));
        }
        this.probeCount = this.probes.size();
    }

    @Override
    public void clear() {
        this.dateAdapterPool.clear();
        this.timestampUtf8AdapterPool.clear();
        this.timestampAdapterPool.clear();
    }

    public ObjList<TypeAdapter> getAllAdapters() {
        return this.probes;
    }

    public InputFormatConfiguration getInputFormatConfiguration() {
        return this.inputFormatConfiguration;
    }

    public TypeAdapter getProbe(int index) {
        return this.probes.getQuick(index);
    }

    public int getProbeCount() {
        return this.probeCount;
    }

    public TypeAdapter getTypeAdapter(int columnType) {
        switch (ColumnType.tagOf(columnType)) {
            case 2: {
                return ByteAdapter.INSTANCE;
            }
            case 3: {
                return ShortAdapter.INSTANCE;
            }
            case 4: {
                return CharAdapter.INSTANCE;
            }
            case 5: {
                return IntAdapter.INSTANCE;
            }
            case 6: {
                return LongAdapter.INSTANCE;
            }
            case 1: {
                return BooleanAdapter.INSTANCE;
            }
            case 9: {
                return FloatAdapter.INSTANCE;
            }
            case 10: {
                return DoubleAdapter.INSTANCE;
            }
            case 11: {
                return this.stringAdapter;
            }
            case 12: {
                return this.nextSymbolAdapter(false);
            }
            case 13: {
                return Long256Adapter.INSTANCE;
            }
            case 19: {
                return UuidAdapter.INSTANCE;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                GeoHashAdapter adapter = GeoHashAdapter.getInstance(columnType);
                if (adapter == null) break;
                return adapter;
            }
        }
        throw CairoException.nonCritical().put("no adapter for type [id=").put(columnType).put(", name=").put(ColumnType.nameOf(columnType)).put(']');
    }

    public DateUtf8Adapter nextDateAdapter() {
        return this.dateAdapterPool.next();
    }

    public TypeAdapter nextSymbolAdapter(boolean indexed) {
        return indexed ? this.indexedSymbolAdapter : this.notIndexedSymbolAdapter;
    }

    public TypeAdapter nextTimestampAdapter(boolean decodeUtf8, DateFormat format, DateLocale locale) {
        if (decodeUtf8) {
            TimestampUtf8Adapter adapter = this.timestampUtf8AdapterPool.next();
            adapter.of(format, locale);
            return adapter;
        }
        TimestampAdapter adapter = this.timestampAdapterPool.next();
        adapter.of(format, locale);
        return adapter;
    }

    private void addDefaultProbes() {
        this.probes.add(this.getTypeAdapter(4));
        this.probes.add(this.getTypeAdapter(5));
        this.probes.add(this.getTypeAdapter(6));
        this.probes.add(this.getTypeAdapter(10));
        this.probes.add(this.getTypeAdapter(1));
        this.probes.add(this.getTypeAdapter(13));
        this.probes.add(this.getTypeAdapter(19));
    }
}

