/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.MessageBus;
import io.questdb.cutlass.text.CopyTask;
import io.questdb.cutlass.text.CsvFileIndexer;
import io.questdb.cutlass.text.TextLexerWrapper;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Job;
import io.questdb.mp.WorkerPool;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class CopyJob
extends AbstractQueueConsumerJob<CopyTask>
implements Closeable {
    private static final int INDEX_MERGE_LIST_CAPACITY = 64;
    private final long fileBufAddr;
    private long fileBufSize;
    private CsvFileIndexer indexer;
    private DirectLongList mergeIndexes;
    private TextLexerWrapper tlw;
    private Path tmpPath1;
    private Path tmpPath2;
    private DirectCharSink utf8Sink;

    public CopyJob(MessageBus messageBus) {
        super(messageBus.getTextImportQueue(), messageBus.getTextImportSubSeq());
        this.tlw = new TextLexerWrapper(messageBus.getConfiguration().getTextConfiguration());
        this.fileBufSize = messageBus.getConfiguration().getSqlCopyBufferSize();
        this.fileBufAddr = Unsafe.malloc(this.fileBufSize, 34);
        this.indexer = new CsvFileIndexer(messageBus.getConfiguration());
        this.utf8Sink = new DirectCharSink(messageBus.getConfiguration().getTextConfiguration().getUtf8SinkSize());
        this.mergeIndexes = new DirectLongList(64L, 34);
        this.tmpPath1 = new Path();
        this.tmpPath2 = new Path();
    }

    public static void assignToPool(MessageBus messageBus, WorkerPool pool) {
        int n = pool.getWorkerCount();
        for (int i = 0; i < n; ++i) {
            CopyJob job = new CopyJob(messageBus);
            pool.assign(i, job);
            pool.freeOnExit(job);
        }
    }

    @Override
    public void close() {
        this.tlw = Misc.free(this.tlw);
        this.indexer = Misc.free(this.indexer);
        if (this.fileBufSize > 0L) {
            Unsafe.free(this.fileBufAddr, this.fileBufSize, 34);
            this.fileBufSize = 0L;
        }
        this.mergeIndexes = Misc.free(this.mergeIndexes);
        this.utf8Sink = Misc.free(this.utf8Sink);
        this.tmpPath1 = Misc.free(this.tmpPath1);
        this.tmpPath2 = Misc.free(this.tmpPath2);
    }

    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        CopyTask task = (CopyTask)this.queue.get(cursor);
        boolean result = task.run(this.tlw, this.indexer, this.utf8Sink, this.mergeIndexes, this.fileBufAddr, this.fileBufSize, this.tmpPath1, this.tmpPath2);
        this.subSeq.done(cursor);
        return result;
    }

    Path getTmpPath1() {
        return this.tmpPath1;
    }

    Path getTmpPath2() {
        return this.tmpPath2;
    }
}

