/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.security.DenyAllSecurityContext;
import io.questdb.cutlass.text.AtomicBooleanCircuitBreaker;
import io.questdb.std.Mutable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;

public class CopyContext
implements Mutable {
    public static final long INACTIVE_COPY_ID = -1L;
    private final AtomicLong activeCopyID = new AtomicLong(-1L);
    private final AtomicBooleanCircuitBreaker circuitBreaker = new AtomicBooleanCircuitBreaker();
    private final LongSupplier copyIDSupplier;
    private SecurityContext originatorSecurityContext = DenyAllSecurityContext.INSTANCE;

    public CopyContext(CairoConfiguration configuration) {
        this.copyIDSupplier = configuration.getCopyIDSupplier();
    }

    public long assignActiveImportId(SecurityContext securityContext) {
        long id = this.copyIDSupplier.getAsLong();
        this.activeCopyID.set(id);
        this.originatorSecurityContext = securityContext;
        return id;
    }

    @Override
    public void clear() {
        this.activeCopyID.set(-1L);
        this.originatorSecurityContext = DenyAllSecurityContext.INSTANCE;
    }

    public long getActiveCopyID() {
        return this.activeCopyID.get();
    }

    public AtomicBooleanCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public SecurityContext getOriginatorSecurityContext() {
        return this.originatorSecurityContext;
    }
}

