/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.pgwire.UsernamePasswordMatcher;
import io.questdb.std.Chars;

public class StaticUsernamePasswordMatcher
implements UsernamePasswordMatcher {
    private final String defaultPassword;
    private final String defaultUsername;
    private final String roPassword;
    private final String roUsername;

    public StaticUsernamePasswordMatcher(PGWireConfiguration configuration) {
        this.defaultUsername = configuration.getDefaultUsername();
        this.defaultPassword = configuration.getDefaultPassword();
        if (configuration.isReadOnlyUserEnabled()) {
            this.roUsername = configuration.getReadOnlyUsername();
            this.roPassword = configuration.getReadOnlyPassword();
        } else {
            this.roUsername = null;
            this.roPassword = null;
        }
    }

    @Override
    public boolean match(CharSequence username, CharSequence password) {
        boolean matchRo = this.roUsername != null && this.roPassword != null && Chars.equals((CharSequence)this.roUsername, username) && Chars.equals((CharSequence)this.roPassword, password);
        return matchRo || Chars.equals((CharSequence)this.defaultUsername, username) && Chars.equals((CharSequence)this.defaultPassword, password);
    }
}

