/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cutlass.auth.Authenticator;
import io.questdb.cutlass.auth.AuthenticatorException;
import io.questdb.cutlass.pgwire.BadProtocolException;
import io.questdb.cutlass.pgwire.CircuitBreakerRegistry;
import io.questdb.cutlass.pgwire.OptionsListener;
import io.questdb.cutlass.pgwire.PGConnectionContext;
import io.questdb.cutlass.pgwire.PGKeywords;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.pgwire.UsernamePasswordMatcher;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectByteCharSequence;

public final class CleartextPasswordPgWireAuthenticator
implements Authenticator {
    public static final char STATUS_IDLE = 'I';
    private static final int INIT_CANCEL_REQUEST = 80877102;
    private static final int INIT_GSS_REQUEST = 80877104;
    private static final int INIT_SSL_REQUEST = 80877103;
    private static final int INIT_STARTUP_MESSAGE = 196608;
    private static final Log LOG = LogFactory.getLog(CleartextPasswordPgWireAuthenticator.class);
    private static final byte MESSAGE_TYPE_ERROR_RESPONSE = 69;
    private static final byte MESSAGE_TYPE_LOGIN_RESPONSE = 82;
    private static final byte MESSAGE_TYPE_PARAMETER_STATUS = 83;
    private static final byte MESSAGE_TYPE_PASSWORD_MESSAGE = 112;
    private static final byte MESSAGE_TYPE_READY_FOR_QUERY = 90;
    private final CharacterStore characterStore;
    private final NetworkSqlExecutionCircuitBreaker circuitBreaker;
    private final int circuitBreakerId;
    private final DirectByteCharSequence dbcs = new DirectByteCharSequence();
    private final UsernamePasswordMatcher matcher;
    private final NetworkFacade nf;
    private final OptionsListener optionsListener;
    private final CircuitBreakerRegistry registry;
    private final String serverVersion;
    private final ResponseSink sink;
    private int fd;
    private long recvBufEnd;
    private long recvBufReadPos;
    private long recvBufStart;
    private long recvBufWritePos;
    private long sendBufEnd;
    private long sendBufReadPos;
    private long sendBufStart;
    private long sendBufWritePos;
    private State state = State.EXPECT_INIT_MESSAGE;
    private CharSequence username;

    public CleartextPasswordPgWireAuthenticator(NetworkFacade nf, PGWireConfiguration configuration, NetworkSqlExecutionCircuitBreaker circuitBreaker, CircuitBreakerRegistry registry, OptionsListener optionsListener, UsernamePasswordMatcher matcher) {
        this.matcher = matcher;
        this.nf = nf;
        this.characterStore = new CharacterStore(configuration.getCharacterStoreCapacity(), configuration.getCharacterStorePoolCapacity());
        this.circuitBreakerId = registry.add(circuitBreaker);
        this.registry = registry;
        this.sink = new ResponseSink();
        this.serverVersion = configuration.getServerVersion();
        this.circuitBreaker = circuitBreaker;
        this.optionsListener = optionsListener;
    }

    @Override
    public void clear() {
        this.circuitBreaker.resetMaxTimeToDefault();
        this.circuitBreaker.unsetTimer();
    }

    @Override
    public void close() {
        this.registry.remove(this.circuitBreakerId);
        Misc.free(this.circuitBreaker);
    }

    @Override
    public CharSequence getPrincipal() {
        return this.username;
    }

    @Override
    public long getRecvBufPos() {
        return this.recvBufWritePos;
    }

    @Override
    public long getRecvBufPseudoStart() {
        return this.recvBufReadPos;
    }

    @Override
    public int handleIO() throws AuthenticatorException {
        try {
            block12: while (true) {
                switch (this.state) {
                    case EXPECT_INIT_MESSAGE: {
                        int r = this.readFromSocket();
                        if (r != -1) {
                            return r;
                        }
                        r = this.processInitMessage();
                        if (r == -1) continue block12;
                        return r;
                    }
                    case EXPECT_PASSWORD_MESSAGE: {
                        this.readFromSocket();
                        int r = this.processPasswordMessage();
                        if (r == -1) continue block12;
                        return r;
                    }
                    case WRITE_AND_EXPECT_PASSWORD_MESSAGE: {
                        int r = this.writeToSocketAndAdvance(State.EXPECT_PASSWORD_MESSAGE);
                        if (r == -1) continue block12;
                        return r;
                    }
                    case WRITE_AND_EXPECT_INIT_MESSAGE: {
                        int r = this.writeToSocketAndAdvance(State.EXPECT_INIT_MESSAGE);
                        if (r == -1) continue block12;
                        return r;
                    }
                    case WRITE_AND_AUTH_SUCCESS: {
                        int r = this.writeToSocketAndAdvance(State.AUTH_SUCCESS);
                        if (r == -1) continue block12;
                        return r;
                    }
                    case WRITE_AND_AUTH_FAILURE: {
                        this.writeToSocketAndAdvance(State.AUTH_FAILED);
                        continue block12;
                    }
                    case AUTH_SUCCESS: {
                        this.circuitBreaker.of(this.fd);
                        return -1;
                    }
                    case AUTH_FAILED: {
                        return 3;
                    }
                }
                if (!$assertionsDisabled) break;
            }
            throw new AssertionError();
        }
        catch (BadProtocolException e) {
            throw AuthenticatorException.INSTANCE;
        }
    }

    @Override
    public void init(int fd, long recvBuffer, long recvBufferLimit, long sendBuffer, long sendBufferLimit) {
        if (fd == -1) {
            this.circuitBreaker.setSecret(-1);
        } else {
            this.circuitBreaker.setSecret(this.registry.getNewSecret());
        }
        this.state = State.EXPECT_INIT_MESSAGE;
        this.username = null;
        this.fd = fd;
        this.recvBufStart = recvBuffer;
        this.recvBufReadPos = recvBuffer;
        this.recvBufWritePos = recvBuffer;
        this.recvBufEnd = recvBufferLimit;
        this.sendBufStart = sendBuffer;
        this.sendBufReadPos = sendBuffer;
        this.sendBufWritePos = sendBuffer;
        this.sendBufEnd = sendBufferLimit;
    }

    @Override
    public boolean isAuthenticated() {
        return this.state == State.AUTH_SUCCESS;
    }

    private static int getIntUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getInt(address));
    }

    private int availableToRead() {
        return (int)(this.recvBufWritePos - this.recvBufReadPos);
    }

    private void compactRecvBuf() {
        long len = this.recvBufWritePos - this.recvBufReadPos;
        if (len > 0L) {
            Vect.memcpy(this.recvBufStart, this.recvBufReadPos, len);
        }
        this.recvBufReadPos = this.recvBufStart;
        this.recvBufWritePos = this.recvBufStart + len;
    }

    private void compactSendBuf() {
        long len = this.sendBufWritePos - this.sendBufReadPos;
        if (len > 0L) {
            Vect.memcpy(this.sendBufStart, this.sendBufReadPos, len);
        }
        this.sendBufReadPos = this.sendBufStart;
        this.sendBufWritePos = this.sendBufStart + len;
    }

    private void ensureCapacity(int capacity) {
        if (this.sendBufWritePos + (long)capacity > this.sendBufEnd) {
            throw NoSpaceLeftInResponseBufferException.INSTANCE;
        }
    }

    private void prepareBackendKeyData(ResponseSink responseSink) {
        responseSink.put('K');
        responseSink.putInt(12);
        responseSink.putInt(this.circuitBreakerId);
        responseSink.putInt(this.circuitBreaker.getSecret());
    }

    private void prepareGssResponse() {
        this.sink.put('N');
    }

    private void prepareLoginOk() {
        this.sink.put((byte)82);
        this.sink.putInt(8);
        this.sink.putInt(0);
        this.prepareParams(this.sink, "TimeZone", "GMT");
        this.prepareParams(this.sink, "application_name", "QuestDB");
        this.prepareParams(this.sink, "server_version", this.serverVersion);
        this.prepareParams(this.sink, "integer_datetimes", "on");
        this.prepareParams(this.sink, "client_encoding", "UTF8");
        this.prepareBackendKeyData(this.sink);
        this.prepareReadyForQuery();
    }

    private void prepareLoginResponse() {
        this.sink.put((byte)82);
        this.sink.putInt(8);
        this.sink.putInt(3);
    }

    private void prepareParams(ResponseSink sink, CharSequence name, CharSequence value) {
        sink.put((byte)83);
        long addr = sink.skip();
        sink.encodeUtf8Z(name);
        sink.encodeUtf8Z(value);
        sink.putLen(addr);
    }

    private void prepareReadyForQuery() {
        this.sink.put((byte)90);
        this.sink.putInt(5);
        this.sink.put('I');
    }

    private void prepareSslResponse() {
        this.sink.put('N');
    }

    private void prepareWrongUsernamePasswordResponse() {
        this.sink.put((byte)69);
        long addr = this.sink.skip();
        this.sink.put('C');
        this.sink.encodeUtf8Z("00000");
        this.sink.put('M');
        this.sink.encodeUtf8Z("invalid username/password");
        this.sink.put('S');
        this.sink.encodeUtf8Z("ERROR");
        this.sink.put('\u0000');
        this.sink.putLen(addr);
    }

    private void processCancelMessage() {
        int pid = CleartextPasswordPgWireAuthenticator.getIntUnsafe(this.recvBufReadPos);
        this.recvBufReadPos += 4L;
        int secret = CleartextPasswordPgWireAuthenticator.getIntUnsafe(this.recvBufReadPos);
        this.recvBufReadPos += 4L;
        LOG.info().$("cancel request [pid=").$(pid).I$();
        try {
            this.registry.cancel(pid, secret);
        }
        catch (CairoException e) {
            LOG.error().$(e.getMessage()).$();
        }
    }

    private int processInitMessage() throws BadProtocolException {
        int availableToRead = this.availableToRead();
        if (availableToRead < 4) {
            return 0;
        }
        int msgLen = CleartextPasswordPgWireAuthenticator.getIntUnsafe(this.recvBufReadPos);
        if (msgLen > availableToRead) {
            return 0;
        }
        this.recvBufReadPos += 4L;
        int protocol = CleartextPasswordPgWireAuthenticator.getIntUnsafe(this.recvBufReadPos);
        this.recvBufReadPos += 4L;
        switch (protocol) {
            case 196608: {
                this.processStartupMessage(msgLen);
                break;
            }
            case 80877102: {
                this.processCancelMessage();
                return 3;
            }
            case 80877103: {
                this.compactRecvBuf();
                this.prepareSslResponse();
                this.state = State.WRITE_AND_EXPECT_INIT_MESSAGE;
                break;
            }
            case 80877104: {
                this.compactRecvBuf();
                this.prepareGssResponse();
                this.state = State.WRITE_AND_EXPECT_INIT_MESSAGE;
                break;
            }
            default: {
                LOG.error().$("unknown init message [protocol=").$(protocol).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
        return -1;
    }

    private int processPasswordMessage() throws BadProtocolException {
        int availableToRead = this.availableToRead();
        if (availableToRead < 5) {
            return 0;
        }
        byte msgType = Unsafe.getUnsafe().getByte(this.recvBufReadPos);
        assert (msgType == 112);
        int msgLen = CleartextPasswordPgWireAuthenticator.getIntUnsafe(this.recvBufReadPos + 1L);
        long msgLimit = this.recvBufReadPos + (long)msgLen + 1L;
        if (this.recvBufWritePos < msgLimit) {
            return 0;
        }
        this.recvBufReadPos += 5L;
        long hi = PGConnectionContext.getStringLength(this.recvBufReadPos, msgLimit, "bad password length");
        this.dbcs.of(this.recvBufReadPos, hi);
        if (this.matcher.match(this.username, this.dbcs)) {
            this.recvBufReadPos = msgLimit;
            this.compactRecvBuf();
            this.prepareLoginOk();
            this.state = State.WRITE_AND_AUTH_SUCCESS;
        } else {
            LOG.info().$("bad password for user [user=").$(this.username).$(']').$();
            this.prepareWrongUsernamePasswordResponse();
            this.state = State.WRITE_AND_AUTH_FAILURE;
        }
        return -1;
    }

    private void processStartupMessage(int msgLen) throws BadProtocolException {
        long msgLimit = this.recvBufStart + (long)msgLen;
        long lo = this.recvBufReadPos;
        while (lo < msgLimit - 1L) {
            long nameLo = lo;
            long nameHi = PGConnectionContext.getStringLength(lo, msgLimit, "malformed property name");
            long valueLo = nameHi + 1L;
            long valueHi = PGConnectionContext.getStringLength(valueLo, msgLimit, "malformed property value");
            lo = valueHi + 1L;
            if (PGKeywords.isUser(nameLo, nameHi - nameLo)) {
                CharacterStoreEntry e = this.characterStore.newEntry();
                e.put(this.dbcs.of(valueLo, valueHi));
                this.username = e.toImmutable();
            }
            boolean parsed = true;
            if (PGKeywords.isOptions(nameLo, nameHi - nameLo)) {
                if (PGKeywords.startsWithTimeoutOption(valueLo, valueHi - valueLo)) {
                    try {
                        this.dbcs.of(valueLo + 21L, valueHi);
                        long statementTimeout = Numbers.parseLong(this.dbcs);
                        this.optionsListener.setStatementTimeout(statementTimeout);
                    }
                    catch (NumericException ex) {
                        parsed = false;
                    }
                } else {
                    parsed = false;
                }
            }
            if (parsed) {
                LOG.debug().$("property [name=").$(this.dbcs.of(nameLo, nameHi)).$(", value=").$(this.dbcs.of(valueLo, valueHi)).$(']').$();
                continue;
            }
            LOG.info().$("invalid property [name=").$(this.dbcs.of(nameLo, nameHi)).$(", value=").$(this.dbcs.of(valueLo, valueHi)).$(']').$();
        }
        this.characterStore.clear();
        this.recvBufReadPos = msgLimit;
        this.compactRecvBuf();
        this.prepareLoginResponse();
        this.state = State.WRITE_AND_EXPECT_PASSWORD_MESSAGE;
    }

    private int readFromSocket() {
        int bytesRead = this.nf.recv(this.fd, this.recvBufWritePos, (int)(this.recvBufEnd - this.recvBufWritePos));
        if (bytesRead < 0) {
            return 3;
        }
        this.recvBufWritePos += (long)bytesRead;
        return -1;
    }

    private int writeToSocketAndAdvance(State nextState) {
        int toWrite = (int)(this.sendBufWritePos - this.sendBufReadPos);
        int bytesWritten = this.nf.send(this.fd, this.sendBufReadPos, toWrite);
        this.sendBufReadPos += (long)bytesWritten;
        this.compactSendBuf();
        if (this.sendBufReadPos == this.sendBufWritePos) {
            this.state = nextState;
            return -1;
        }
        return 1;
    }

    private class ResponseSink
    extends AbstractCharSink {
        private ResponseSink() {
        }

        @Override
        public CharSink put(char c) {
            CleartextPasswordPgWireAuthenticator.this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(CleartextPasswordPgWireAuthenticator.this.sendBufWritePos++, (byte)c);
            return this;
        }

        public void put(byte c) {
            CleartextPasswordPgWireAuthenticator.this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(CleartextPasswordPgWireAuthenticator.this.sendBufWritePos++, c);
        }

        public void putInt(int i) {
            CleartextPasswordPgWireAuthenticator.this.ensureCapacity(4);
            Unsafe.getUnsafe().putInt(CleartextPasswordPgWireAuthenticator.this.sendBufWritePos, Numbers.bswap(i));
            CleartextPasswordPgWireAuthenticator.this.sendBufWritePos += 4L;
        }

        public void putLen(long start) {
            int len = (int)(CleartextPasswordPgWireAuthenticator.this.sendBufWritePos - start);
            Unsafe.getUnsafe().putInt(start, Numbers.bswap(len));
        }

        void encodeUtf8Z(CharSequence value) {
            this.encodeUtf8(value);
            CleartextPasswordPgWireAuthenticator.this.ensureCapacity(1);
            this.put((byte)0);
        }

        long skip() {
            CleartextPasswordPgWireAuthenticator.this.ensureCapacity(4);
            long checkpoint = CleartextPasswordPgWireAuthenticator.this.sendBufWritePos;
            CleartextPasswordPgWireAuthenticator.this.sendBufWritePos += 4L;
            return checkpoint;
        }
    }

    private static enum State {
        EXPECT_INIT_MESSAGE,
        EXPECT_PASSWORD_MESSAGE,
        WRITE_AND_EXPECT_INIT_MESSAGE,
        WRITE_AND_EXPECT_PASSWORD_MESSAGE,
        WRITE_AND_AUTH_SUCCESS,
        WRITE_AND_AUTH_FAILURE,
        AUTH_SUCCESS,
        AUTH_FAILED;

    }
}

