/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp.auth;

import io.questdb.cairo.CairoException;
import io.questdb.cutlass.auth.Authenticator;
import io.questdb.cutlass.auth.AuthenticatorException;
import io.questdb.cutlass.auth.PublicKeyRepo;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NetworkFacade;
import io.questdb.std.Chars;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectByteCharSequence;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;

public class EllipticCurveAuthenticator
implements Authenticator {
    private static final int CHALLENGE_LEN = 512;
    private static final Log LOG = LogFactory.getLog(EllipticCurveAuthenticator.class);
    private static final int MIN_BUF_SIZE = 513;
    private static final ThreadLocal<Signature> tlSigDER = new ThreadLocal<Signature>(() -> {
        try {
            return Signature.getInstance("SHA256withECDSA");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error(ex);
        }
    });
    private static final ThreadLocal<Signature> tlSigP1363 = new ThreadLocal<Signature>(() -> {
        try {
            return Signature.getInstance("SHA256withECDSAinP1363Format");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error(ex);
        }
    });
    private static final ThreadLocal<SecureRandom> tlSrand = new ThreadLocal<SecureRandom>(SecureRandom::new);
    private final byte[] challengeBytes = new byte[512];
    private final NetworkFacade nf;
    private final PublicKeyRepo publicKeyRepo;
    private final DirectByteCharSequence userNameFlyweight = new DirectByteCharSequence();
    protected long recvBufPseudoStart;
    private AuthState authState;
    private int fd;
    private String principal;
    private PublicKey pubKey;
    private long recvBufEnd;
    private long recvBufPos;
    private long recvBufStart;

    public EllipticCurveAuthenticator(NetworkFacade networkFacade, PublicKeyRepo publicKeyRepo) {
        this.publicKeyRepo = publicKeyRepo;
        this.nf = networkFacade;
    }

    @Override
    public CharSequence getPrincipal() {
        return this.principal;
    }

    @Override
    public long getRecvBufPos() {
        return this.recvBufPos;
    }

    @Override
    public long getRecvBufPseudoStart() {
        return this.recvBufPseudoStart;
    }

    @Override
    public int handleIO() throws AuthenticatorException {
        switch (this.authState) {
            case WAITING_FOR_KEY_ID: {
                this.readKeyId();
                break;
            }
            case SENDING_CHALLENGE: {
                this.sendChallenge();
                break;
            }
            case WAITING_FOR_RESPONSE: {
                int p = this.waitForResponse();
                if (this.authState != AuthState.COMPLETE || this.recvBufPos <= this.recvBufStart) break;
                this.recvBufPseudoStart = this.recvBufStart + (long)p + 1L;
                break;
            }
        }
        return this.authState.ioContextResult;
    }

    @Override
    public void init(int fd, long recvBuffer, long recvBufferLimit, long sendBuffer, long sendBufferLimit) {
        if (recvBufferLimit - recvBuffer < 513L) {
            throw CairoException.critical(0).put("Minimum buffer length is ").put(513L);
        }
        this.fd = fd;
        this.authState = AuthState.WAITING_FOR_KEY_ID;
        this.pubKey = null;
        this.recvBufStart = recvBuffer;
        this.recvBufPos = recvBuffer;
        this.recvBufEnd = recvBufferLimit;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authState == AuthState.COMPLETE;
    }

    private static boolean checkAllZeros(byte[] signatureRaw) {
        int n = signatureRaw.length;
        for (int i = 0; i < n; ++i) {
            if (signatureRaw[i] == 0) continue;
            return false;
        }
        return true;
    }

    private int findLineEnd() throws AuthenticatorException {
        int bufferRemaining = (int)(this.recvBufEnd - this.recvBufPos);
        if (bufferRemaining > 0) {
            int bytesRead = this.nf.recv(this.fd, this.recvBufPos, bufferRemaining);
            if (bytesRead > 0) {
                this.recvBufPos += (long)bytesRead;
            } else if (bytesRead < 0) {
                LOG.info().$('[').$(this.fd).$("] authentication disconnected by peer when reading token").$();
                throw AuthenticatorException.INSTANCE;
            }
        }
        int len = (int)(this.recvBufPos - this.recvBufStart);
        int lineEnd = -1;
        for (int n = 0; n < len; ++n) {
            byte b = Unsafe.getUnsafe().getByte(this.recvBufStart + (long)n);
            if (b != 10) continue;
            lineEnd = n;
            break;
        }
        if (lineEnd != -1) {
            return lineEnd;
        }
        if (this.recvBufPos == this.recvBufEnd) {
            LOG.info().$('[').$(this.fd).$("] authentication token is too long").$();
            throw AuthenticatorException.INSTANCE;
        }
        return lineEnd;
    }

    private void readKeyId() throws AuthenticatorException {
        int lineEnd = this.findLineEnd();
        if (lineEnd != -1) {
            int n;
            this.userNameFlyweight.of(this.recvBufStart, this.recvBufStart + (long)lineEnd);
            this.principal = Chars.toString(this.userNameFlyweight);
            LOG.info().$('[').$(this.fd).$("] authentication read key id [keyId=").$(this.userNameFlyweight).$(']').$();
            this.pubKey = this.publicKeyRepo.getPublicKey(this.userNameFlyweight);
            this.recvBufPos = this.recvBufStart;
            SecureRandom srand = tlSrand.get();
            for (n = 0; n < 512; ++n) {
                assert (this.recvBufStart + (long)n < this.recvBufEnd);
                int r = (int)(srand.nextDouble() * 95.0) + 32;
                Unsafe.getUnsafe().putByte(this.recvBufStart + (long)n, (byte)r);
                this.challengeBytes[n] = (byte)r;
            }
            Unsafe.getUnsafe().putByte(this.recvBufStart + (long)n, (byte)10);
            this.authState = AuthState.SENDING_CHALLENGE;
        }
    }

    private void sendChallenge() throws AuthenticatorException {
        int nWritten;
        int n = 513 - (int)(this.recvBufPos - this.recvBufStart);
        assert (n > 0);
        while ((nWritten = this.nf.send(this.fd, this.recvBufPos, n)) > 0) {
            if (n == nWritten) {
                this.recvBufPos = this.recvBufStart;
                this.authState = AuthState.WAITING_FOR_RESPONSE;
                return;
            }
            this.recvBufPos += (long)nWritten;
        }
        if (nWritten == 0) {
            return;
        }
        LOG.info().$('[').$(this.fd).$("] authentication peer disconnected when challenge was being sent").$();
        throw AuthenticatorException.INSTANCE;
    }

    private int waitForResponse() throws AuthenticatorException {
        int lineEnd = this.findLineEnd();
        if (lineEnd != -1) {
            boolean verified;
            if (null == this.pubKey) {
                LOG.info().$('[').$(this.fd).$("] authentication failed, unknown key id").$();
                throw AuthenticatorException.INSTANCE;
            }
            byte[] signature = new byte[lineEnd];
            for (int n = 0; n < lineEnd; ++n) {
                signature[n] = Unsafe.getUnsafe().getByte(this.recvBufStart + (long)n);
            }
            this.authState = AuthState.FAILED;
            byte[] signatureRaw = Base64.getDecoder().decode(signature);
            Signature sig = signatureRaw.length == 64 ? tlSigP1363.get() : tlSigDER.get();
            try {
                if (EllipticCurveAuthenticator.checkAllZeros(signatureRaw)) {
                    LOG.info().$('[').$(this.fd).$("] invalid signature, can be cyber attack!").$();
                    throw AuthenticatorException.INSTANCE;
                }
                sig.initVerify(this.pubKey);
                sig.update(this.challengeBytes);
                verified = sig.verify(signatureRaw);
            }
            catch (InvalidKeyException | SignatureException ex) {
                LOG.info().$('[').$(this.fd).$("] authentication exception ").$(ex).$();
                throw AuthenticatorException.INSTANCE;
            }
            if (!verified) {
                LOG.info().$('[').$(this.fd).$("] authentication failed, signature was not verified").$();
                throw AuthenticatorException.INSTANCE;
            }
            this.authState = AuthState.COMPLETE;
            LOG.info().$('[').$(this.fd).$("] authentication success").$();
        }
        return lineEnd;
    }

    private static enum AuthState {
        WAITING_FOR_KEY_ID(0),
        SENDING_CHALLENGE(1),
        WAITING_FOR_RESPONSE(0),
        COMPLETE(-1),
        FAILED(3);

        private final int ioContextResult;

        private AuthState(int ioContextResult) {
            this.ioContextResult = ioContextResult;
        }
    }
}

