/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cutlass.auth.AuthUtils;
import io.questdb.cutlass.auth.PublicKeyRepo;
import io.questdb.std.CharSequenceObjHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.PublicKey;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticPublicKeyRepo
implements PublicKeyRepo {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\\s*(\\S+)(.*)");
    private final CharSequenceObjHashMap<PublicKey> publicKeyByKeyId = new CharSequenceObjHashMap();

    public StaticPublicKeyRepo(String authDbPath) {
        int nLine = 0;
        String[] tokens = new String[4];
        try (BufferedReader r = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(authDbPath))));){
            String line;
            do {
                String token;
                Matcher m;
                int nTokens = 0;
                line = r.readLine();
                ++nLine;
                while (null != line && (m = TOKEN_PATTERN.matcher(line)).matches() && !(token = m.group(1)).startsWith("#")) {
                    if (nTokens == tokens.length) {
                        throw new IllegalArgumentException("Too many tokens");
                    }
                    tokens[nTokens] = m.group(1);
                    ++nTokens;
                    line = m.group(2);
                }
                if (nTokens == 0) continue;
                if (nTokens != 4) {
                    throw new IllegalArgumentException("Was expecting 4 tokens");
                }
                if (!"ec-p-256-sha256".equals(tokens[1])) {
                    throw new IllegalArgumentException("Unrecognized type " + tokens[1]);
                }
                String keyId = tokens[0];
                if (!this.publicKeyByKeyId.excludes(keyId)) {
                    throw new IllegalArgumentException("Duplicate keyId " + keyId);
                }
                PublicKey publicKey = AuthUtils.toPublicKey(tokens[2], tokens[3]);
                this.publicKeyByKeyId.put(keyId, publicKey);
            } while (null != line);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("IO error, failed to read auth db file " + authDbPath + " at line " + nLine, ex);
        }
    }

    @Override
    public PublicKey getPublicKey(CharSequence keyId) {
        return this.publicKeyByKeyId.get(keyId);
    }
}

